/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle.spotless;

import com.diffplug.gradle.spotless.FormatExtension;
import com.diffplug.gradle.spotless.SpotlessExtension;
import com.diffplug.gradle.spotless.SpotlessTask;
import com.diffplug.spotless.FormatterStep;
import com.diffplug.spotless.Provisioner;
import com.diffplug.spotless.gherkin.GherkinUtilsStep;
import javax.inject.Inject;

public class GherkinExtension
extends FormatExtension {
    static final String NAME = "gherkin";

    @Inject
    public GherkinExtension(SpotlessExtension spotless) {
        super(spotless);
    }

    @Override
    protected void setupTask(SpotlessTask task) {
        if (this.target == null) {
            throw this.noDefaultTargetException();
        }
        super.setupTask(task);
    }

    public GherkinUtilsConfig gherkinUtils() {
        return new GherkinUtilsConfig();
    }

    public class GherkinUtilsConfig {
        private String version = GherkinUtilsStep.defaultVersion();
        private int indent = com.diffplug.spotless.gherkin.GherkinUtilsConfig.defaultIndentSpaces();

        public GherkinUtilsConfig() {
            GherkinExtension.this.addStep(this.createStep());
        }

        public void version(String version) {
            this.version = version;
            GherkinExtension.this.replaceStep(this.createStep());
        }

        private FormatterStep createStep() {
            return GherkinUtilsStep.create((com.diffplug.spotless.gherkin.GherkinUtilsConfig)new com.diffplug.spotless.gherkin.GherkinUtilsConfig(this.indent), (String)this.version, (Provisioner)GherkinExtension.this.provisioner());
        }
    }
}

