/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle.spotless;

import com.diffplug.common.collect.ImmutableSortedMap;
import com.diffplug.gradle.spotless.FormatExtension;
import com.diffplug.gradle.spotless.SpotlessExtension;
import com.diffplug.gradle.spotless.SpotlessTask;
import com.diffplug.spotless.FileSignature;
import com.diffplug.spotless.FormatterStep;
import com.diffplug.spotless.Provisioner;
import com.diffplug.spotless.kotlin.DiktatStep;
import com.diffplug.spotless.kotlin.KtLintStep;
import com.diffplug.spotless.kotlin.KtfmtStep;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import javax.inject.Inject;

public class KotlinGradleExtension
extends FormatExtension {
    private static final String GRADLE_KOTLIN_DSL_FILE_EXTENSION = "*.gradle.kts";
    static final String NAME = "kotlinGradle";

    @Inject
    public KotlinGradleExtension(SpotlessExtension spotless) {
        super(spotless);
    }

    public KotlinFormatExtension ktlint(String version) throws IOException {
        Objects.requireNonNull(version, "version");
        File defaultEditorConfig = this.getProject().getRootProject().file((Object)".editorconfig");
        FileSignature editorConfigPath = defaultEditorConfig.exists() ? FileSignature.signAsList((File[])new File[]{defaultEditorConfig}) : null;
        return new KotlinFormatExtension(version, editorConfigPath, Collections.emptyMap(), Collections.emptyMap());
    }

    public KotlinFormatExtension ktlint() throws IOException {
        return this.ktlint(KtLintStep.defaultVersion());
    }

    public KtfmtConfig ktfmt() {
        return this.ktfmt(KtfmtStep.defaultVersion());
    }

    public KtfmtConfig ktfmt(String version) {
        Objects.requireNonNull(version);
        return new KtfmtConfig(version);
    }

    public DiktatFormatExtension diktat(String version) {
        Objects.requireNonNull(version, "version");
        return new DiktatFormatExtension(version);
    }

    public DiktatFormatExtension diktat() {
        return this.diktat(DiktatStep.defaultVersionDiktat());
    }

    @Override
    protected void setupTask(SpotlessTask task) {
        if (this.target == null) {
            this.target = this.parseTarget(GRADLE_KOTLIN_DSL_FILE_EXTENSION);
        }
        super.setupTask(task);
    }

    public class DiktatFormatExtension {
        private final String version;
        private FileSignature config;

        DiktatFormatExtension(String version) {
            this.version = version;
            KotlinGradleExtension.this.addStep(this.createStep());
        }

        public DiktatFormatExtension configFile(Object file) throws IOException {
            this.config = file == null ? null : FileSignature.signAsList((File[])new File[]{KotlinGradleExtension.this.getProject().file(file)});
            KotlinGradleExtension.this.replaceStep(this.createStep());
            return this;
        }

        private FormatterStep createStep() {
            return DiktatStep.createForScript((String)this.version, (Provisioner)KotlinGradleExtension.this.provisioner(), (FileSignature)this.config);
        }
    }

    public class KtfmtConfig {
        final String version;
        KtfmtStep.Style style;
        KtfmtStep.KtfmtFormattingOptions options;
        private final ConfigurableStyle configurableStyle = new ConfigurableStyle();

        KtfmtConfig(String version) {
            this.version = Objects.requireNonNull(version);
            this.style = KtfmtStep.Style.DEFAULT;
            KotlinGradleExtension.this.addStep(this.createStep());
        }

        private ConfigurableStyle style(KtfmtStep.Style style) {
            this.style = style;
            KotlinGradleExtension.this.replaceStep(this.createStep());
            return this.configurableStyle;
        }

        public ConfigurableStyle dropboxStyle() {
            return this.style(KtfmtStep.Style.DROPBOX);
        }

        public ConfigurableStyle googleStyle() {
            return this.style(KtfmtStep.Style.GOOGLE);
        }

        public ConfigurableStyle kotlinlangStyle() {
            return this.style(KtfmtStep.Style.KOTLINLANG);
        }

        public void configure(Consumer<KtfmtStep.KtfmtFormattingOptions> optionsConfiguration) {
            this.configurableStyle.configure(optionsConfiguration);
        }

        private FormatterStep createStep() {
            return KtfmtStep.create((String)this.version, (Provisioner)KotlinGradleExtension.this.provisioner(), (KtfmtStep.Style)this.style, (KtfmtStep.KtfmtFormattingOptions)this.options);
        }

        public class ConfigurableStyle {
            public void configure(Consumer<KtfmtStep.KtfmtFormattingOptions> optionsConfiguration) {
                KtfmtStep.KtfmtFormattingOptions ktfmtFormattingOptions = new KtfmtStep.KtfmtFormattingOptions();
                optionsConfiguration.accept(ktfmtFormattingOptions);
                KtfmtConfig.this.options = ktfmtFormattingOptions;
                KotlinGradleExtension.this.replaceStep(KtfmtConfig.this.createStep());
            }
        }
    }

    public class KotlinFormatExtension {
        private final String version;
        @Nullable
        private FileSignature editorConfigPath;
        private Map<String, String> userData;
        private Map<String, Object> editorConfigOverride;

        KotlinFormatExtension(String version, FileSignature editorConfigPath, Map<String, String> config, Map<String, Object> editorConfigOverride) {
            this.version = version;
            this.editorConfigPath = editorConfigPath;
            this.userData = config;
            this.editorConfigOverride = editorConfigOverride;
            KotlinGradleExtension.this.addStep(this.createStep());
        }

        public KotlinFormatExtension setEditorConfigPath(Object editorConfigPath) throws IOException {
            this.editorConfigPath = editorConfigPath == null ? null : FileSignature.signAsList((File[])new File[]{KotlinGradleExtension.this.getProject().file(editorConfigPath)});
            KotlinGradleExtension.this.replaceStep(this.createStep());
            return this;
        }

        public KotlinFormatExtension userData(Map<String, String> userData) {
            this.userData = ImmutableSortedMap.copyOf(userData);
            KotlinGradleExtension.this.replaceStep(this.createStep());
            return this;
        }

        public KotlinFormatExtension editorConfigOverride(Map<String, Object> editorConfigOverride) {
            this.editorConfigOverride = ImmutableSortedMap.copyOf(editorConfigOverride);
            KotlinGradleExtension.this.replaceStep(this.createStep());
            return this;
        }

        private FormatterStep createStep() {
            return KtLintStep.createForScript((String)this.version, (Provisioner)KotlinGradleExtension.this.provisioner(), (FileSignature)this.editorConfigPath, this.userData, this.editorConfigOverride);
        }
    }
}

