/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle.spotless;

import com.diffplug.gradle.spotless.SpotlessTask;
import com.diffplug.spotless.Formatter;
import com.diffplug.spotless.PaddedCell;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Locale;
import org.gradle.api.DefaultTask;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.TaskAction;

public class SpotlessDiagnoseTask
extends DefaultTask {
    SpotlessTask source;

    @Internal
    public SpotlessTask getSource() {
        return this.source;
    }

    @TaskAction
    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    public void performAction() throws IOException {
        Path srcRoot = this.getProject().getProjectDir().toPath();
        Path diagnoseRoot = this.getProject().getBuildDir().toPath().resolve("spotless-diagnose-" + this.source.formatName());
        this.getProject().delete(new Object[]{diagnoseRoot.toFile()});
        try (Formatter formatter = this.source.buildFormatter();){
            for (File file : this.source.target) {
                this.getLogger().debug("Running padded cell check on " + file);
                PaddedCell padded = PaddedCell.check((Formatter)formatter, (File)file);
                if (!padded.misbehaved()) {
                    this.getLogger().debug("    well-behaved.");
                    continue;
                }
                Path relative = srcRoot.relativize(file.toPath());
                Path diagnoseFile = diagnoseRoot.resolve(relative);
                for (int i = 0; i < padded.steps().size(); ++i) {
                    Path path = Paths.get(diagnoseFile + "." + padded.type().name().toLowerCase(Locale.ROOT) + i, new String[0]);
                    Files.createDirectories(path.getParent(), new FileAttribute[0]);
                    String version = (String)padded.steps().get(i);
                    Files.write(path, version.getBytes(formatter.getEncoding()), new OpenOption[0]);
                }
                this.getLogger().lifecycle("    " + relative + " " + padded.userMessage());
            }
        }
        if (Files.exists(diagnoseRoot, new LinkOption[0])) {
            this.getLogger().lifecycle("Some formatters are misbehaving, you can see details at " + diagnoseRoot);
        } else {
            this.getLogger().lifecycle("All formatters are well behaved for all files.");
        }
    }
}

