/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle.spotless;

import com.diffplug.common.base.Preconditions;
import com.diffplug.common.base.Unhandled;
import com.diffplug.gradle.spotless.GitRatchetGradle;
import com.diffplug.gradle.spotless.GradleProvisioner;
import com.diffplug.gradle.spotless.SpotlessApply;
import com.diffplug.gradle.spotless.SpotlessCheck;
import com.diffplug.gradle.spotless.SpotlessTask;
import com.diffplug.gradle.spotless.SpotlessTaskImpl;
import com.diffplug.spotless.Provisioner;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.services.BuildService;
import org.gradle.api.services.BuildServiceParameters;
import org.gradle.api.tasks.Internal;
import org.gradle.tooling.events.FinishEvent;
import org.gradle.tooling.events.OperationCompletionListener;

public abstract class SpotlessTaskService
implements BuildService<BuildServiceParameters.None>,
AutoCloseable,
OperationCompletionListener {
    private final Map<String, SpotlessApply> apply = Collections.synchronizedMap(new HashMap());
    private final Map<String, SpotlessTask> source = Collections.synchronizedMap(new HashMap());
    private final Map<String, Provisioner> provisioner = Collections.synchronizedMap(new HashMap());
    private final GitRatchetGradle ratchet = new GitRatchetGradle();
    static String INDEPENDENT_HELPER = "Helper";

    Provisioner provisionerFor(Project project) {
        return this.provisioner.computeIfAbsent(project.getPath(), unused -> GradleProvisioner.newDedupingProvisioner(project));
    }

    void registerSourceAlreadyRan(SpotlessTask task) {
        this.source.put(task.getPath(), task);
    }

    void registerApplyAlreadyRan(SpotlessApply task) {
        this.apply.put(task.sourceTaskPath(), task);
    }

    GitRatchetGradle getRatchet() {
        return this.ratchet;
    }

    public void onFinish(FinishEvent var1) {
    }

    @Override
    public void close() throws Exception {
        this.ratchet.close();
    }

    static abstract class ClientTask
    extends DefaultTask {
        ClientTask() {
        }

        @Internal
        abstract Property<File> getSpotlessOutDirectory();

        @Internal
        abstract Property<SpotlessTaskService> getTaskService();

        @Internal
        abstract DirectoryProperty getProjectDir();

        @Inject
        protected abstract ObjectFactory getConfigCacheWorkaround();

        void init(SpotlessTaskImpl impl) {
            this.getSpotlessOutDirectory().set((Object)impl.getOutputDirectory());
            this.getTaskService().set(impl.getTaskService());
            this.getProjectDir().set((Provider)impl.getProjectDir());
        }

        String sourceTaskPath() {
            String path = this.getPath();
            if (this instanceof SpotlessApply) {
                if (path.endsWith("Apply")) {
                    return path.substring(0, path.length() - "Apply".length());
                }
                return path + INDEPENDENT_HELPER;
            }
            if (this instanceof SpotlessCheck) {
                Preconditions.checkArgument((boolean)path.endsWith("Check"));
                return path.substring(0, path.length() - "Check".length());
            }
            throw Unhandled.classException((Object)((Object)this));
        }

        private SpotlessTaskService service() {
            return (SpotlessTaskService)this.getTaskService().get();
        }

        protected boolean sourceDidWork() {
            SpotlessTask sourceTask = (SpotlessTask)((Object)this.service().source.get(this.sourceTaskPath()));
            if (sourceTask != null) {
                return sourceTask.getDidWork();
            }
            return false;
        }

        protected boolean applyHasRun() {
            return this.service().apply.containsKey(this.sourceTaskPath());
        }
    }
}

