/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle.spotless;

import com.diffplug.common.base.Errors;
import com.diffplug.common.io.ByteStreams;
import com.diffplug.gradle.spotless.SpotlessTaskImpl;
import com.diffplug.spotless.Formatter;
import com.diffplug.spotless.PaddedCell;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import org.gradle.api.file.Directory;

class IdeHook {
    static final String PROPERTY = "spotlessIdeHook";
    static final String USE_STD_IN = "spotlessIdeHookUseStdIn";
    static final String USE_STD_OUT = "spotlessIdeHookUseStdOut";

    IdeHook() {
    }

    private static void dumpIsClean() {
        System.err.println("IS CLEAN");
    }

    static void performHook(SpotlessTaskImpl spotlessTask) {
        String path = (String)spotlessTask.getProject().property(PROPERTY);
        File file = new File(path);
        if (!file.isAbsolute()) {
            System.err.println("Argument passed to spotlessIdeHook must be an absolute path");
            return;
        }
        if (spotlessTask.getTarget().contains(file)) {
            try (Formatter formatter = spotlessTask.buildFormatter();){
                if (spotlessTask.getRatchet() != null && spotlessTask.getRatchet().isClean(((Directory)spotlessTask.getProjectDir().get()).getAsFile(), spotlessTask.getRootTreeSha(), file)) {
                    IdeHook.dumpIsClean();
                    return;
                }
                byte[] bytes = spotlessTask.getProject().hasProperty(USE_STD_IN) ? ByteStreams.toByteArray((InputStream)System.in) : Files.readAllBytes(file.toPath());
                PaddedCell.DirtyState dirty = PaddedCell.calculateDirtyState((Formatter)formatter, (File)file, (byte[])bytes);
                if (dirty.isClean()) {
                    IdeHook.dumpIsClean();
                } else if (dirty.didNotConverge()) {
                    System.err.println("DID NOT CONVERGE");
                    System.err.println("Run 'spotlessDiagnose' for details https://github.com/diffplug/spotless/blob/main/PADDEDCELL.md");
                } else {
                    System.err.println("IS DIRTY");
                    if (spotlessTask.getProject().hasProperty(USE_STD_OUT)) {
                        dirty.writeCanonicalTo((OutputStream)System.out);
                    } else {
                        dirty.writeCanonicalTo(file);
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace(System.err);
                throw Errors.asRuntime((Throwable)e);
            }
            finally {
                System.err.close();
                System.out.close();
            }
        }
    }
}

