/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle.spotless;

import com.diffplug.common.collect.ImmutableList;
import com.diffplug.common.collect.Iterables;
import com.diffplug.gradle.spotless.DiffMessageFormatter;
import com.diffplug.gradle.spotless.PaddedCellGradle;
import com.diffplug.gradle.spotless.PluginGradlePreconditions;
import com.diffplug.gradle.spotless.SerializableMisc;
import com.diffplug.spotless.FormatExceptionPolicy;
import com.diffplug.spotless.FormatExceptionPolicyStrict;
import com.diffplug.spotless.Formatter;
import com.diffplug.spotless.FormatterStep;
import com.diffplug.spotless.LineEnding;
import com.diffplug.spotless.PaddedCell;
import com.diffplug.spotless.PaddedCellBulk;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.incremental.IncrementalTaskInputs;

public class SpotlessTask
extends DefaultTask {
    protected String encoding = "UTF-8";
    protected LineEnding.Policy lineEndingsPolicy = LineEnding.UNIX.createPolicy();
    protected boolean paddedCell = false;
    protected FormatExceptionPolicy exceptionPolicy = new FormatExceptionPolicyStrict();
    protected Iterable<File> target;
    protected List<FormatterStep> steps = new ArrayList<FormatterStep>();
    private boolean check = false;
    private boolean apply = false;

    @Input
    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = Objects.requireNonNull(encoding);
    }

    @Input
    public LineEnding.Policy getLineEndingsPolicy() {
        return this.lineEndingsPolicy;
    }

    public void setLineEndingsPolicy(LineEnding.Policy lineEndingsPolicy) {
        this.lineEndingsPolicy = Objects.requireNonNull(lineEndingsPolicy);
    }

    @Input
    public boolean isPaddedCell() {
        return this.paddedCell;
    }

    public void setPaddedCell(boolean paddedCell) {
        this.paddedCell = paddedCell;
    }

    public void setExceptionPolicy(FormatExceptionPolicy exceptionPolicy) {
        this.exceptionPolicy = Objects.requireNonNull(exceptionPolicy);
    }

    @Input
    public FormatExceptionPolicy getExceptionPolicy() {
        return this.exceptionPolicy;
    }

    public Iterable<File> getTarget() {
        return this.target;
    }

    public void setTarget(Iterable<File> target) {
        this.target = PluginGradlePreconditions.requireElementsNonNull(target);
    }

    @InputFiles
    @Deprecated
    public Iterable<File> getInternalTarget() {
        return Iterables.concat((Iterable)ImmutableList.of((Object)this.getCacheFile()), this.target);
    }

    private File getCacheFile() {
        return new File(this.getProject().getBuildDir(), this.getName());
    }

    @Input
    public List<FormatterStep> getSteps() {
        return Collections.unmodifiableList(this.steps);
    }

    public void setSteps(List<FormatterStep> steps) {
        this.steps = PluginGradlePreconditions.requireElementsNonNull(steps);
    }

    public boolean addStep(FormatterStep step) {
        return this.steps.add(Objects.requireNonNull(step));
    }

    public void setCheck() {
        this.check = true;
    }

    public void setApply() {
        this.apply = true;
    }

    String formatName() {
        String name = this.getName();
        if (name.startsWith("spotless")) {
            return name.substring("spotless".length()).toLowerCase(Locale.ROOT);
        }
        return name;
    }

    @TaskAction
    public void performAction(IncrementalTaskInputs inputs) throws Exception {
        List<File> changedFiles;
        if (this.target == null) {
            throw new GradleException("You must specify 'Iterable<File> toFormat'");
        }
        if (!this.check && !this.apply) {
            throw new GradleException("Don't call " + this.getName() + " directly, call " + this.getName() + "Check" + " or " + this.getName() + "Apply");
        }
        Formatter formatter = Formatter.builder().lineEndingsPolicy(this.lineEndingsPolicy).encoding(Charset.forName(this.encoding)).rootDir(this.getProject().getProjectDir().toPath()).steps(this.steps).exceptionPolicy(this.exceptionPolicy).build();
        ArrayList<File> outOfDate = new ArrayList<File>();
        inputs.outOfDate(inputDetails -> {
            File file = inputDetails.getFile();
            if (file.isFile() && !file.equals(this.getCacheFile())) {
                outOfDate.add(file);
            }
        });
        if (this.getCacheFile().exists()) {
            LastApply lastApply = SerializableMisc.fromFile(LastApply.class, this.getCacheFile());
            for (File file : lastApply.changedFiles) {
                if (outOfDate.contains(file) || !file.exists()) continue;
                outOfDate.add(file);
            }
        }
        if (this.apply && !(changedFiles = this.applyAnyChanged(formatter, outOfDate)).isEmpty()) {
            LastApply lastApply = new LastApply();
            lastApply.timestamp = System.currentTimeMillis();
            lastApply.changedFiles = changedFiles;
            SerializableMisc.toFile(lastApply, this.getCacheFile());
        }
        if (this.check) {
            this.check(formatter, outOfDate);
        }
    }

    private List<File> applyAnyChanged(Formatter formatter, List<File> outOfDate) throws Exception {
        ArrayList<File> changed = new ArrayList<File>(outOfDate.size());
        if (this.isPaddedCell()) {
            for (File file : outOfDate) {
                this.getLogger().debug("Applying format to " + file);
                if (!PaddedCellBulk.applyAnyChanged((Formatter)formatter, (File)file)) continue;
                changed.add(file);
            }
        } else {
            boolean anyMisbehave = false;
            for (File file : outOfDate) {
                String onceMore;
                this.getLogger().debug("Applying format to " + file);
                String unixResultIfDirty = formatter.applyToAndReturnResultIfDirty(file);
                if (unixResultIfDirty != null) {
                    changed.add(file);
                }
                if (anyMisbehave || unixResultIfDirty == null || (onceMore = formatter.compute(unixResultIfDirty, file)).equals(unixResultIfDirty)) continue;
                PaddedCell result = PaddedCell.check((Formatter)formatter, (File)file, (String)onceMore);
                if (result.type() == PaddedCell.Type.CONVERGE) {
                    String finalResult = formatter.computeLineEndings(result.canonical(), file);
                    Files.write(file.toPath(), finalResult.getBytes(formatter.getEncoding()), StandardOpenOption.TRUNCATE_EXISTING);
                    continue;
                }
                anyMisbehave = true;
            }
            if (anyMisbehave) {
                throw PaddedCellGradle.youShouldTurnOnPaddedCell(this);
            }
        }
        return changed;
    }

    private void check(Formatter formatter, List<File> outOfDate) throws Exception {
        ArrayList<File> problemFiles = new ArrayList<File>();
        for (File file : outOfDate) {
            this.getLogger().debug("Checking format on " + file);
            if (formatter.isClean(file)) continue;
            problemFiles.add(file);
        }
        if (this.paddedCell) {
            PaddedCellGradle.check(this, formatter, problemFiles);
        } else if (!problemFiles.isEmpty()) {
            if (PaddedCellBulk.anyMisbehave((Formatter)formatter, problemFiles)) {
                throw PaddedCellGradle.youShouldTurnOnPaddedCell(this);
            }
            throw this.formatViolationsFor(formatter, problemFiles);
        }
    }

    GradleException formatViolationsFor(Formatter formatter, List<File> problemFiles) throws IOException {
        return new GradleException(DiffMessageFormatter.messageFor(this, formatter, problemFiles));
    }

    static class LastApply
    implements Serializable {
        private static final long serialVersionUID = 6245070824310295090L;
        long timestamp;
        List<File> changedFiles;

        LastApply() {
        }
    }
}

