/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle.spotless;

import com.diffplug.common.base.StringPrinter;
import com.diffplug.spotless.Provisioner;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.dsl.DependencyHandler;

public class GradleProvisioner {
    private static final Logger logger = Logger.getLogger(GradleProvisioner.class.getName());

    private GradleProvisioner() {
    }

    public static Provisioner fromProject(Project project) {
        Objects.requireNonNull(project);
        return mavenCoords -> {
            try {
                Dependency[] deps = (Dependency[])mavenCoords.stream().map(arg_0 -> ((DependencyHandler)project.getBuildscript().getDependencies()).create(arg_0)).toArray(Dependency[]::new);
                Configuration config = project.getRootProject().getBuildscript().getConfigurations().detachedConfiguration(deps);
                config.setDescription(mavenCoords.toString());
                return config.resolve();
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, StringPrinter.buildStringFromLines((String[])new String[]{"You probably need to add a repository containing the '" + mavenCoords + "' artifact in the 'build.gradle' of your root project.", "E.g.: 'buildscript { repositories { mavenCentral() }}'", "Note that included buildscripts (using 'apply from') do not share their buildscript repositories with the underlying project.", "You have to specify the missing repository explicitly in the buildscript of the root project."}), e);
                throw e;
            }
        };
    }
}

