/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle.spotless;

import com.diffplug.gradle.spotless.SpotlessExtension;
import com.diffplug.gradle.spotless.SpotlessPluginConfigAvoidance;
import com.diffplug.gradle.spotless.SpotlessPluginLegacy;
import com.diffplug.spotless.SpotlessCache;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.plugins.BasePlugin;
import org.gradle.util.GradleVersion;

public class SpotlessPlugin
implements Plugin<Project> {
    SpotlessExtension spotlessExtension;

    public void apply(Project project) {
        project.getPlugins().apply(BasePlugin.class);
        this.spotlessExtension = (SpotlessExtension)project.getExtensions().create("spotless", SpotlessExtension.class, new Object[]{project});
        Task clean = project.getTasks().getByName("clean");
        clean.doLast(unused -> SpotlessCache.clear());
        project.afterEvaluate(unused -> {
            if (this.spotlessExtension.enforceCheck) {
                if (GradleVersion.current().compareTo(SpotlessPluginLegacy.CONFIG_AVOIDANCE_INTRODUCED) >= 0) {
                    SpotlessPluginConfigAvoidance.enforceCheck(this.spotlessExtension, project);
                } else {
                    SpotlessPluginLegacy.enforceCheck(this.spotlessExtension, project);
                }
            }
        });
    }

    public SpotlessExtension getExtension() {
        return this.spotlessExtension;
    }

    static String capitalize(String input) {
        return Character.toUpperCase(input.charAt(0)) + input.substring(1);
    }
}

