/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.npm;

import com.diffplug.spotless.ThrowingEx;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystemException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ShadowCopy {
    private static final Logger LOGGER = LoggerFactory.getLogger(ShadowCopy.class);
    private final Supplier<File> shadowCopyRootSupplier;

    public ShadowCopy(@Nonnull Supplier<File> shadowCopyRootSupplier) {
        this.shadowCopyRootSupplier = shadowCopyRootSupplier;
    }

    private File shadowCopyRoot() {
        File shadowCopyRoot = this.shadowCopyRootSupplier.get();
        if (!shadowCopyRoot.isDirectory()) {
            throw new IllegalStateException("Shadow copy root must be a directory: " + String.valueOf(shadowCopyRoot));
        }
        return shadowCopyRoot;
    }

    public void addEntry(String key, File orig) {
        File target = this.entry(key, orig.getName());
        if (target.exists()) {
            LOGGER.debug("Shadow copy entry already exists, not overwriting: {}", (Object)key);
        } else {
            try {
                this.storeEntry(key, orig, target);
            }
            catch (Throwable ex) {
                LOGGER.warn("Unable to store cache entry for {}", (Object)key, (Object)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    private void storeEntry(String key, File orig, File target) throws IOException {
        Files.createDirectories(target.toPath().getParent(), new FileAttribute[0]);
        Path tempDirectory = Files.createTempDirectory(target.toPath().getParent(), key, new FileAttribute[0]);
        LOGGER.debug("Will store entry {} to temporary directory {}, which is a sibling of the ultimate target {}", new Object[]{orig, tempDirectory, target});
        try {
            Files.walkFileTree(orig.toPath(), new CopyDirectoryRecursively(tempDirectory, orig.toPath()));
            try {
                LOGGER.debug("Finished storing entry {}. Atomically moving temporary directory {} into final place {}", new Object[]{key, tempDirectory, target});
                Files.move(tempDirectory, target.toPath(), StandardCopyOption.ATOMIC_MOVE);
            }
            catch (DirectoryNotEmptyException | FileAlreadyExistsException e) {
                LOGGER.debug("Shadow copy entry now exists, not overwriting: {}", (Object)key);
            }
            catch (AtomicMoveNotSupportedException e) {
                LOGGER.warn("The filesystem at {} does not support atomic moves. Spotless cannot safely cache on such a system due to race conditions. Caching has been skipped.", (Object)target.toPath().getParent(), (Object)e);
            }
        }
        finally {
            if (Files.exists(tempDirectory, new LinkOption[0])) {
                try {
                    Files.walkFileTree(tempDirectory, new DeleteDirectoryRecursively());
                }
                catch (Throwable ex) {
                    LOGGER.warn("Ignoring error while cleaning up temporary copy", ex);
                }
            }
        }
    }

    public File getEntry(String key, String fileName) {
        return this.entry(key, fileName);
    }

    private File entry(String key, String origName) {
        return Path.of(this.shadowCopyRoot().getAbsolutePath(), key, origName).toFile();
    }

    public File copyEntryInto(String key, String origName, File targetParentFolder) {
        File target = Path.of(targetParentFolder.getAbsolutePath(), origName).toFile();
        if (target.exists()) {
            LOGGER.warn("Shadow copy destination already exists, deleting! {}: {}", (Object)key, (Object)target);
            ThrowingEx.run(() -> Files.walkFileTree(target.toPath(), new DeleteDirectoryRecursively()));
        }
        ThrowingEx.run(() -> Files.walkFileTree(this.entry(key, origName).toPath(), new CopyDirectoryRecursively(target.toPath(), this.entry(key, origName).toPath())));
        return target;
    }

    public boolean entryExists(String key, String origName) {
        return this.entry(key, origName).exists();
    }

    private static class CopyDirectoryRecursively
    extends SimpleFileVisitor<Path> {
        private final Path target;
        private final Path orig;
        private boolean tryHardLink = true;

        public CopyDirectoryRecursively(Path target, Path orig) {
            this.target = target;
            this.orig = orig;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
            Files.createDirectories(this.target.resolve(this.orig.relativize(dir)), new FileAttribute[0]);
            return super.preVisitDirectory(dir, attrs);
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            if (this.tryHardLink) {
                try {
                    Files.createLink(this.target.resolve(this.orig.relativize(file)), file);
                    return super.visitFile(file, attrs);
                }
                catch (SecurityException | UnsupportedOperationException | FileSystemException e) {
                    LOGGER.debug("Shadow copy entry does not support hard links: {}. Switching to 'copy'.", (Object)file, (Object)e);
                    this.tryHardLink = false;
                }
                catch (IOException e) {
                    LOGGER.debug("Shadow copy entry failed to create hard link: {}. Switching to 'copy'.", (Object)file, (Object)e);
                    this.tryHardLink = false;
                }
            }
            Files.copy(file, this.target.resolve(this.orig.relativize(file)), new CopyOption[0]);
            return super.visitFile(file, attrs);
        }
    }

    private static class DeleteDirectoryRecursively
    extends SimpleFileVisitor<Path> {
        private DeleteDirectoryRecursively() {
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            Files.delete(file);
            return super.visitFile(file, attrs);
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
            Files.delete(dir);
            return super.postVisitDirectory(dir, exc);
        }
    }
}

