/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.npm;

import com.diffplug.spotless.npm.JsonRawValue;
import com.diffplug.spotless.npm.ListableAdapter;
import java.util.Objects;

final class JsonEscaper {
    private JsonEscaper() {
    }

    public static String jsonEscape(Object val) {
        Objects.requireNonNull(val);
        if (val instanceof JsonRawValue) {
            JsonRawValue value = (JsonRawValue)val;
            return JsonEscaper.jsonEscape(value);
        }
        if (val instanceof String) {
            String string = (String)val;
            return JsonEscaper.jsonEscape(string);
        }
        if (ListableAdapter.canAdapt(val)) {
            StringBuilder sb = new StringBuilder();
            sb.append('[');
            boolean first = true;
            for (Object o : ListableAdapter.adapt(val)) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(JsonEscaper.jsonEscape(o));
            }
            sb.append(']');
            return sb.toString();
        }
        return val.toString();
    }

    private static String jsonEscape(JsonRawValue jsonRawValue) {
        return jsonRawValue.getRawJson();
    }

    private static String jsonEscape(String unescaped) {
        StringBuilder escaped = new StringBuilder();
        escaped.append('\"');
        char c = '\u0000';
        block10: for (int i = 0; i < unescaped.length(); ++i) {
            char b = c;
            c = unescaped.charAt(i);
            switch (c) {
                case '\"': {
                    escaped.append('\\').append('\"');
                    continue block10;
                }
                case '\n': {
                    escaped.append('\\').append('n');
                    continue block10;
                }
                case '\r': {
                    escaped.append('\\').append('r');
                    continue block10;
                }
                case '\t': {
                    escaped.append('\\').append('t');
                    continue block10;
                }
                case '\b': {
                    escaped.append('\\').append('b');
                    continue block10;
                }
                case '\f': {
                    escaped.append('\\').append('f');
                    continue block10;
                }
                case '\\': {
                    escaped.append('\\').append('\\');
                    continue block10;
                }
                case '/': {
                    if (b == '<') {
                        escaped.append('\\');
                    }
                    escaped.append(c);
                    continue block10;
                }
                default: {
                    if (c < ' ' || c >= '\u0080' && c < '\u00a0' || c >= '\u2000' && c < '\u2100') {
                        escaped.append('\\').append('u');
                        String hexString = Integer.toHexString(c);
                        escaped.append("0000", 0, 4 - hexString.length());
                        escaped.append(hexString);
                        continue block10;
                    }
                    escaped.append(c);
                }
            }
        }
        escaped.append('\"');
        return escaped.toString();
    }
}

