/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless;

import com.diffplug.spotless.FeatureClassLoader;
import com.diffplug.spotless.JarState;
import com.diffplug.spotless.LazyForwardingEquality;
import com.diffplug.spotless.ThrowingEx;
import java.io.IOException;
import java.io.Serializable;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SpotlessCache {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpotlessCache.class);
    final Map<SerializedKey, URLClassLoader> cache = new HashMap<SerializedKey, URLClassLoader>();
    private static volatile Object lastClear;
    private static final SpotlessCache instance;

    synchronized ClassLoader classloader(JarState state) {
        return this.classloader(state, state);
    }

    synchronized ClassLoader classloader(Serializable key, JarState state) {
        SerializedKey serializedKey = new SerializedKey(key);
        return this.cache.computeIfAbsent(serializedKey, k -> {
            LOGGER.debug("Allocating an additional FeatureClassLoader for key={} Cache.size was {}", (Object)key, (Object)this.cache.size());
            return new FeatureClassLoader(state.jarUrls(), this.getClass().getClassLoader());
        });
    }

    static SpotlessCache instance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void clear() {
        ArrayList<URLClassLoader> toDelete;
        SpotlessCache spotlessCache = instance;
        synchronized (spotlessCache) {
            toDelete = new ArrayList<URLClassLoader>(SpotlessCache.instance.cache.values());
            SpotlessCache.instance.cache.clear();
        }
        for (URLClassLoader classLoader : toDelete) {
            try {
                classLoader.close();
            }
            catch (IOException e) {
                throw ThrowingEx.asRuntime(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean clearOnce(@Nullable Object key) {
        SpotlessCache spotlessCache = instance;
        synchronized (spotlessCache) {
            if (key == null) {
                lastClear = null;
            } else if (key.equals(lastClear)) {
                return false;
            }
            lastClear = key;
        }
        SpotlessCache.clear();
        return true;
    }

    static {
        instance = new SpotlessCache();
    }

    static final class SerializedKey {
        final byte[] serialized;
        final int hashCode;

        SerializedKey(Serializable key) {
            Objects.requireNonNull(key);
            this.serialized = LazyForwardingEquality.toBytes(key);
            this.hashCode = Arrays.hashCode(this.serialized);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean equals(Object other) {
            if (!(other instanceof SerializedKey)) return false;
            SerializedKey sk = (SerializedKey)other;
            if (!Arrays.equals(this.serialized, sk.serialized)) return false;
            return true;
        }

        public final int hashCode() {
            return this.hashCode;
        }
    }
}

