/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless;

import com.diffplug.spotless.NoLambda;
import com.diffplug.spotless.ThrowingEx;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.function.Supplier;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum LineEnding {
    GIT_ATTRIBUTES{

        @Override
        @Deprecated
        public Policy createPolicy() {
            return super.createPolicy();
        }
    }
    ,
    GIT_ATTRIBUTES_FAST_ALLSAME{

        @Override
        @Deprecated
        public Policy createPolicy() {
            return super.createPolicy();
        }
    }
    ,
    PLATFORM_NATIVE,
    WINDOWS,
    UNIX,
    MAC_CLASSIC,
    PRESERVE;

    private static final Policy WINDOWS_POLICY;
    private static final Policy UNIX_POLICY;
    private static final Policy MAC_CLASSIC_POLICY;
    private static final Policy PRESERVE_POLICY;
    private static final String _platformNative;
    private static final Policy _platformNativePolicy;
    private static final boolean nativeIsWin;

    public Policy createPolicy(File projectDir, Supplier<Iterable<File>> toFormat) {
        String gitAttributesMethod;
        Objects.requireNonNull(projectDir, "projectDir");
        Objects.requireNonNull(toFormat, "toFormat");
        if (this == GIT_ATTRIBUTES) {
            gitAttributesMethod = "create";
        } else if (this == GIT_ATTRIBUTES_FAST_ALLSAME) {
            gitAttributesMethod = "createFastAllSame";
        } else {
            return this.createPolicy();
        }
        try {
            Class<?> clazz = Class.forName("com.diffplug.spotless.extra.GitAttributesLineEndings");
            Method method = clazz.getMethod(gitAttributesMethod, File.class, Supplier.class);
            return ThrowingEx.get(() -> (Policy)method.invoke(null, projectDir, toFormat));
        }
        catch (ClassNotFoundException | NoSuchMethodException | SecurityException e) {
            throw new IllegalStateException("LineEnding.GIT_ATTRIBUTES requires the spotless-lib-extra library, but it is not on the classpath", e);
        }
    }

    public Policy createPolicy() {
        switch (this.ordinal()) {
            case 2: {
                return _platformNativePolicy;
            }
            case 3: {
                return WINDOWS_POLICY;
            }
            case 4: {
                return UNIX_POLICY;
            }
            case 5: {
                return MAC_CLASSIC_POLICY;
            }
            case 6: {
                return PRESERVE_POLICY;
            }
        }
        throw new UnsupportedOperationException(String.valueOf((Object)this) + " is a path-specific line ending.");
    }

    @Deprecated
    public static boolean nativeIsWin() {
        return nativeIsWin;
    }

    public String str() {
        switch (this.ordinal()) {
            case 2: {
                return _platformNative;
            }
            case 3: {
                return "\r\n";
            }
            case 4: {
                return "\n";
            }
            case 5: {
                return "\r";
            }
        }
        throw new UnsupportedOperationException(String.valueOf((Object)this) + " is a path-specific line ending.");
    }

    public static String toUnix(String input) {
        int lastCarriageReturn = input.lastIndexOf(13);
        if (lastCarriageReturn == -1) {
            return input;
        }
        if (input.lastIndexOf("\r\n") == -1) {
            return input.replace('\r', '\n');
        }
        return input.replace("\r", "");
    }

    static {
        WINDOWS_POLICY = new ConstantLineEndingPolicy(WINDOWS.str());
        UNIX_POLICY = new ConstantLineEndingPolicy(UNIX.str());
        MAC_CLASSIC_POLICY = new ConstantLineEndingPolicy(MAC_CLASSIC.str());
        PRESERVE_POLICY = new PreserveLineEndingPolicy();
        _platformNative = System.getProperty("line.separator");
        _platformNativePolicy = new ConstantLineEndingPolicy(_platformNative);
        nativeIsWin = _platformNative.equals(WINDOWS.str());
    }

    public static interface Policy
    extends Serializable,
    NoLambda {
        public String getEndingFor(File var1);

        default public boolean isUnix(File file) {
            Objects.requireNonNull(file);
            String ending = this.getEndingFor(file);
            return ending.equals(UNIX.str());
        }
    }

    static class ConstantLineEndingPolicy
    extends NoLambda.EqualityBasedOnSerialization
    implements Policy {
        private static final long serialVersionUID = 1L;
        final String lineEnding;

        ConstantLineEndingPolicy(String lineEnding) {
            this.lineEnding = lineEnding;
        }

        @Override
        public String getEndingFor(File file) {
            return this.lineEnding;
        }
    }

    static class PreserveLineEndingPolicy
    extends NoLambda.EqualityBasedOnSerialization
    implements Policy {
        private static final long serialVersionUID = 2L;

        PreserveLineEndingPolicy() {
        }

        @Override
        public String getEndingFor(File file) {
            String string;
            FileReader reader = new FileReader(file, StandardCharsets.US_ASCII);
            try {
                string = PreserveLineEndingPolicy.getEndingFor(reader);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ((Reader)reader).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("Could not determine line ending of file: " + String.valueOf(file), e);
                }
            }
            ((Reader)reader).close();
            return string;
        }

        static String getEndingFor(Reader reader) throws IOException {
            int readResult;
            int previousCharacter = 0;
            char currentCharacter = '\u0000';
            while ((readResult = reader.read()) != -1) {
                currentCharacter = (char)readResult;
                if (currentCharacter == '\n') {
                    if (previousCharacter == 13) {
                        return WINDOWS.str();
                    }
                    return UNIX.str();
                }
                if (previousCharacter == 13) {
                    return MAC_CLASSIC.str();
                }
                previousCharacter = currentCharacter;
            }
            if (previousCharacter == 13) {
                return MAC_CLASSIC.str();
            }
            return UNIX.str();
        }
    }
}

