/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.glue.diktat.compat;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.ToIntFunction;

public interface DiktatReporting {
    public static <T> void reportIfRequired(List<T> errors, ToIntFunction<T> lineGetter, Function<T, String> codeGetter, Function<T, String> detailGetter) {
        if (!errors.isEmpty()) {
            ArrayList<Lint> lints = new ArrayList<Lint>();
            for (T er : errors) {
                lints.add(new Lint(lineGetter.applyAsInt(er), codeGetter.apply(er), detailGetter.apply(er)));
            }
            throw new LintException(lints);
        }
    }

    public static class Lint
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public final int line;
        public final String ruleId;
        public final String detail;

        Lint(int line, String ruleId, String detail) {
            this.line = line;
            this.ruleId = ruleId;
            this.detail = detail;
        }
    }

    public static class LintException
    extends RuntimeException {
        public final List<Lint> lints;

        LintException(List<Lint> lints) {
            this.lints = lints;
        }
    }
}

