/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.glue.diktat.compat;

import java.util.List;
import java.util.function.Function;
import java.util.function.ToIntFunction;

interface DiktatReporting {
    public static <T> void reportIfRequired(List<T> errors, ToIntFunction<T> lineGetter, ToIntFunction<T> columnGetter, Function<T, String> detailGetter) {
        if (!errors.isEmpty()) {
            StringBuilder error = new StringBuilder();
            error.append("There are ").append(errors.size()).append(" unfixed errors:");
            for (T er : errors) {
                error.append(System.lineSeparator()).append("Error on line: ").append(lineGetter.applyAsInt(er)).append(", column: ").append(columnGetter.applyAsInt(er)).append(" cannot be fixed automatically").append(System.lineSeparator()).append(detailGetter.apply(er));
            }
            throw new AssertionError(error);
        }
    }
}

