/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.glue.ktlint;

import com.diffplug.spotless.FileSignature;
import com.diffplug.spotless.FormatterFunc;
import com.diffplug.spotless.glue.ktlint.compat.KtLintCompat0Dot48Dot0Adapter;
import com.diffplug.spotless.glue.ktlint.compat.KtLintCompat0Dot49Dot0Adapter;
import com.diffplug.spotless.glue.ktlint.compat.KtLintCompat0Dot50Dot0Adapter;
import com.diffplug.spotless.glue.ktlint.compat.KtLintCompat1Dot0Dot0Adapter;
import com.diffplug.spotless.glue.ktlint.compat.KtLintCompatAdapter;
import java.io.File;
import java.nio.file.Path;
import java.util.Map;

public class KtlintFormatterFunc
implements FormatterFunc.NeedsFile {
    private final KtLintCompatAdapter adapter;
    private final FileSignature editorConfigPath;
    private final Map<String, Object> editorConfigOverrideMap;

    public KtlintFormatterFunc(String version, FileSignature editorConfigPath, Map<String, Object> editorConfigOverrideMap) {
        String[] versions = version.split("\\.");
        int majorVersion = Integer.parseInt(versions[0]);
        int minorVersion = Integer.parseInt(versions[1]);
        if (majorVersion == 1) {
            this.adapter = new KtLintCompat1Dot0Dot0Adapter();
        } else if (minorVersion >= 50) {
            this.adapter = new KtLintCompat0Dot50Dot0Adapter();
        } else if (minorVersion == 49) {
            this.adapter = new KtLintCompat0Dot49Dot0Adapter();
        } else if (minorVersion == 48) {
            this.adapter = new KtLintCompat0Dot48Dot0Adapter();
        } else {
            throw new IllegalStateException("Ktlint versions < 0.48.0 not supported!");
        }
        this.editorConfigPath = editorConfigPath;
        this.editorConfigOverrideMap = editorConfigOverrideMap;
    }

    @Override
    public String applyWithFile(String unix, File file) {
        Path absoluteEditorConfigPath = null;
        if (this.editorConfigPath != null) {
            absoluteEditorConfigPath = this.editorConfigPath.getOnlyFile().toPath();
        }
        return this.adapter.format(file.toPath(), absoluteEditorConfigPath, this.editorConfigOverrideMap);
    }
}

