/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.glue.ktlint.compat;

import com.diffplug.spotless.glue.ktlint.compat.KtLintCompatAdapter;
import com.diffplug.spotless.glue.ktlint.compat.KtLintCompatReporting;
import com.pinterest.ktlint.rule.engine.api.Code;
import com.pinterest.ktlint.rule.engine.api.EditorConfigDefaults;
import com.pinterest.ktlint.rule.engine.api.EditorConfigOverride;
import com.pinterest.ktlint.rule.engine.api.KtLintRuleEngine;
import com.pinterest.ktlint.rule.engine.api.LintError;
import com.pinterest.ktlint.rule.engine.core.api.Rule;
import com.pinterest.ktlint.rule.engine.core.api.RuleProvider;
import com.pinterest.ktlint.rule.engine.core.api.editorconfig.CodeStyleEditorConfigPropertyKt;
import com.pinterest.ktlint.rule.engine.core.api.editorconfig.EditorConfigProperty;
import com.pinterest.ktlint.rule.engine.core.api.editorconfig.EndOfLinePropertyKt;
import com.pinterest.ktlint.rule.engine.core.api.editorconfig.IndentSizeEditorConfigPropertyKt;
import com.pinterest.ktlint.rule.engine.core.api.editorconfig.IndentStyleEditorConfigPropertyKt;
import com.pinterest.ktlint.rule.engine.core.api.editorconfig.InsertFinalNewLineEditorConfigPropertyKt;
import com.pinterest.ktlint.rule.engine.core.api.editorconfig.MaxLineLengthEditorConfigPropertyKt;
import com.pinterest.ktlint.rule.engine.core.api.editorconfig.RuleExecution;
import com.pinterest.ktlint.rule.engine.core.api.editorconfig.RuleExecutionEditorConfigPropertyKt;
import com.pinterest.ktlint.ruleset.standard.StandardRuleSetProvider;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KtLintCompat0Dot49Dot0Adapter
implements KtLintCompatAdapter {
    private static final Logger logger = LoggerFactory.getLogger(KtLintCompat0Dot49Dot0Adapter.class);
    private static final List<EditorConfigProperty<?>> DEFAULT_EDITOR_CONFIG_PROPERTIES;
    private static final Method RULEID_METHOD;
    private static final Method CREATE_RULESET_EXECUTION_METHOD;
    private static final Method CREATE_RULE_EXECUTION_METHOD;

    private static String getRuleId(LintError lint) {
        try {
            return (String)RULEID_METHOD.invoke((Object)lint, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private static EditorConfigProperty<?> createRuleSetExecution(String id, RuleExecution execution) {
        try {
            return (EditorConfigProperty)CREATE_RULESET_EXECUTION_METHOD.invoke(null, id, execution);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private static EditorConfigProperty<?> createRuleExecution(String id, RuleExecution execution) {
        try {
            return (EditorConfigProperty)CREATE_RULE_EXECUTION_METHOD.invoke(null, id, execution);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String format(String text, Path path, boolean isScript, boolean useExperimental, Path editorConfigPath, Map<String, String> userData, Map<String, Object> editorConfigOverrideMap) {
        String experimentalRulesPropertyName;
        Object experimentalOverride;
        FormatterCallback formatterCallback = new FormatterCallback();
        LinkedHashSet allRuleProviders = new LinkedHashSet(new StandardRuleSetProvider().getRuleProviders());
        if (useExperimental && (experimentalOverride = editorConfigOverrideMap.get(experimentalRulesPropertyName = RuleExecutionEditorConfigPropertyKt.getEXPERIMENTAL_RULES_EXECUTION_PROPERTY().getName())) != null) {
            logger.warn("`useExperimental` parameter is `true` and `ktlint_experimental` property is set, `useExperimental` will take priority!");
            editorConfigOverrideMap.put(experimentalRulesPropertyName, "enabled");
        }
        EditorConfigOverride editorConfigOverride = editorConfigOverrideMap.isEmpty() ? EditorConfigOverride.Companion.getEMPTY_EDITOR_CONFIG_OVERRIDE() : KtLintCompat0Dot49Dot0Adapter.createEditorConfigOverride(allRuleProviders.stream().map(RuleProvider::createNewRuleInstance).collect(Collectors.toList()), editorConfigOverrideMap);
        EditorConfigDefaults editorConfig = editorConfigPath == null || !Files.exists(editorConfigPath, new LinkOption[0]) ? EditorConfigDefaults.Companion.getEMPTY_EDITOR_CONFIG_DEFAULTS() : EditorConfigDefaults.Companion.load(editorConfigPath);
        return new KtLintRuleEngine(allRuleProviders, editorConfig, editorConfigOverride, false, path.getFileSystem()).format(Code.Companion.fromPath(path), (Function2)formatterCallback);
    }

    private static EditorConfigOverride createEditorConfigOverride(List<Rule> rules, Map<String, Object> editorConfigOverrideMap) {
        Stream ruleProperties = rules.stream().flatMap(rule -> rule.getUsesEditorConfigProperties().stream());
        Map<String, EditorConfigProperty> supportedProperties = Stream.concat(ruleProperties, DEFAULT_EDITOR_CONFIG_PROPERTIES.stream()).distinct().collect(Collectors.toMap(EditorConfigProperty::getName, property -> property));
        Pair[] properties = (Pair[])editorConfigOverrideMap.entrySet().stream().map(entry -> {
            EditorConfigProperty<?> property = (EditorConfigProperty<?>)supportedProperties.get(entry.getKey());
            if (property != null) {
                return new Pair((Object)property, entry.getValue());
            }
            if (((String)entry.getKey()).startsWith("ktlint_")) {
                String[] parts = ((String)entry.getKey()).substring(7).split("_", 2);
                if (parts.length == 1) {
                    String qualifiedRuleId = parts[0] + ":";
                    property = KtLintCompat0Dot49Dot0Adapter.createRuleSetExecution(qualifiedRuleId, RuleExecution.disabled);
                } else {
                    String qualifiedRuleId = parts[0] + ":" + parts[1];
                    property = KtLintCompat0Dot49Dot0Adapter.createRuleExecution(qualifiedRuleId, RuleExecution.disabled);
                }
                return new Pair(property, entry.getValue());
            }
            return null;
        }).filter(Objects::nonNull).toArray(Pair[]::new);
        return EditorConfigOverride.Companion.from(properties);
    }

    static {
        ArrayList<EditorConfigProperty> list = new ArrayList<EditorConfigProperty>();
        list.add(CodeStyleEditorConfigPropertyKt.getCODE_STYLE_PROPERTY());
        list.add(EndOfLinePropertyKt.getEND_OF_LINE_PROPERTY());
        list.add(IndentSizeEditorConfigPropertyKt.getINDENT_SIZE_PROPERTY());
        list.add(IndentStyleEditorConfigPropertyKt.getINDENT_STYLE_PROPERTY());
        list.add(InsertFinalNewLineEditorConfigPropertyKt.getINSERT_FINAL_NEWLINE_PROPERTY());
        list.add(MaxLineLengthEditorConfigPropertyKt.getMAX_LINE_LENGTH_PROPERTY());
        list.add(RuleExecutionEditorConfigPropertyKt.getEXPERIMENTAL_RULES_EXECUTION_PROPERTY());
        DEFAULT_EDITOR_CONFIG_PROPERTIES = Collections.unmodifiableList(list);
        try {
            RULEID_METHOD = LintError.class.getMethod("getRuleId-6XN97os", new Class[0]);
            CREATE_RULESET_EXECUTION_METHOD = RuleExecutionEditorConfigPropertyKt.class.getMethod("createRuleSetExecutionEditorConfigProperty-fqiwTpU", String.class, RuleExecution.class);
            CREATE_RULE_EXECUTION_METHOD = RuleExecutionEditorConfigPropertyKt.class.getMethod("createRuleExecutionEditorConfigProperty-U7AdEiY", String.class, RuleExecution.class);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    static class FormatterCallback
    implements Function2<LintError, Boolean, Unit> {
        FormatterCallback() {
        }

        public Unit invoke(LintError lint, Boolean corrected) {
            if (!corrected.booleanValue()) {
                KtLintCompatReporting.report(lint.getLine(), lint.getCol(), KtLintCompat0Dot49Dot0Adapter.getRuleId(lint), lint.getDetail());
            }
            return Unit.INSTANCE;
        }
    }
}

