/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.npm;

import com.diffplug.spotless.ProcessRunner;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;

class NpmProcess {
    private final File workingDir;
    private final File npmExecutable;
    private final File nodeExecutable;
    private final ProcessRunner processRunner;

    NpmProcess(File workingDir, File npmExecutable, File nodeExecutable) {
        this.workingDir = workingDir;
        this.npmExecutable = npmExecutable;
        this.nodeExecutable = nodeExecutable;
        this.processRunner = ProcessRunner.usingRingBuffersOfCapacity(102400);
    }

    void install() {
        this.npmAwait("install", "--no-audit", "--no-package-lock", "--no-fund", "--prefer-offline");
    }

    ProcessRunner.LongRunningProcess start() {
        return this.npm("start", "--scripts-prepend-node-path=true");
    }

    private void npmAwait(String ... args) {
        try (ProcessRunner.LongRunningProcess npmProcess = this.npm(args);){
            if (npmProcess.waitFor() != 0) {
                throw new NpmProcessException("Running npm command '" + this.commandLine(args) + "' failed with exit code: " + npmProcess.exitValue() + "\n\n" + npmProcess.result());
            }
        }
        catch (InterruptedException e) {
            throw new NpmProcessException("Running npm command '" + this.commandLine(args) + "' was interrupted.", e);
        }
        catch (ExecutionException e) {
            throw new NpmProcessException("Running npm command '" + this.commandLine(args) + "' failed.", e);
        }
    }

    private ProcessRunner.LongRunningProcess npm(String ... args) {
        List<String> processCommand = this.processCommand(args);
        try {
            return this.processRunner.start(this.workingDir, this.environmentVariables(), null, true, processCommand);
        }
        catch (IOException e) {
            throw new NpmProcessException("Failed to launch npm command '" + this.commandLine(args) + "'.", e);
        }
    }

    private List<String> processCommand(String ... args) {
        ArrayList<String> command = new ArrayList<String>(args.length + 1);
        command.add(this.npmExecutable.getAbsolutePath());
        command.addAll(Arrays.asList(args));
        return command;
    }

    private Map<String, String> environmentVariables() {
        HashMap<String, String> environmentVariables = new HashMap<String, String>();
        environmentVariables.put("PATH", this.nodeExecutable.getParentFile().getAbsolutePath() + File.pathSeparator + System.getenv("PATH"));
        return environmentVariables;
    }

    private String commandLine(String ... args) {
        return "npm " + Arrays.stream(args).collect(Collectors.joining(" "));
    }

    static class NpmProcessException
    extends RuntimeException {
        private static final long serialVersionUID = 6424331316676759525L;

        public NpmProcessException(String message) {
            super(message);
        }

        public NpmProcessException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

