/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.yaml;

import com.diffplug.spotless.FormatterFunc;
import com.diffplug.spotless.FormatterStep;
import com.diffplug.spotless.JarState;
import com.diffplug.spotless.Provisioner;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class YamlJacksonStep {
    static final String MAVEN_COORDINATE = "com.fasterxml.jackson.dataformat:jackson-dataformat-yaml:";
    static final String DEFAULT_VERSION = "2.14.1";

    private YamlJacksonStep() {
    }

    public static String defaultVersion() {
        return DEFAULT_VERSION;
    }

    public static FormatterStep create(List<String> enabledFeatures, List<String> disabledFeatures, String jacksonVersion, Provisioner provisioner) {
        Objects.requireNonNull(provisioner, "provisioner cannot be null");
        return FormatterStep.createLazy("yaml", () -> new State(enabledFeatures, disabledFeatures, jacksonVersion, provisioner), State::toFormatter);
    }

    public static FormatterStep create(Provisioner provisioner) {
        return YamlJacksonStep.create(Arrays.asList("INDENT_OUTPUT"), Arrays.asList(new String[0]), YamlJacksonStep.defaultVersion(), provisioner);
    }

    private static final class State
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final List<String> enabledFeatures;
        private final List<String> disabledFeatures;
        private final JarState jarState;

        private State(List<String> enabledFeatures, List<String> disabledFeatures, String jacksonVersion, Provisioner provisioner) throws IOException {
            this.enabledFeatures = enabledFeatures;
            this.disabledFeatures = disabledFeatures;
            this.jarState = JarState.from(YamlJacksonStep.MAVEN_COORDINATE + jacksonVersion, provisioner);
        }

        FormatterFunc toFormatter() throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
            Class<?> formatterFunc = this.jarState.getClassLoader().loadClass("com.diffplug.spotless.glue.yaml.YamlJacksonFormatterFunc");
            Constructor<?> constructor = formatterFunc.getConstructor(List.class, List.class);
            return (FormatterFunc)constructor.newInstance(this.enabledFeatures, this.disabledFeatures);
        }
    }
}

