/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.npm;

import com.diffplug.spotless.FormatterFunc;
import com.diffplug.spotless.FormatterStep;
import com.diffplug.spotless.Provisioner;
import com.diffplug.spotless.ThrowingEx;
import com.diffplug.spotless.npm.BaseNpmRestService;
import com.diffplug.spotless.npm.EslintConfig;
import com.diffplug.spotless.npm.EslintRestService;
import com.diffplug.spotless.npm.EslintTypescriptConfig;
import com.diffplug.spotless.npm.FormattedPrinter;
import com.diffplug.spotless.npm.NpmConfig;
import com.diffplug.spotless.npm.NpmFormatterStepStateBase;
import com.diffplug.spotless.npm.NpmPathResolver;
import com.diffplug.spotless.npm.NpmResourceHelper;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EslintFormatterStep {
    private static final Logger logger = LoggerFactory.getLogger(EslintFormatterStep.class);
    public static final String NAME = "eslint-format";
    public static final String DEFAULT_ESLINT_VERSION = "^8.31.0";

    public static Map<String, String> defaultDevDependenciesForTypescript() {
        return EslintFormatterStep.defaultDevDependenciesTypescriptWithEslint(DEFAULT_ESLINT_VERSION);
    }

    public static Map<String, String> defaultDevDependenciesTypescriptWithEslint(String eslintVersion) {
        LinkedHashMap<String, String> dependencies = new LinkedHashMap<String, String>();
        dependencies.put("@typescript-eslint/eslint-plugin", "^5.47.0");
        dependencies.put("@typescript-eslint/parser", "^5.47.0");
        dependencies.put("typescript", "^4.9.4");
        dependencies.put("eslint", Objects.requireNonNull(eslintVersion));
        return dependencies;
    }

    public static Map<String, String> defaultDevDependencies() {
        return EslintFormatterStep.defaultDevDependenciesWithEslint(DEFAULT_ESLINT_VERSION);
    }

    public static Map<String, String> defaultDevDependenciesWithEslint(String version) {
        return Collections.singletonMap("eslint", version);
    }

    public static FormatterStep create(Map<String, String> devDependencies, Provisioner provisioner, File projectDir, File buildDir, NpmPathResolver npmPathResolver, EslintConfig eslintConfig) {
        Objects.requireNonNull(devDependencies);
        Objects.requireNonNull(provisioner);
        Objects.requireNonNull(projectDir);
        Objects.requireNonNull(buildDir);
        return FormatterStep.createLazy(NAME, () -> new State(NAME, devDependencies, projectDir, buildDir, npmPathResolver, eslintConfig), State::createFormatterFunc);
    }

    private static class EslintFilePathPassingFormatterFunc
    implements FormatterFunc.NeedsFile {
        private final File projectDir;
        private final File nodeModulesDir;
        private final EslintConfig eslintConfig;
        private final EslintRestService restService;

        public EslintFilePathPassingFormatterFunc(File projectDir, File nodeModulesDir, EslintConfig eslintConfig, EslintRestService restService) {
            this.projectDir = Objects.requireNonNull(projectDir);
            this.nodeModulesDir = Objects.requireNonNull(nodeModulesDir);
            this.eslintConfig = Objects.requireNonNull(eslintConfig);
            this.restService = Objects.requireNonNull(restService);
        }

        @Override
        public String applyWithFile(String unix, File file) throws Exception {
            FormattedPrinter.SYSOUT.print("formatting String '" + unix.substring(0, Math.min(50, unix.length())) + "[...]' in file '" + file + "'", new Object[0]);
            HashMap<EslintRestService.FormatOption, Object> eslintCallOptions = new HashMap<EslintRestService.FormatOption, Object>();
            this.setConfigToCallOptions(eslintCallOptions);
            this.setFilePathToCallOptions(eslintCallOptions, file);
            return this.restService.format(unix, eslintCallOptions);
        }

        private void setFilePathToCallOptions(Map<EslintRestService.FormatOption, Object> eslintCallOptions, File fileToBeFormatted) {
            eslintCallOptions.put(EslintRestService.FormatOption.FILE_PATH, fileToBeFormatted.getAbsolutePath());
        }

        private void setConfigToCallOptions(Map<EslintRestService.FormatOption, Object> eslintCallOptions) {
            if (this.eslintConfig.getEslintConfigPath() != null) {
                eslintCallOptions.put(EslintRestService.FormatOption.ESLINT_OVERRIDE_CONFIG_FILE, this.eslintConfig.getEslintConfigPath().getAbsolutePath());
            }
            if (this.eslintConfig.getEslintConfigJs() != null) {
                eslintCallOptions.put(EslintRestService.FormatOption.ESLINT_OVERRIDE_CONFIG, this.eslintConfig.getEslintConfigJs());
            }
            if (this.eslintConfig instanceof EslintTypescriptConfig) {
                File tsConfigFilePath = ((EslintTypescriptConfig)this.eslintConfig).getTypescriptConfigPath();
                File tsConfigRootDir = tsConfigFilePath != null ? tsConfigFilePath.getParentFile() : this.projectDir;
                eslintCallOptions.put(EslintRestService.FormatOption.TS_CONFIG_ROOT_DIR, this.nodeModulesDir.getAbsoluteFile().toPath().relativize(tsConfigRootDir.getAbsoluteFile().toPath()).toString());
            }
        }
    }

    private static class State
    extends NpmFormatterStepStateBase
    implements Serializable {
        private static final long serialVersionUID = -539537027004745812L;
        private final EslintConfig eslintConfig;

        State(String stepName, Map<String, String> devDependencies, File projectDir, File buildDir, NpmPathResolver npmPathResolver, EslintConfig eslintConfig) throws IOException {
            super(stepName, new NpmConfig(State.replaceDevDependencies(NpmResourceHelper.readUtf8StringFromClasspath(EslintFormatterStep.class, "/com/diffplug/spotless/npm/eslint-package.json"), new TreeMap<String, String>(devDependencies)), "eslint", NpmResourceHelper.readUtf8StringFromClasspath(EslintFormatterStep.class, "/com/diffplug/spotless/npm/common-serve.js", "/com/diffplug/spotless/npm/eslint-serve.js"), npmPathResolver.resolveNpmrcContent()), projectDir, buildDir, npmPathResolver.resolveNpmExecutable());
            this.eslintConfig = this.localCopyFiles(Objects.requireNonNull(eslintConfig));
        }

        private EslintConfig localCopyFiles(EslintConfig orig) {
            if (orig.getEslintConfigPath() == null) {
                return orig.verify();
            }
            FormattedPrinter.SYSOUT.print("Copying config file <%s> to <%s> and using the copy", orig.getEslintConfigPath(), this.nodeModulesDir);
            File configFileCopy = NpmResourceHelper.copyFileToDir(orig.getEslintConfigPath(), this.nodeModulesDir);
            return orig.withEslintConfigPath(configFileCopy).verify();
        }

        @Override
        @Nonnull
        public FormatterFunc createFormatterFunc() {
            try {
                FormattedPrinter.SYSOUT.print("creating formatter function (starting server)", new Object[0]);
                NpmFormatterStepStateBase.ServerProcessInfo eslintRestServer = this.npmRunServer();
                EslintRestService restService = new EslintRestService(eslintRestServer.getBaseUrl());
                return FormatterFunc.Closeable.ofDangerous(() -> this.endServer(restService, eslintRestServer), new EslintFilePathPassingFormatterFunc(this.projectDir, this.nodeModulesDir, this.eslintConfig, restService));
            }
            catch (IOException e) {
                throw ThrowingEx.asRuntime(e);
            }
        }

        private void endServer(BaseNpmRestService restService, NpmFormatterStepStateBase.ServerProcessInfo restServer) throws Exception {
            FormattedPrinter.SYSOUT.print("Closing formatting function (ending server).", new Object[0]);
            try {
                restService.shutdown();
            }
            catch (Throwable t) {
                logger.info("Failed to request shutdown of rest service via api. Trying via process.", t);
            }
            restServer.close();
        }
    }
}

