/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.npm;

import com.diffplug.spotless.npm.NpmExecutableResolver;
import com.diffplug.spotless.npm.NpmResourceHelper;
import com.diffplug.spotless.npm.NpmrcResolver;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

public class NpmPathResolver {
    private final File explicitNpmExecutable;
    private final File explicitNpmrcFile;
    private final List<File> additionalNpmrcLocations;

    public NpmPathResolver(File explicitNpmExecutable, File explicitNpmrcFile, File ... additionalNpmrcLocations) {
        this.explicitNpmExecutable = explicitNpmExecutable;
        this.explicitNpmrcFile = explicitNpmrcFile;
        this.additionalNpmrcLocations = Arrays.asList(additionalNpmrcLocations);
    }

    public File resolveNpmExecutable() {
        return Optional.ofNullable(this.explicitNpmExecutable).orElseGet(() -> NpmExecutableResolver.tryFind().orElseThrow(() -> new IllegalStateException("Can't automatically determine npm executable and none was specifically supplied!\n\n" + NpmExecutableResolver.explainMessage())));
    }

    public String resolveNpmrcContent() {
        File npmrcFile = Optional.ofNullable(this.explicitNpmrcFile).orElseGet(() -> new NpmrcResolver(this.additionalNpmrcLocations).tryFind().orElse(null));
        if (npmrcFile != null) {
            return NpmResourceHelper.readUtf8StringFromFile(npmrcFile);
        }
        return null;
    }
}

