/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless;

import com.diffplug.spotless.FileSignature;
import com.diffplug.spotless.ThrowingEx;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.BiConsumer;

public class ProcessRunner
implements AutoCloseable {
    private final ExecutorService threadStdOut = Executors.newSingleThreadExecutor();
    private final ExecutorService threadStdErr = Executors.newSingleThreadExecutor();
    private final ByteArrayOutputStream bufStdOut = new ByteArrayOutputStream();
    private final ByteArrayOutputStream bufStdErr = new ByteArrayOutputStream();

    public Result shell(String cmd) throws IOException, InterruptedException {
        return this.shellWinUnix(cmd, cmd);
    }

    public Result shellWinUnix(String cmdWin, String cmdUnix) throws IOException, InterruptedException {
        List<String> args = FileSignature.machineIsWin() ? Arrays.asList("cmd", "/c", cmdWin) : Arrays.asList("sh", "-c", cmdUnix);
        return this.exec(args);
    }

    public Result exec(String ... args) throws IOException, InterruptedException {
        return this.exec(Arrays.asList(args));
    }

    public Result exec(byte[] stdin, String ... args) throws IOException, InterruptedException {
        return this.exec(stdin, Arrays.asList(args));
    }

    public Result exec(List<String> args) throws IOException, InterruptedException {
        return this.exec(new byte[0], args);
    }

    public Result exec(byte[] stdin, List<String> args) throws IOException, InterruptedException {
        ProcessBuilder builder = new ProcessBuilder(args);
        Process process = builder.start();
        Future<byte[]> outputFut = this.threadStdOut.submit(() -> ProcessRunner.drainToBytes(process.getInputStream(), this.bufStdOut));
        Future<byte[]> errorFut = this.threadStdErr.submit(() -> ProcessRunner.drainToBytes(process.getErrorStream(), this.bufStdErr));
        process.getOutputStream().write(stdin);
        process.getOutputStream().close();
        int exitCode = process.waitFor();
        try {
            return new Result(args, exitCode, outputFut.get(), errorFut.get());
        }
        catch (ExecutionException e) {
            throw ThrowingEx.asRuntime(e);
        }
    }

    private static void drain(InputStream input, OutputStream output) throws IOException {
        int numRead;
        byte[] buf = new byte[1024];
        while ((numRead = input.read(buf)) != -1) {
            output.write(buf, 0, numRead);
        }
    }

    private static byte[] drainToBytes(InputStream input, ByteArrayOutputStream buffer) throws IOException {
        buffer.reset();
        ProcessRunner.drain(input, buffer);
        return buffer.toByteArray();
    }

    @Override
    public void close() {
        this.threadStdOut.shutdown();
        this.threadStdErr.shutdown();
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP", "EI_EXPOSE_REP2"})
    public static class Result {
        private final List<String> args;
        private final int exitCode;
        private final byte[] stdOut;
        private final byte[] stdErr;

        public Result(List<String> args, int exitCode, byte[] stdOut, byte[] stdErr) {
            this.args = args;
            this.exitCode = exitCode;
            this.stdOut = stdOut;
            this.stdErr = stdErr;
        }

        public List<String> args() {
            return this.args;
        }

        public int exitCode() {
            return this.exitCode;
        }

        public byte[] stdOut() {
            return this.stdOut;
        }

        public byte[] stdErr() {
            return this.stdErr;
        }

        public boolean exitNotZero() {
            return this.exitCode != 0;
        }

        public String assertExitZero(Charset charset) {
            if (this.exitCode == 0) {
                return new String(this.stdOut, charset);
            }
            throw new RuntimeException(this.toString());
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("> arguments: " + this.args + "\n");
            builder.append("> exit code: " + this.exitCode + "\n");
            BiConsumer<String, byte[]> perStream = (name, content) -> {
                String string = new String((byte[])content, Charset.defaultCharset()).trim();
                if (string.isEmpty()) {
                    builder.append("> " + name + ": (empty)\n");
                } else {
                    String[] lines = string.replace("\r", "").split("\n");
                    if (lines.length == 1) {
                        builder.append("> " + name + ": " + lines[0] + "\n");
                    } else {
                        builder.append("> " + name + ": (below)\n");
                        for (String line : lines) {
                            builder.append("> ");
                            builder.append(line);
                            builder.append('\n');
                        }
                    }
                }
            };
            perStream.accept("   stdout", this.stdOut);
            perStream.accept("   stderr", this.stdErr);
            return builder.toString();
        }
    }
}

