/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.java;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

final class ImportSorterImpl {
    private final List<String> template = new ArrayList<String>();
    private final Map<String, List<String>> matchingImports = new HashMap<String, List<String>>();
    private final List<String> notMatching = new ArrayList<String>();
    private final Set<String> allImportOrderItems = new HashSet<String>();
    private final Comparator<String> ordering;

    static List<String> sort(List<String> imports, List<String> importsOrder, boolean wildcardsLast, String lineFormat) {
        ImportSorterImpl importsSorter = new ImportSorterImpl(importsOrder, wildcardsLast);
        return importsSorter.sort(imports, lineFormat);
    }

    private List<String> sort(List<String> imports, String lineFormat) {
        this.filterMatchingImports(imports);
        this.mergeNotMatchingItems(false);
        this.mergeNotMatchingItems(true);
        this.mergeMatchingItems();
        return this.getResult(lineFormat);
    }

    private ImportSorterImpl(List<String> importOrder, boolean wildcardsLast) {
        ArrayList<String> importOrderCopy = new ArrayList<String>(importOrder);
        ImportSorterImpl.normalizeStaticOrderItems(importOrderCopy);
        ImportSorterImpl.putStaticItemIfNotExists(importOrderCopy);
        this.template.addAll(importOrderCopy);
        this.ordering = new OrderingComparator(wildcardsLast);
        this.allImportOrderItems.addAll(importOrderCopy);
    }

    private static void putStaticItemIfNotExists(List<String> allImportOrderItems) {
        boolean contains = false;
        int indexOfFirstStatic = 0;
        for (int i = 0; i < allImportOrderItems.size(); ++i) {
            String allImportOrderItem = allImportOrderItems.get(i);
            if (allImportOrderItem.equals("static ")) {
                contains = true;
            }
            if (!allImportOrderItem.startsWith("static ")) continue;
            indexOfFirstStatic = i;
        }
        if (!contains) {
            allImportOrderItems.add(indexOfFirstStatic, "static ");
        }
    }

    private static void normalizeStaticOrderItems(List<String> allImportOrderItems) {
        for (int i = 0; i < allImportOrderItems.size(); ++i) {
            String s = allImportOrderItems.get(i);
            if (!s.startsWith("\\#")) continue;
            allImportOrderItems.set(i, s.replace("\\#", "static "));
        }
    }

    private void filterMatchingImports(List<String> imports) {
        for (String anImport : imports) {
            String orderItem = this.getBestMatchingImportOrderItem(anImport);
            if (orderItem != null) {
                if (!this.matchingImports.containsKey(orderItem)) {
                    this.matchingImports.put(orderItem, new ArrayList());
                }
                this.matchingImports.get(orderItem).add(anImport);
                continue;
            }
            this.notMatching.add(anImport);
        }
        this.notMatching.addAll(this.allImportOrderItems);
    }

    @Nullable
    private String getBestMatchingImportOrderItem(String anImport) {
        String matchingImport = null;
        for (String orderItem : this.allImportOrderItems) {
            if (!anImport.startsWith(orderItem)) continue;
            if (matchingImport == null) {
                matchingImport = orderItem;
                continue;
            }
            matchingImport = ImportSorterImpl.betterMatching(matchingImport, orderItem, anImport);
        }
        return matchingImport;
    }

    private void mergeNotMatchingItems(boolean staticItems) {
        this.sort(this.notMatching);
        int firstIndexOfOrderItem = this.getFirstIndexOfOrderItem(this.notMatching, staticItems);
        int indexOfOrderItem = 0;
        for (String notMatchingItem : this.notMatching) {
            if (!ImportSorterImpl.matchesStatic(staticItems, notMatchingItem)) continue;
            boolean isOrderItem = this.isOrderItem(notMatchingItem, staticItems);
            if (isOrderItem) {
                indexOfOrderItem = this.template.indexOf(notMatchingItem);
                continue;
            }
            if (indexOfOrderItem == 0 && firstIndexOfOrderItem != 0) {
                this.template.add(firstIndexOfOrderItem, notMatchingItem);
                ++firstIndexOfOrderItem;
                continue;
            }
            if (firstIndexOfOrderItem == 0) {
                if (this.template.size() > 0 && this.template.get(this.template.size() - 1).startsWith("static")) {
                    this.template.add("\n");
                }
                this.template.add(notMatchingItem);
                continue;
            }
            this.template.add(indexOfOrderItem + 1, notMatchingItem);
            ++indexOfOrderItem;
        }
    }

    private boolean isOrderItem(String notMatchingItem, boolean staticItems) {
        boolean contains = this.allImportOrderItems.contains(notMatchingItem);
        return contains && ImportSorterImpl.matchesStatic(staticItems, notMatchingItem);
    }

    private int getFirstIndexOfOrderItem(List<String> notMatching, boolean staticItems) {
        int firstIndexOfOrderItem = 0;
        for (String notMatchingItem : notMatching) {
            boolean isOrderItem;
            if (!ImportSorterImpl.matchesStatic(staticItems, notMatchingItem) || !(isOrderItem = this.isOrderItem(notMatchingItem, staticItems))) continue;
            firstIndexOfOrderItem = this.template.indexOf(notMatchingItem);
            break;
        }
        return firstIndexOfOrderItem;
    }

    private static boolean matchesStatic(boolean staticItems, String notMatchingItem) {
        boolean isStatic = notMatchingItem.startsWith("static ");
        return isStatic && staticItems || !isStatic && !staticItems;
    }

    private void mergeMatchingItems() {
        for (int i = 0; i < this.template.size(); ++i) {
            String item = this.template.get(i);
            if (!this.allImportOrderItems.contains(item)) continue;
            List<String> strings = this.matchingImports.get(item);
            if (strings == null || strings.isEmpty()) {
                this.template.remove(i);
                --i;
                continue;
            }
            ArrayList<String> matchingItems = new ArrayList<String>(strings);
            this.sort(matchingItems);
            this.template.remove(i);
            if (i != 0 && !this.template.get(i - 1).equals("\n")) {
                this.template.add(i, "\n");
                ++i;
            }
            if (i + 1 < this.template.size() && !this.template.get(i + 1).equals("\n") && !this.template.get(i).equals("\n")) {
                this.template.add(i, "\n");
            }
            this.template.addAll(i, matchingItems);
            if (i == 0 || this.template.get(i - 1).equals("\n")) continue;
            this.template.add(i, "\n");
        }
        if (this.template.size() > 0 && this.template.get(this.template.size() - 1).equals("\n")) {
            this.template.remove(this.template.size() - 1);
        }
    }

    private void sort(List<String> items) {
        items.sort(this.ordering);
    }

    private List<String> getResult(String lineFormat) {
        ArrayList<String> strings = new ArrayList<String>();
        for (String s : this.template) {
            if (s.equals("\n")) {
                strings.add(s);
                continue;
            }
            strings.add(String.format(lineFormat, s) + "\n");
        }
        return strings;
    }

    @Nullable
    private static String betterMatching(String order1, String order2, String anImport) {
        if (order1.equals(order2)) {
            throw new IllegalArgumentException("orders are same");
        }
        for (int i = 0; i < anImport.length() - 1; ++i) {
            if (order1.length() - 1 == i && order2.length() - 1 != i) {
                return order2;
            }
            if (order2.length() - 1 == i && order1.length() - 1 != i) {
                return order1;
            }
            char orderChar1 = order1.length() != 0 ? (char)order1.charAt(i) : (char)' ';
            char orderChar2 = order2.length() != 0 ? (char)order2.charAt(i) : (char)' ';
            char importChar = anImport.charAt(i);
            if (importChar == orderChar1 && importChar != orderChar2) {
                return order1;
            }
            if (importChar == orderChar1 || importChar != orderChar2) continue;
            return order2;
        }
        return null;
    }

    private static class OrderingComparator
    implements Comparator<String>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final boolean wildcardsLast;

        private OrderingComparator(boolean wildcardsLast) {
            this.wildcardsLast = wildcardsLast;
        }

        @Override
        public int compare(String string1, String string2) {
            boolean string2IsWildcard;
            int string1WildcardIndex = string1.indexOf(42);
            int string2WildcardIndex = string2.indexOf(42);
            boolean string1IsWildcard = string1WildcardIndex >= 0;
            boolean bl = string2IsWildcard = string2WildcardIndex >= 0;
            if (string1IsWildcard == string2IsWildcard) {
                return string1.compareTo(string2);
            }
            int prefixLength = string1IsWildcard ? string1WildcardIndex : string2WildcardIndex;
            boolean samePrefix = string1.regionMatches(0, string2, 0, prefixLength);
            if (!samePrefix) {
                return string1.compareTo(string2);
            }
            return string1IsWildcard == this.wildcardsLast ? 1 : -1;
        }
    }
}

