/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.npm;

import com.diffplug.spotless.LineEnding;
import com.diffplug.spotless.npm.Reflective;
import com.diffplug.spotless.npm.ReflectiveObjectWrapper;
import com.diffplug.spotless.npm.V8ArrayWrapper;
import com.diffplug.spotless.npm.V8FunctionWrapper;
import com.diffplug.spotless.npm.V8ObjectWrapper;
import java.io.File;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;

class NodeJSWrapper
extends ReflectiveObjectWrapper {
    public static final String V8_RUNTIME_CLASS = "com.eclipsesource.v8.V8";
    public static final String V8_VALUE_CLASS = "com.eclipsesource.v8.V8Value";
    public static final String WRAPPED_CLASS = "com.eclipsesource.v8.NodeJS";
    private static final AtomicBoolean flagsSet = new AtomicBoolean(false);

    public NodeJSWrapper(ClassLoader classLoader) {
        super(Reflective.withClassLoader(classLoader), (Reflective reflective) -> {
            boolean firstRun = flagsSet.compareAndSet(false, true);
            if (firstRun && LineEnding.PLATFORM_NATIVE.str().equals("\r\n")) {
                reflective.invokeStaticMethod(V8_RUNTIME_CLASS, "setFlags", "-color=false");
            }
            return reflective.invokeStaticMethod(WRAPPED_CLASS, "createNodeJS", new Object[0]);
        });
    }

    public V8ObjectWrapper require(File npmModulePath) {
        Objects.requireNonNull(npmModulePath);
        Object v8Object = this.invoke("require", npmModulePath);
        return new V8ObjectWrapper(this.reflective(), v8Object);
    }

    public V8ObjectWrapper createNewObject() {
        Object v8Object = this.reflective().invokeConstructor("com.eclipsesource.v8.V8Object", this.nodeJsRuntime());
        V8ObjectWrapper objectWrapper = new V8ObjectWrapper(this.reflective(), v8Object);
        return objectWrapper;
    }

    public V8ObjectWrapper createNewObject(Map<String, Object> values) {
        Objects.requireNonNull(values);
        V8ObjectWrapper obj = this.createNewObject();
        values.forEach(obj::add);
        return obj;
    }

    public V8ArrayWrapper createNewArray(Object ... elements) {
        V8ArrayWrapper v8ArrayWrapper = this.createNewArray();
        for (Object element : elements) {
            v8ArrayWrapper.push(element);
        }
        return v8ArrayWrapper;
    }

    public V8ArrayWrapper createNewArray() {
        Object v8Array = this.reflective().invokeConstructor("com.eclipsesource.v8.V8Array", this.nodeJsRuntime());
        V8ArrayWrapper arrayWrapper = new V8ArrayWrapper(this.reflective(), v8Array);
        return arrayWrapper;
    }

    public V8FunctionWrapper createNewFunction(V8FunctionWrapper.WrappedJavaCallback callback) {
        Object v8Function = this.reflective().invokeConstructor("com.eclipsesource.v8.V8Function", this.reflective().typed(V8_RUNTIME_CLASS, this.nodeJsRuntime()), this.reflective().typed("com.eclipsesource.v8.JavaCallback", V8FunctionWrapper.proxiedCallback(callback, this.reflective())));
        V8FunctionWrapper functionWrapper = new V8FunctionWrapper(this.reflective(), v8Function);
        return functionWrapper;
    }

    public void handleMessage() {
        this.invoke("handleMessage", new Reflective.TypedValue[0]);
    }

    private Object nodeJsRuntime() {
        return this.invoke("getRuntime", new Reflective.TypedValue[0]);
    }

    public Object v8NullValue(Object value) {
        if (value == null) {
            return this.reflective().staticField(V8_VALUE_CLASS, "NULL");
        }
        return value;
    }

    public boolean isV8NullValue(Object v8Object) {
        return this.reflective().staticField(V8_VALUE_CLASS, "NULL") == v8Object;
    }
}

