/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.npm;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Objects;
import java.util.StringJoiner;

class Reflective {
    private final ClassLoader classLoader;

    private Reflective(ClassLoader classLoader) {
        this.classLoader = Objects.requireNonNull(classLoader);
    }

    static Reflective withClassLoader(ClassLoader classLoader) {
        return new Reflective(classLoader);
    }

    Class<?> clazz(String className) {
        try {
            return this.classLoader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new ReflectiveException(e);
        }
    }

    private Method staticMethod(String className, String methodName, Object ... parameters) {
        try {
            Class<?> clazz = this.clazz(className);
            return clazz.getDeclaredMethod(methodName, this.types(parameters));
        }
        catch (NoSuchMethodException e) {
            throw new ReflectiveException(e);
        }
    }

    Object invokeStaticMethod(String className, String methodName, Object ... parameters) {
        try {
            Method m = this.staticMethod(className, methodName, parameters);
            return m.invoke(m.getDeclaringClass(), parameters);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new ReflectiveException(e);
        }
    }

    private Class<?>[] types(TypedValue[] typedValues) {
        return (Class[])Arrays.stream(typedValues).map(TypedValue::getClazz).toArray(Class[]::new);
    }

    Class<?>[] types(Object[] arguments) {
        return (Class[])Arrays.stream(arguments).map(Object::getClass).toArray(Class[]::new);
    }

    Object invokeMethod(Object target, String methodName, Object ... parameters) {
        Method m = this.method(target, this.clazz(target), methodName, parameters);
        try {
            return m.invoke(target, parameters);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new ReflectiveException(e);
        }
    }

    Object invokeMethod(Object target, String methodName, TypedValue ... parameters) {
        Method m = this.method(target, this.clazz(target), methodName, parameters);
        try {
            return m.invoke(target, this.objects(parameters));
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new ReflectiveException(e);
        }
    }

    private Method method(Object target, Class<?> clazz, String methodName, Object[] parameters) {
        try {
            Method method = this.findMatchingMethod(clazz, methodName, parameters);
            return method;
        }
        catch (NoSuchMethodException e) {
            if (clazz.getSuperclass() != null) {
                return this.method(target, clazz.getSuperclass(), methodName, parameters);
            }
            throw new ReflectiveException("Could not find method " + methodName + " with parameters " + Arrays.toString(parameters) + " on object " + target, e);
        }
    }

    private Method method(Object target, Class<?> clazz, String methodName, TypedValue[] parameters) {
        try {
            Method method = this.findMatchingMethod(clazz, methodName, parameters);
            return method;
        }
        catch (NoSuchMethodException e) {
            if (clazz.getSuperclass() != null) {
                return this.method(target, clazz.getSuperclass(), methodName, parameters);
            }
            throw new ReflectiveException("Could not find method " + methodName + " with parameters " + Arrays.toString(parameters) + " on object " + target, e);
        }
    }

    private Method findMatchingMethod(Class<?> clazz, String methodName, Object[] parameters) throws NoSuchMethodException {
        Class<?>[] origTypes = this.types(parameters);
        try {
            return clazz.getDeclaredMethod(methodName, origTypes);
        }
        catch (NoSuchMethodException e) {
            Class<?>[] primitives = this.autoUnbox(origTypes);
            try {
                return clazz.getDeclaredMethod(methodName, primitives);
            }
            catch (NoSuchMethodException e1) {
                throw e;
            }
        }
    }

    private Method findMatchingMethod(Class<?> clazz, String methodName, TypedValue[] parameters) throws NoSuchMethodException {
        return clazz.getDeclaredMethod(methodName, this.types(parameters));
    }

    private Class<?>[] autoUnbox(Class<?>[] possiblyBoxed) {
        return (Class[])Arrays.stream(possiblyBoxed).map(clazz -> {
            try {
                return (Class)this.staticField((Class<?>)clazz, "TYPE");
            }
            catch (ReflectiveException e) {
                return clazz;
            }
        }).toArray(Class[]::new);
    }

    private Class<?> clazz(Object target) {
        return target.getClass();
    }

    Object invokeConstructor(String className, TypedValue ... parameters) {
        try {
            Constructor<?> constructor = this.constructor(className, parameters);
            return constructor.newInstance(this.objects(parameters));
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new ReflectiveException(e);
        }
    }

    private Object[] objects(TypedValue[] parameters) {
        return Arrays.stream(parameters).map(TypedValue::getObj).toArray();
    }

    Object invokeConstructor(String className, Object ... parameters) {
        try {
            Constructor<?> constructor = this.constructor(className, parameters);
            return constructor.newInstance(parameters);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new ReflectiveException(e);
        }
    }

    private Constructor<?> constructor(String className, TypedValue[] parameters) {
        try {
            Class<?> clazz = this.clazz(className);
            Constructor<?> constructor = clazz.getDeclaredConstructor(this.types(parameters));
            return constructor;
        }
        catch (NoSuchMethodException e) {
            throw new ReflectiveException(e);
        }
    }

    private Constructor<?> constructor(String className, Object[] parameters) {
        try {
            Class<?> clazz = this.clazz(className);
            Constructor<?> constructor = clazz.getDeclaredConstructor(this.types(parameters));
            return constructor;
        }
        catch (NoSuchMethodException e) {
            throw new ReflectiveException(e);
        }
    }

    Object createDynamicProxy(InvocationHandler invocationHandler, String ... interfaceNames) {
        Class[] clazzes = (Class[])Arrays.stream(interfaceNames).map(this::clazz).toArray(Class[]::new);
        return Proxy.newProxyInstance(this.classLoader, clazzes, invocationHandler);
    }

    Object staticField(String className, String fieldName) {
        Class<?> clazz = this.clazz(className);
        return this.staticField(clazz, fieldName);
    }

    private Object staticField(Class<?> clazz, String fieldName) {
        try {
            return clazz.getDeclaredField(fieldName).get(clazz);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new ReflectiveException(e);
        }
    }

    TypedValue typed(String className, Object obj) {
        return new TypedValue(this.clazz(className), obj);
    }

    public static class ReflectiveException
    extends RuntimeException {
        private static final long serialVersionUID = -5764607170953013791L;

        public ReflectiveException(String message, Throwable cause) {
            super(message, cause);
        }

        public ReflectiveException(Throwable cause) {
            super(cause);
        }
    }

    public static class TypedValue {
        private final Class<?> clazz;
        private final Object obj;

        public TypedValue(Class<?> clazz, Object obj) {
            this.clazz = Objects.requireNonNull(clazz);
            this.obj = Objects.requireNonNull(obj);
        }

        public Class<?> getClazz() {
            return this.clazz;
        }

        public Object getObj() {
            return this.obj;
        }

        public String toString() {
            return new StringJoiner(", ", TypedValue.class.getSimpleName() + "[", "]").add("clazz=" + this.clazz).add("obj=" + this.obj).toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TypedValue that = (TypedValue)o;
            return Objects.equals(this.clazz, that.clazz) && Objects.equals(this.obj, that.obj);
        }

        public int hashCode() {
            return Objects.hash(this.clazz, this.obj);
        }
    }
}

