/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.generic;

import com.diffplug.spotless.FormatterFunc;
import com.diffplug.spotless.FormatterStep;
import java.io.Serializable;
import java.util.Objects;

public final class ReplaceStep {
    private ReplaceStep() {
    }

    public static FormatterStep create(String name, CharSequence target, CharSequence replacement) {
        Objects.requireNonNull(name, "name");
        Objects.requireNonNull(target, "target");
        Objects.requireNonNull(replacement, "replacement");
        return FormatterStep.createLazy(name, () -> new State(target, replacement), State::toFormatter);
    }

    private static final class State
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final CharSequence target;
        private final CharSequence replacement;

        State(CharSequence target, CharSequence replacement) {
            this.target = target;
            this.replacement = replacement;
        }

        FormatterFunc toFormatter() {
            return raw -> raw.replace(this.target, this.replacement);
        }
    }
}

