/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.generic;

import com.diffplug.spotless.FormatterStep;
import com.diffplug.spotless.LineEnding;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.time.YearMonth;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class LicenseHeaderStep
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String NAME = "licenseHeader";
    private static final String DEFAULT_YEAR_DELIMITER = "-";
    private final String licenseHeader;
    private final Pattern delimiterPattern;
    private Pattern yearMatcherPattern;
    private boolean hasYearToken;
    private String licenseHeaderBeforeYearToken;
    private String licenseHeaderAfterYearToken;
    private String licenseHeaderWithYearTokenReplaced;

    public static FormatterStep createFromHeader(String licenseHeader, String delimiter) {
        return LicenseHeaderStep.createFromHeader(licenseHeader, delimiter, DEFAULT_YEAR_DELIMITER);
    }

    public static FormatterStep createFromHeader(String licenseHeader, String delimiter, String yearSeparator) {
        Objects.requireNonNull(licenseHeader, NAME);
        Objects.requireNonNull(delimiter, "delimiter");
        Objects.requireNonNull(yearSeparator, "yearSeparator");
        return FormatterStep.create(NAME, new LicenseHeaderStep(licenseHeader, delimiter, yearSeparator), step -> step::format);
    }

    public static FormatterStep createFromFile(File licenseHeaderFile, Charset encoding, String delimiter) {
        return LicenseHeaderStep.createFromFile(licenseHeaderFile, encoding, delimiter, DEFAULT_YEAR_DELIMITER);
    }

    public static FormatterStep createFromFile(File licenseHeaderFile, Charset encoding, String delimiter, String yearSeparator) {
        Objects.requireNonNull(licenseHeaderFile, "licenseHeaderFile");
        Objects.requireNonNull(encoding, "encoding");
        Objects.requireNonNull(delimiter, "delimiter");
        Objects.requireNonNull(yearSeparator, "yearSeparator");
        return FormatterStep.createLazy(NAME, () -> new LicenseHeaderStep(licenseHeaderFile, encoding, delimiter, yearSeparator), step -> step::format);
    }

    public static String name() {
        return NAME;
    }

    public static String defaultYearDelimiter() {
        return DEFAULT_YEAR_DELIMITER;
    }

    private LicenseHeaderStep(String licenseHeader, String delimiter, String yearSeparator) {
        if (delimiter.contains("\n")) {
            throw new IllegalArgumentException("The delimiter must not contain any newlines.");
        }
        if (!(licenseHeader = LineEnding.toUnix(licenseHeader)).endsWith("\n")) {
            licenseHeader = licenseHeader + "\n";
        }
        this.licenseHeader = licenseHeader;
        this.delimiterPattern = Pattern.compile('^' + delimiter, 9);
        this.hasYearToken = licenseHeader.contains("$YEAR");
        if (this.hasYearToken) {
            int yearTokenIndex = licenseHeader.indexOf("$YEAR");
            this.licenseHeaderBeforeYearToken = licenseHeader.substring(0, yearTokenIndex);
            this.licenseHeaderAfterYearToken = licenseHeader.substring(yearTokenIndex + 5, licenseHeader.length());
            this.licenseHeaderWithYearTokenReplaced = licenseHeader.replace("$YEAR", String.valueOf(YearMonth.now().getYear()));
            this.yearMatcherPattern = Pattern.compile("[0-9]{4}(" + Pattern.quote(yearSeparator) + "[0-9]{4})?");
        }
    }

    private LicenseHeaderStep(File licenseFile, Charset encoding, String delimiter, String yearSeparator) throws IOException {
        this(new String(Files.readAllBytes(licenseFile.toPath()), encoding), delimiter, yearSeparator);
    }

    public String format(String raw) {
        Matcher matcher = this.delimiterPattern.matcher(raw);
        if (!matcher.find()) {
            throw new IllegalArgumentException("Unable to find delimiter regex " + this.delimiterPattern);
        }
        if (this.hasYearToken) {
            if (this.matchesLicenseWithYearToken(raw, matcher)) {
                return raw;
            }
            return this.licenseHeaderWithYearTokenReplaced + raw.substring(matcher.start());
        }
        if (matcher.start() == this.licenseHeader.length() && raw.startsWith(this.licenseHeader)) {
            return raw;
        }
        return this.licenseHeader + raw.substring(matcher.start());
    }

    private boolean matchesLicenseWithYearToken(String raw, Matcher matcher) {
        int startOfTheSecondPart = raw.indexOf(this.licenseHeaderAfterYearToken);
        return startOfTheSecondPart > this.licenseHeaderBeforeYearToken.length() && raw.startsWith(this.licenseHeaderBeforeYearToken) && startOfTheSecondPart + this.licenseHeaderAfterYearToken.length() == matcher.start() && this.yearMatcherPattern.matcher(raw.substring(this.licenseHeaderBeforeYearToken.length(), startOfTheSecondPart)).matches();
    }
}

