/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.extra.groovy;

import com.diffplug.common.collect.ImmutableMap;
import com.diffplug.spotless.FormatterFunc;
import com.diffplug.spotless.Jvm;
import com.diffplug.spotless.Provisioner;
import com.diffplug.spotless.extra.EquoBasedStepBuilder;
import dev.equo.solstice.p2.P2Model;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Properties;

public final class GrEclipseFormatterStep {
    private static final String NAME = "eclipse groovy formatter";
    private static final Jvm.Support<String> JVM_SUPPORT = Jvm.support((String)"eclipse groovy formatter").add(17, (Object)"4.35");

    private GrEclipseFormatterStep() {
    }

    public static String defaultVersion() {
        return (String)JVM_SUPPORT.getRecommendedFormatterVersion();
    }

    public static EquoBasedStepBuilder createBuilder(Provisioner provisioner) {
        return new EquoBasedStepBuilder(NAME, provisioner, GrEclipseFormatterStep.defaultVersion(), GrEclipseFormatterStep::apply, ImmutableMap.builder()){

            @Override
            protected P2Model model(String version) {
                if (!version.startsWith("4.")) {
                    throw new IllegalArgumentException("Expected version 4.x");
                }
                int eVersion = Integer.parseInt(version.substring("4.".length()));
                if (eVersion < 8) {
                    throw new IllegalArgumentException("4.8 is the oldest version we support, this was " + version);
                }
                String greclipseVersion = eVersion >= 28 ? "5." + (eVersion - 28) + ".0" : (eVersion >= 18 ? "4." + (eVersion - 18) + ".0" : "3." + (eVersion - 8) + ".0");
                P2Model model = new P2Model();
                this.addPlatformRepo(model, version);
                model.addP2Repo("https://groovy.jfrog.io/artifactory/plugins-release/org/codehaus/groovy/groovy-eclipse-integration/" + greclipseVersion + "/e" + version + "/");
                model.getInstall().addAll(List.of("org.codehaus.groovy.eclipse.refactoring", "org.codehaus.groovy.eclipse.core", "org.eclipse.jdt.groovy.core", "org.codehaus.groovy"));
                model.addFilterAndValidate("no-debug", filter -> filter.exclude("org.eclipse.jdt.debug"));
                model.useMavenCentral = false;
                return model;
            }

            @Override
            public void setVersion(String version) {
                if (version.endsWith(".0")) {
                    String newVersion = version.substring(0, version.length() - 2);
                    System.err.println("Recommend replacing '" + version + "' with '" + newVersion + "' for eclipse JDT");
                    version = newVersion;
                }
                super.setVersion(version);
            }
        };
    }

    private static FormatterFunc apply(EquoBasedStepBuilder.State state) throws Exception {
        JVM_SUPPORT.assertFormatterSupported((Object)state.getSemanticVersion());
        Class<?> formatterClazz = state.getJarState().getClassLoader().loadClass("com.diffplug.spotless.extra.glue.groovy.GrEclipseFormatterStepImpl");
        Object formatter = formatterClazz.getConstructor(Properties.class).newInstance(state.getPreferences());
        Method method = formatterClazz.getMethod("format", String.class);
        return JVM_SUPPORT.suggestLaterVersionOnError((Object)state.getSemanticVersion(), input -> {
            try {
                return (String)method.invoke(formatter, input);
            }
            catch (InvocationTargetException exceptionWrapper) {
                Exception e;
                Throwable throwable = exceptionWrapper.getTargetException();
                Exception exception = throwable instanceof Exception ? (e = (Exception)throwable) : null;
                throw exception == null ? exceptionWrapper : exception;
            }
        });
    }
}

