/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.extra.integration;

import com.diffplug.common.base.CharMatcher;
import com.diffplug.common.base.Errors;
import com.diffplug.common.base.Preconditions;
import com.diffplug.common.base.Splitter;
import com.diffplug.spotless.Formatter;
import com.diffplug.spotless.LineEnding;
import com.diffplug.spotless.PaddedCell;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jgit.diff.DiffFormatter;
import org.eclipse.jgit.diff.Edit;
import org.eclipse.jgit.diff.EditList;
import org.eclipse.jgit.diff.MyersDiff;
import org.eclipse.jgit.diff.RawText;
import org.eclipse.jgit.diff.RawTextComparator;
import org.eclipse.jgit.diff.Sequence;
import org.eclipse.jgit.diff.SequenceComparator;

public final class DiffMessageFormatter {
    private static final int MAX_CHECK_MESSAGE_LINES = 50;
    public static final int MAX_FILES_TO_LIST = 10;
    private final StringBuilder buffer = new StringBuilder(3200);
    private int numLines = 0;
    private final CleanProvider formatter;
    private static final int MIN_LINES_PER_FILE = 4;
    private static final Splitter NEWLINE_SPLITTER = Splitter.on((char)'\n');
    private static final String NORMAL_INDENT = "    ";
    private static final String DIFF_INDENT = "        ";
    private static final CharMatcher NEWLINE_MATCHER = CharMatcher.is((char)'\n');
    private static final char MIDDLE_DOT = '\u00b7';

    public static Builder builder() {
        return new Builder();
    }

    private DiffMessageFormatter(CleanProvider formatter, List<File> problemFiles) throws IOException {
        this.formatter = Objects.requireNonNull(formatter, "formatter");
        ListIterator<File> problemIter = problemFiles.listIterator();
        while (problemIter.hasNext() && this.numLines < 50) {
            File file = problemIter.next();
            this.addFile(this.relativePath(file) + "\n" + this.diff(file));
        }
        if (problemIter.hasNext()) {
            int remainingFiles = problemFiles.size() - problemIter.nextIndex();
            if (remainingFiles >= 10) {
                this.buffer.append("Violations also present in ").append(remainingFiles).append(" other files.\n");
            } else {
                this.buffer.append("Violations also present in:\n");
                while (problemIter.hasNext()) {
                    this.addIntendedLine(NORMAL_INDENT, this.relativePath(problemIter.next()));
                }
            }
        }
    }

    private String relativePath(File file) {
        return this.formatter.getRootDir().relativize(file.toPath()).toString();
    }

    private void addFile(String arg) {
        List lines = NEWLINE_SPLITTER.splitToList((CharSequence)arg);
        if (!lines.isEmpty()) {
            this.addIntendedLine(NORMAL_INDENT, (String)lines.get(0));
        }
        for (int i = 1; i < Math.min(4, lines.size()); ++i) {
            this.addIntendedLine(DIFF_INDENT, (String)lines.get(i));
        }
        ListIterator iter = lines.listIterator(Math.min(4, lines.size()));
        while (iter.hasNext() && this.numLines < 50) {
            this.addIntendedLine(DIFF_INDENT, (String)iter.next());
        }
        if (this.numLines >= 50 && iter.hasNext()) {
            int linesLeft = lines.size() - iter.nextIndex();
            this.addIntendedLine(NORMAL_INDENT, "... (" + linesLeft + " more lines that didn't fit)");
        }
    }

    private void addIntendedLine(String indent, String line) {
        this.buffer.append(indent);
        this.buffer.append(line);
        this.buffer.append('\n');
        ++this.numLines;
    }

    private String diff(File file) throws IOException {
        return DiffMessageFormatter.diff(this.formatter, file).getValue();
    }

    public static Map.Entry<Integer, String> diff(Formatter formatter, File file) throws IOException {
        return DiffMessageFormatter.diff(new CleanProviderFormatter(formatter), file);
    }

    private static Map.Entry<Integer, String> diff(CleanProvider formatter, File file) throws IOException {
        String formatted;
        String formattedUnix;
        String raw = new String(Files.readAllBytes(file.toPath()), formatter.getEncoding());
        String rawUnix = LineEnding.toUnix((String)raw);
        if (rawUnix.equals(formattedUnix = LineEnding.toUnix((String)(formatted = formatter.getFormatted(file, rawUnix))))) {
            return DiffMessageFormatter.diffWhitespaceLineEndings(raw, formatted, false, true);
        }
        return DiffMessageFormatter.diffWhitespaceLineEndings(rawUnix, formattedUnix, true, false);
    }

    private static Map.Entry<Integer, String> diffWhitespaceLineEndings(String dirty, String clean, boolean whitespace, boolean lineEndings) throws IOException {
        dirty = DiffMessageFormatter.visibleWhitespaceLineEndings(dirty, whitespace, lineEndings);
        clean = DiffMessageFormatter.visibleWhitespaceLineEndings(clean, whitespace, lineEndings);
        RawText a = new RawText(dirty.getBytes(StandardCharsets.UTF_8));
        RawText b = new RawText(clean.getBytes(StandardCharsets.UTF_8));
        EditList edits = new EditList();
        edits.addAll((Collection)MyersDiff.INSTANCE.diff((SequenceComparator)RawTextComparator.DEFAULT, (Sequence)a, (Sequence)b));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (DiffFormatter formatter = new DiffFormatter((OutputStream)out);){
            formatter.format(edits, a, b);
        }
        String formatted = out.toString(StandardCharsets.UTF_8.name());
        formatted = formatted.replace("\\ No newline at end of file\n", "");
        return Map.entry(DiffMessageFormatter.getLineOfFirstDifference(edits), NEWLINE_MATCHER.trimTrailingFrom((CharSequence)formatted));
    }

    private static int getLineOfFirstDifference(EditList edits) {
        return edits.stream().mapToInt(Edit::getBeginA).min().getAsInt();
    }

    private static String visibleWhitespaceLineEndings(String input, boolean whitespace, boolean lineEndings) {
        if (whitespace) {
            input = input.replace(' ', '\u00b7').replace("\t", "\\t");
        }
        input = lineEndings ? input.replace("\n", "\\n\n").replace("\r", "\\r") : input.replace("\r", "");
        return input;
    }

    public static class Builder {
        private String runToFix;
        private CleanProvider formatter;
        private List<File> problemFiles;

        private Builder() {
        }

        public Builder runToFix(String runToFix) {
            this.runToFix = Objects.requireNonNull(runToFix);
            return this;
        }

        public Builder formatter(Formatter formatter) {
            this.formatter = new CleanProviderFormatter(formatter);
            return this;
        }

        public Builder formatterFolder(Path rootDir, Path cleanDir, String encoding) {
            this.formatter = new CleanProviderFolder(rootDir, cleanDir, encoding);
            return this;
        }

        public Builder problemFiles(List<File> problemFiles) {
            this.problemFiles = Objects.requireNonNull(problemFiles);
            Preconditions.checkArgument((!problemFiles.isEmpty() ? 1 : 0) != 0, (Object)"cannot be empty");
            return this;
        }

        public String getMessage() {
            try {
                Objects.requireNonNull(this.runToFix, "runToFix");
                Objects.requireNonNull(this.formatter, "formatter");
                Objects.requireNonNull(this.problemFiles, "problemFiles");
                DiffMessageFormatter diffFormater = new DiffMessageFormatter(this.formatter, this.problemFiles);
                return "The following files had format violations:\n" + diffFormater.buffer + this.runToFix;
            }
            catch (IOException e) {
                throw Errors.asRuntime((Throwable)e);
            }
        }
    }

    private static class CleanProviderFolder
    implements CleanProvider {
        private final Path rootDir;
        private final Path cleanDir;
        private final Charset encoding;

        CleanProviderFolder(Path rootDir, Path cleanDir, String encoding) {
            this.rootDir = rootDir;
            this.cleanDir = cleanDir;
            this.encoding = Charset.forName(encoding);
        }

        @Override
        public Path getRootDir() {
            return this.rootDir;
        }

        @Override
        public Charset getEncoding() {
            return this.encoding;
        }

        @Override
        public String getFormatted(File file, String rawUnix) {
            Path clean = this.cleanDir.resolve(this.rootDir.relativize(file.toPath()));
            byte[] content = (byte[])Errors.rethrow().get(() -> Files.readAllBytes(clean));
            return new String(content, this.encoding);
        }
    }

    private static class CleanProviderFormatter
    implements CleanProvider {
        private final Formatter formatter;

        CleanProviderFormatter(Formatter formatter) {
            this.formatter = Objects.requireNonNull(formatter);
        }

        @Override
        public Path getRootDir() {
            return this.formatter.getRootDir();
        }

        @Override
        public Charset getEncoding() {
            return this.formatter.getEncoding();
        }

        @Override
        public String getFormatted(File file, String rawUnix) {
            String unix = PaddedCell.check((Formatter)this.formatter, (File)file, (String)rawUnix).canonical();
            return this.formatter.computeLineEndings(unix, file);
        }
    }

    static interface CleanProvider {
        public Path getRootDir();

        public Charset getEncoding();

        public String getFormatted(File var1, String var2);
    }
}

