/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.extra;

import com.diffplug.common.base.Errors;
import com.diffplug.spotless.FileSignature;
import com.diffplug.spotless.FormatterFunc;
import com.diffplug.spotless.FormatterProperties;
import com.diffplug.spotless.FormatterStep;
import com.diffplug.spotless.JarState;
import com.diffplug.spotless.Provisioner;
import com.diffplug.spotless.ThrowingEx;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;

public class EclipseBasedStepBuilder {
    private final String formatterName;
    private final String formatterStepExt;
    private final ThrowingEx.Function<State, FormatterFunc> stateToFormatter;
    private final Provisioner jarProvisioner;
    private String formatterVersion;
    private static final String ECLIPSE_FORMATTER_RESOURCES = EclipseBasedStepBuilder.class.getPackage().getName().replace('.', '/');
    private List<String> dependencies = new ArrayList<String>();
    private Iterable<File> settingsFiles = new ArrayList<File>();

    public EclipseBasedStepBuilder(String formatterName, Provisioner jarProvisioner, ThrowingEx.Function<State, FormatterFunc> stateToFormatter) {
        this(formatterName, "", jarProvisioner, stateToFormatter);
    }

    public EclipseBasedStepBuilder(String formatterName, String formatterStepExt, Provisioner jarProvisioner, ThrowingEx.Function<State, FormatterFunc> stateToFormatter) {
        this.formatterName = Objects.requireNonNull(formatterName, "formatterName");
        this.formatterStepExt = Objects.requireNonNull(formatterStepExt, "formatterStepExt");
        this.jarProvisioner = Objects.requireNonNull(jarProvisioner, "jarProvisioner");
        this.stateToFormatter = Objects.requireNonNull(stateToFormatter, "stateToFormatter");
        this.formatterVersion = "No version set";
    }

    public FormatterStep build() {
        return FormatterStep.createLazy((String)(this.formatterName + this.formatterStepExt), this::get, this.stateToFormatter);
    }

    public void setVersion(String version) {
        String url = "/" + ECLIPSE_FORMATTER_RESOURCES + "/" + this.formatterName.replace(' ', '_') + "/v" + version + ".lockfile";
        InputStream depsFile = EclipseBasedStepBuilder.class.getResourceAsStream(url);
        if (depsFile == null) {
            throw new IllegalArgumentException("No such version " + version + ", expected at " + url);
        }
        byte[] content = EclipseBasedStepBuilder.toByteArray(depsFile);
        String allLines = new String(content, StandardCharsets.UTF_8);
        String[] lines = allLines.split("\n");
        this.dependencies.clear();
        for (String line : lines) {
            if (line.startsWith("#")) continue;
            this.dependencies.add(line);
        }
        this.formatterVersion = version;
    }

    private static byte[] toByteArray(InputStream in) {
        ByteArrayOutputStream to = new ByteArrayOutputStream();
        byte[] buf = new byte[8192];
        try {
            int r;
            while ((r = in.read(buf)) != -1) {
                to.write(buf, 0, r);
            }
            return to.toByteArray();
        }
        catch (IOException e) {
            throw Errors.asRuntime((Throwable)e);
        }
    }

    public void setPreferences(Iterable<File> settingsFiles) {
        this.settingsFiles = settingsFiles;
    }

    State get() throws IOException {
        return new State(this.formatterVersion, this.formatterStepExt, this.jarProvisioner, this.dependencies, this.settingsFiles);
    }

    public static class State
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final JarState jarState;
        private final String semanticVersion;
        private final String formatterStepExt;
        private final FileSignature settingsFiles;

        protected State(String formatterVersion, String formatterStepExt, Provisioner jarProvisioner, List<String> dependencies, Iterable<File> settingsFiles) throws IOException {
            this.jarState = JarState.withoutTransitives(dependencies, (Provisioner)jarProvisioner);
            this.settingsFiles = FileSignature.signAsList(settingsFiles);
            this.formatterStepExt = formatterStepExt;
            this.semanticVersion = State.convertEclipseVersion(formatterVersion);
        }

        private static String convertEclipseVersion(String version) {
            char lastChar;
            String semanticVersion = version;
            if (1 < version.length() && '.' != (lastChar = version.charAt(version.length() - 1)) && 'a' <= lastChar) {
                semanticVersion = version.substring(0, version.length() - 1);
                semanticVersion = semanticVersion + String.format(".%d", lastChar);
            }
            return semanticVersion;
        }

        public String getSemanticVersion() {
            return this.semanticVersion;
        }

        public Properties getPreferences() {
            FormatterProperties preferences = FormatterProperties.from((Iterable)this.settingsFiles.files());
            return preferences.getProperties();
        }

        public Optional<String> getMavenCoordinate(String prefix) {
            return this.jarState.getMavenCoordinates().stream().filter(coordinate -> coordinate.startsWith(prefix)).findFirst();
        }

        public Class<?> loadClass(String name) {
            try {
                return this.jarState.getClassLoader((Serializable)this).loadClass(name);
            }
            catch (ClassNotFoundException e) {
                throw Errors.asRuntime((Throwable)e);
            }
        }
    }
}

