/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.extra.java;

import com.diffplug.spotless.FileSignature;
import com.diffplug.spotless.FormatterFunc;
import com.diffplug.spotless.FormatterProperties;
import com.diffplug.spotless.FormatterStep;
import com.diffplug.spotless.JarState;
import com.diffplug.spotless.Provisioner;
import java.io.File;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Objects;
import java.util.Properties;

public final class EclipseFormatterStep {
    private static final String DEFAULT_VERSION = "4.6.3";
    private static final String NAME = "eclipse formatter";
    private static final String MAVEN_COORDINATE = "com.diffplug.spotless:spotless-ext-eclipse-jdt:";
    private static final String FORMATTER_CLASS = "com.diffplug.gradle.spotless.java.eclipse.EclipseFormatterStepImpl";
    private static final String FORMATTER_METHOD = "format";

    private EclipseFormatterStep() {
    }

    @Deprecated
    public static FormatterStep create(File settingsFile, Provisioner provisioner) {
        return EclipseFormatterStep.create(Collections.singletonList(settingsFile), provisioner);
    }

    public static FormatterStep create(Iterable<File> settingsFiles, Provisioner provisioner) {
        return EclipseFormatterStep.create(EclipseFormatterStep.defaultVersion(), settingsFiles, provisioner);
    }

    @Deprecated
    public static FormatterStep create(String version, File settingsFile, Provisioner provisioner) {
        return EclipseFormatterStep.create(version, Collections.singletonList(settingsFile), provisioner);
    }

    public static FormatterStep create(String version, Iterable<File> settingsFiles, Provisioner provisioner) {
        Objects.requireNonNull(version, "version");
        Objects.requireNonNull(settingsFiles, "settingsFiles");
        Objects.requireNonNull(provisioner, "provisioner");
        return FormatterStep.createLazy((String)NAME, () -> new State(JarState.from((String)(MAVEN_COORDINATE + version), (Provisioner)provisioner), settingsFiles), State::createFormat);
    }

    public static String defaultVersion() {
        return DEFAULT_VERSION;
    }

    private static class State
    implements Serializable {
        private static final long serialVersionUID = 1L;
        final JarState jarState;
        final FileSignature settings;

        State(JarState jar, Iterable<File> settingsFiles) throws Exception {
            this.jarState = jar;
            this.settings = FileSignature.signAsList(settingsFiles);
        }

        FormatterFunc createFormat() throws Exception {
            FormatterProperties preferences = FormatterProperties.from((Iterable)this.settings.files());
            ClassLoader classLoader = this.jarState.getClassLoader();
            Class<?> formatterClazz = classLoader.loadClass(EclipseFormatterStep.FORMATTER_CLASS);
            Object formatter = formatterClazz.getConstructor(Properties.class).newInstance(preferences.getProperties());
            Method method = formatterClazz.getMethod(EclipseFormatterStep.FORMATTER_METHOD, String.class);
            return input -> (String)method.invoke(formatter, input);
        }
    }
}

