/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.extra.integration;

import com.diffplug.common.base.Errors;
import com.diffplug.common.base.Preconditions;
import com.diffplug.common.base.Splitter;
import com.diffplug.spotless.Formatter;
import com.diffplug.spotless.LineEnding;
import com.diffplug.spotless.PaddedCell;
import com.diffplug.spotless.extra.integration.WriteSpaceAwareDiffFormatter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import org.eclipse.jgit.diff.EditList;
import org.eclipse.jgit.diff.HistogramDiff;
import org.eclipse.jgit.diff.RawText;
import org.eclipse.jgit.diff.RawTextComparator;
import org.eclipse.jgit.diff.Sequence;
import org.eclipse.jgit.diff.SequenceComparator;

public final class DiffMessageFormatter {
    private static final int MAX_CHECK_MESSAGE_LINES = 50;
    public static final int MAX_FILES_TO_LIST = 10;
    private final StringBuilder buffer = new StringBuilder(3200);
    private int numLines = 0;
    private static final int MIN_LINES_PER_FILE = 4;
    private static final Splitter NEWLINE_SPLITTER = Splitter.on((char)'\n');
    private static final String NORMAL_INDENT = "    ";
    private static final String DIFF_INDENT = "        ";

    public static Builder builder() {
        return new Builder();
    }

    private DiffMessageFormatter(Builder builder) throws IOException {
        ListIterator problemIter = builder.problemFiles.listIterator();
        while (problemIter.hasNext() && this.numLines < 50) {
            File file = (File)problemIter.next();
            this.addFile(builder.relativePath(file) + "\n" + DiffMessageFormatter.diff(builder, file));
        }
        if (problemIter.hasNext()) {
            int remainingFiles = builder.problemFiles.size() - problemIter.nextIndex();
            if (remainingFiles >= 10) {
                this.buffer.append("Violations also present in ").append(remainingFiles).append(" other files.\n");
            } else {
                this.buffer.append("Violations also present in:\n");
                while (problemIter.hasNext()) {
                    this.addIntendedLine(NORMAL_INDENT, builder.relativePath((File)problemIter.next()));
                }
            }
        }
    }

    private void addFile(String arg) {
        List lines = NEWLINE_SPLITTER.splitToList((CharSequence)arg);
        if (!lines.isEmpty()) {
            this.addIntendedLine(NORMAL_INDENT, (String)lines.get(0));
        }
        for (int i = 1; i < Math.min(4, lines.size()); ++i) {
            this.addIntendedLine(DIFF_INDENT, (String)lines.get(i));
        }
        ListIterator iter = lines.listIterator(Math.min(4, lines.size()));
        while (iter.hasNext() && (this.numLines < 50 || lines.size() - iter.nextIndex() == 1)) {
            this.addIntendedLine(DIFF_INDENT, (String)iter.next());
        }
        if (this.numLines >= 50 && iter.hasNext()) {
            int linesLeft = lines.size() - iter.nextIndex();
            this.addIntendedLine(NORMAL_INDENT, "... (" + linesLeft + " more lines that didn't fit)");
        }
    }

    private void addIntendedLine(String indent, String line) {
        this.buffer.append(indent);
        this.buffer.append(line);
        this.buffer.append('\n');
        ++this.numLines;
    }

    private static String diff(Builder builder, File file) throws IOException {
        Charset encoding = builder.formatter.getEncoding();
        String raw = new String(Files.readAllBytes(file.toPath()), encoding);
        String rawUnix = LineEnding.toUnix((String)raw);
        String formattedUnix = builder.isPaddedCell ? PaddedCell.check((Formatter)builder.formatter, (File)file, (String)rawUnix).canonical() : builder.formatter.compute(rawUnix, file);
        String formatted = builder.formatter.computeLineEndings(formattedUnix, file);
        return DiffMessageFormatter.visualizeDiff(raw, formatted);
    }

    private static String visualizeDiff(String raw, String formattedBytes) throws IOException {
        RawText a = new RawText(raw.getBytes(StandardCharsets.UTF_8));
        RawText b = new RawText(formattedBytes.getBytes(StandardCharsets.UTF_8));
        EditList edits = new HistogramDiff().diff((SequenceComparator)RawTextComparator.DEFAULT, (Sequence)a, (Sequence)b);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        new WriteSpaceAwareDiffFormatter(out, Charset.defaultCharset()).format(edits, a, b);
        return new String(out.toByteArray(), StandardCharsets.UTF_8);
    }

    public static class Builder {
        private String runToFix;
        private boolean isPaddedCell;
        private Formatter formatter;
        private List<File> problemFiles;

        private Builder() {
        }

        public Builder runToFix(String runToFix) {
            this.runToFix = Objects.requireNonNull(runToFix);
            return this;
        }

        public Builder isPaddedCell(boolean isPaddedCell) {
            this.isPaddedCell = isPaddedCell;
            return this;
        }

        public Builder formatter(Formatter formatter) {
            this.formatter = Objects.requireNonNull(formatter);
            return this;
        }

        public Builder problemFiles(List<File> problemFiles) {
            this.problemFiles = Objects.requireNonNull(problemFiles);
            Preconditions.checkArgument((!problemFiles.isEmpty() ? 1 : 0) != 0, (Object)"cannot be empty");
            return this;
        }

        public String getMessage() {
            try {
                Objects.requireNonNull(this.runToFix, "runToFix");
                Objects.requireNonNull(this.formatter, "formatter");
                Objects.requireNonNull(this.problemFiles, "problemFiles");
                DiffMessageFormatter diffFormater = new DiffMessageFormatter(this);
                return "The following files had format violations:\n" + diffFormater.buffer + this.runToFix;
            }
            catch (IOException e) {
                throw Errors.asRuntime((Throwable)e);
            }
        }

        String relativePath(File file) {
            return this.formatter.getRootDir().relativize(file.toPath()).toString();
        }
    }
}

