/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.dtd.core.internal;

import org.eclipse.wst.dtd.core.internal.DTDCoreMessages;
import org.eclipse.wst.dtd.core.internal.DTDFile;
import org.eclipse.wst.dtd.core.internal.ExternalNode;
import org.eclipse.wst.dtd.core.internal.text.RegionIterator;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;

public class Entity
extends ExternalNode {
    private static String setExternalEntity = DTDCoreMessages._UI_LABEL_ENTITY_SET_EXT_ENTITY;
    private static String setGeneralEntity = DTDCoreMessages._UI_LABEL_ENTITY_SET_GENERAL_ENTITY;
    private static String setInternalEntity = DTDCoreMessages._UI_LABEL_ENTITY_SET_INT_ENTITY;
    private static String setParameterEntity = DTDCoreMessages._UI_LABEL_ENTITY_SET_PARM_ENTITY;

    public Entity(DTDFile file, IStructuredDocumentRegion flatNode) {
        super(file, flatNode, "org.eclipse.wst.dtd.core.internal.util.parser.DTDRegionTypes.ENTITY_TAG");
    }

    @Override
    public String getImagePath() {
        return "icons/full/obj16/entity.gif";
    }

    public String getNotationName() {
        ITextRegion ndataRegion = this.getNextRegion(this.iterator(), "org.eclipse.wst.dtd.core.internal.util.parser.DTDRegionTypes.NDATA_VALUE");
        if (ndataRegion != null) {
            return this.getStructuredDTDDocumentRegion().getText(ndataRegion);
        }
        return "";
    }

    public ITextRegion getPercentRegion() {
        return this.getNextRegion(this.iterator(), "org.eclipse.wst.dtd.core.internal.util.parser.DTDRegionTypes.PERCENT");
    }

    public String getValue() {
        ITextRegion valueRegion;
        if (!this.isExternalEntity() && (valueRegion = this.getNextQuotedLiteral(this.iterator())) != null) {
            return this.getValueFromQuotedRegion(valueRegion);
        }
        return "";
    }

    public boolean isExternalEntity() {
        return this.getPublicKeywordRegion(this.iterator()) != null || this.getSystemKeywordRegion(this.iterator()) != null;
    }

    public boolean isParameterEntity() {
        return this.getPercentRegion() != null;
    }

    private void removeNData(Object requestor) {
        ITextRegion value;
        ITextRegion ndataRegion = null;
        ndataRegion = this.getNextRegion(this.iterator(), "org.eclipse.wst.dtd.core.internal.util.parser.DTDRegionTypes.NDATA_KEYWORD");
        int startOffset = 0;
        int endOffset = 0;
        if (ndataRegion != null) {
            startOffset = this.getStructuredDTDDocumentRegion().getStartOffset(ndataRegion);
            endOffset = this.getStructuredDTDDocumentRegion().getEndOffset(ndataRegion);
        }
        if ((value = this.getNextRegion(this.iterator(), "org.eclipse.wst.dtd.core.internal.util.parser.DTDRegionTypes.NDATA_VALUE")) != null) {
            if (startOffset == 0) {
                startOffset = this.getStructuredDTDDocumentRegion().getStartOffset(value);
            }
            endOffset = this.getStructuredDTDDocumentRegion().getEndOffset(value);
        }
        this.replaceText(requestor, startOffset, endOffset - startOffset, "");
    }

    public void setExternalEntity(boolean isExternalEntity) {
        if (this.isExternalEntity() != isExternalEntity) {
            this.beginRecording(this, isExternalEntity ? setExternalEntity : setInternalEntity);
            if (isExternalEntity) {
                ITextRegion quote = this.getNextRegion(this.iterator(), "org.eclipse.wst.dtd.core.internal.util.parser.DTDRegionTypes.SINGLEQUOTED_LITERAL");
                if (quote == null) {
                    quote = this.getNextRegion(this.iterator(), "org.eclipse.wst.dtd.core.internal.util.parser.DTDRegionTypes.DOUBLEQUOTED_LITERAL");
                }
                if (quote != null) {
                    this.replaceText(this, this.getStructuredDTDDocumentRegion().getStartOffset(quote), quote.getLength(), "");
                }
                this.setSystemID("");
            } else {
                RegionIterator iter = this.iterator();
                ITextRegion keyword = this.getSystemKeywordRegion(iter);
                int startOffset = 0;
                int length = 0;
                if (keyword == null) {
                    iter = this.iterator();
                    keyword = this.getPublicKeywordRegion(iter);
                }
                if (keyword != null) {
                    startOffset = this.getStructuredDTDDocumentRegion().getStartOffset(keyword);
                    length = keyword.getLength();
                } else {
                    iter = this.iterator();
                    startOffset = this.getStructuredDTDDocumentRegion().getEndOffset(this.getNameRegion());
                }
                ITextRegion lastRegion = null;
                if (lastRegion == null) {
                    while (iter.hasNext()) {
                        ITextRegion literal = this.getNextQuotedLiteral(iter);
                        if (literal == null) continue;
                        lastRegion = literal;
                    }
                }
                if (lastRegion != null) {
                    length = this.getStructuredDTDDocumentRegion().getEndOffset(lastRegion) - startOffset;
                }
                this.replaceText(this, startOffset, length, "\"\"");
                this.removeNData(this);
            }
            this.endRecording(this);
        }
    }

    public void setNotationName(Object requestor, String newNotation) {
        if (!this.getNotationName().equals(newNotation)) {
            if (!newNotation.equals("")) {
                ITextRegion ndataRegion = this.getNextRegion(this.iterator(), "org.eclipse.wst.dtd.core.internal.util.parser.DTDRegionTypes.NDATA_VALUE");
                if (ndataRegion != null) {
                    this.replaceText(requestor, this.getStructuredDTDDocumentRegion().getStartOffset(ndataRegion), ndataRegion.getLength(), newNotation);
                } else {
                    int startOffset = 0;
                    String string = "";
                    RegionIterator iter = this.iterator();
                    ITextRegion ndataKeyword = this.getNextRegion(iter, "org.eclipse.wst.dtd.core.internal.util.parser.DTDRegionTypes.NDATA_KEYWORD");
                    if (ndataKeyword == null) {
                        string = String.valueOf(string) + " NDATA ";
                        iter = this.iterator();
                        ITextRegion lastQuotedLiteral = null;
                        while (iter.hasNext()) {
                            ITextRegion literal = this.getNextQuotedLiteral(iter);
                            if (literal == null) continue;
                            lastQuotedLiteral = literal;
                        }
                        if (lastQuotedLiteral != null) {
                            startOffset = this.getStructuredDTDDocumentRegion().getEndOffset(lastQuotedLiteral);
                        } else {
                            ITextRegion keyword = this.getPublicKeywordRegion(this.iterator());
                            if (keyword == null) {
                                keyword = this.getSystemKeywordRegion(this.iterator());
                            }
                            startOffset = this.getStructuredDTDDocumentRegion().getEndOffset(keyword);
                        }
                    } else {
                        startOffset = this.getStructuredDTDDocumentRegion().getEndOffset(ndataKeyword);
                    }
                    this.replaceText(requestor, startOffset, 0, String.valueOf(string) + newNotation);
                }
            } else {
                this.removeNData(requestor);
            }
        }
    }

    public void setNotationName(String newNotation) {
        this.beginRecording(this, "NDATA " + DTDCoreMessages._UI_LABEL_ENTITY_NDATA_CHANGE);
        this.setNotationName(this, newNotation);
        this.endRecording(this);
    }

    public void setParameterEntity(boolean v) {
        if (this.isParameterEntity() != v) {
            this.beginRecording(this, v ? setParameterEntity : setGeneralEntity);
            if (v) {
                RegionIterator iter = this.iterator();
                ITextRegion startTag = this.getNextRegion(iter, "org.eclipse.wst.dtd.core.internal.util.parser.DTDRegionTypes.ENTITY_TAG");
                int startOffset = 0;
                int length = 0;
                if (iter.hasNext()) {
                    ITextRegion region = iter.next();
                    startOffset = this.getStructuredDTDDocumentRegion().getStartOffset(region);
                    if (region.getType() == "org.eclipse.wst.dtd.core.internal.util.parser.DTDRegionTypes.WHITESPACE" && region.getLength() > 1) {
                        length = 1;
                    }
                } else {
                    startOffset = this.getStructuredDTDDocumentRegion().getEndOffset(startTag);
                }
                this.replaceText(this, startOffset, length, " %");
                this.removeNData(this);
            } else {
                ITextRegion percentRegion = this.getPercentRegion();
                this.replaceText(this, this.getStructuredDTDDocumentRegion().getStartOffset(percentRegion), percentRegion.getLength(), "");
            }
            this.endRecording(this);
        }
    }

    public void setValue(Object requestor, String v) {
        if (!this.isExternalEntity() && !this.getValue().equals(v)) {
            String quoteChar;
            ITextRegion valueRegion = this.getNextQuotedLiteral(this.iterator());
            String string = quoteChar = v.indexOf("\"") == -1 ? "\"" : "'";
            if (valueRegion != null) {
                this.replaceText(requestor, this.getStructuredDTDDocumentRegion().getStartOffset(valueRegion), valueRegion.getLength(), String.valueOf(quoteChar) + v + quoteChar);
            } else {
                int startOffset = 0;
                RegionIterator iter = this.iterator();
                ITextRegion region = this.getNextRegion(iter, "org.eclipse.wst.dtd.core.internal.util.parser.DTDRegionTypes.NAME");
                if (region == null) {
                    region = this.getPercentRegion();
                }
                if (region == null) {
                    region = this.getStartTag(this.iterator());
                }
                if (region != null) {
                    startOffset = this.getStructuredDTDDocumentRegion().getEndOffset(region);
                    this.replaceText(requestor, startOffset, 0, String.valueOf(quoteChar) + v + quoteChar);
                }
            }
        }
    }

    public void setValue(String v) {
        this.beginRecording(this, DTDCoreMessages._UI_LABEL_ENTITY_VALUE_CHG);
        this.setValue(this, v);
        this.endRecording(this);
    }
}

