/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.internal.modelquery;

import java.io.File;
import java.net.URI;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.sse.core.internal.provisional.AbstractAdapterFactory;
import org.eclipse.wst.sse.core.internal.provisional.IModelStateListener;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapter;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapterFactory;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.util.URIResolver;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.CMDocumentManager;
import org.eclipse.wst.xml.core.internal.contentmodel.util.CMDocumentCache;
import org.eclipse.wst.xml.core.internal.modelquery.XMLCatalogIdResolver;
import org.eclipse.wst.xml.core.internal.modelquery.XMLModelQueryImpl;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.core.internal.ssemodelquery.ModelQueryAdapter;
import org.eclipse.wst.xml.core.internal.ssemodelquery.ModelQueryAdapterImpl;

public class ModelQueryAdapterFactoryForXML
extends AbstractAdapterFactory {
    protected ModelQueryAdapterImpl modelQueryAdapterImpl;
    IStructuredModel stateNotifier = null;
    private InternalModelStateListener internalModelStateListener;

    public ModelQueryAdapterFactoryForXML() {
        this(ModelQueryAdapter.class, true);
    }

    protected ModelQueryAdapterFactoryForXML(Object adapterKey, boolean registerAdapters) {
        super(adapterKey, registerAdapters);
    }

    protected boolean autoLoadCM() {
        return true;
    }

    protected void configureDocumentManager(CMDocumentManager mgr) {
        mgr.setPropertyEnabled("autoLoad", this.autoLoadCM());
    }

    @Override
    public INodeAdapterFactory copy() {
        return new ModelQueryAdapterFactoryForXML(this.getAdapterKey(), this.isShouldRegisterAdapter());
    }

    @Override
    protected INodeAdapter createAdapter(INodeNotifier target) {
        if (this.modelQueryAdapterImpl == null && target instanceof IDOMNode) {
            IDOMNode xmlNode = (IDOMNode)target;
            IDOMModel model = xmlNode.getModel();
            this.stateNotifier = xmlNode.getModel();
            this.stateNotifier.addModelStateListener(this.getInternalModelStateListener());
            URIResolver resolver = model.getResolver();
            XMLCatalogIdResolver idResolver = null;
            if (resolver != null) {
                idResolver = new XMLCatalogIdResolver(resolver.getFileBaseLocation(), resolver);
            } else {
                String baseLocation = null;
                String modelsBaseLocation = model.getBaseLocation();
                if (modelsBaseLocation != null) {
                    File file = new Path(modelsBaseLocation).toFile();
                    if (file.exists()) {
                        baseLocation = file.getAbsolutePath();
                    } else {
                        Path basePath = new Path(model.getBaseLocation());
                        Object derivedResource = null;
                        derivedResource = basePath.segmentCount() > 1 ? ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)basePath) : ResourcesPlugin.getWorkspace().getRoot().getProject(basePath.segment(0));
                        IPath derivedPath = derivedResource.getLocation();
                        if (derivedPath != null) {
                            baseLocation = derivedPath.toString();
                        } else {
                            URI uri = derivedResource.getLocationURI();
                            if (uri != null) {
                                baseLocation = uri.toString();
                            }
                        }
                    }
                    if (baseLocation == null) {
                        baseLocation = modelsBaseLocation;
                    }
                }
                idResolver = new XMLCatalogIdResolver(baseLocation, null);
            }
            CMDocumentCache cmDocumentCache = new CMDocumentCache();
            XMLModelQueryImpl modelQuery = new XMLModelQueryImpl(cmDocumentCache, idResolver);
            CMDocumentManager documentManager = modelQuery.getCMDocumentManager();
            if (documentManager != null) {
                this.configureDocumentManager(documentManager);
            }
            this.modelQueryAdapterImpl = new ModelQueryAdapterImpl(cmDocumentCache, modelQuery, idResolver);
        }
        return this.modelQueryAdapterImpl;
    }

    @Override
    public void release() {
        super.release();
        if (this.stateNotifier != null) {
            this.stateNotifier.removeModelStateListener(this.getInternalModelStateListener());
        }
        this.stateNotifier = null;
        if (this.modelQueryAdapterImpl != null) {
            this.modelQueryAdapterImpl.release();
        }
    }

    protected void updateResolver(IStructuredModel model) {
        String baseLocation = model.getBaseLocation();
        IFile baseFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(model.getBaseLocation()));
        if (baseFile != null) {
            if (baseFile.getLocation() != null) {
                baseLocation = baseFile.getLocation().toString();
            }
            if (baseLocation == null && baseFile.getLocationURI() != null) {
                baseLocation = baseFile.getLocationURI().toString();
            }
            if (baseLocation == null) {
                baseLocation = baseFile.getFullPath().toString();
            }
        } else {
            baseLocation = model.getBaseLocation();
        }
        this.modelQueryAdapterImpl.setIdResolver(new XMLCatalogIdResolver(baseLocation, model.getResolver()));
    }

    private final InternalModelStateListener getInternalModelStateListener() {
        if (this.internalModelStateListener == null) {
            this.internalModelStateListener = new InternalModelStateListener();
        }
        return this.internalModelStateListener;
    }

    class InternalModelStateListener
    implements IModelStateListener {
        InternalModelStateListener() {
        }

        @Override
        public void modelAboutToBeChanged(IStructuredModel model) {
        }

        @Override
        public void modelChanged(IStructuredModel model) {
        }

        @Override
        public void modelDirtyStateChanged(IStructuredModel model, boolean isDirty) {
        }

        @Override
        public void modelResourceDeleted(IStructuredModel model) {
        }

        @Override
        public void modelResourceMoved(IStructuredModel oldModel, IStructuredModel newModel) {
            ModelQueryAdapterFactoryForXML.this.stateNotifier.removeModelStateListener(this);
            ModelQueryAdapterFactoryForXML.this.stateNotifier = newModel;
            ModelQueryAdapterFactoryForXML.this.updateResolver(ModelQueryAdapterFactoryForXML.this.stateNotifier);
            ModelQueryAdapterFactoryForXML.this.stateNotifier.addModelStateListener(this);
        }

        @Override
        public void modelAboutToBeReinitialized(IStructuredModel structuredModel) {
        }

        @Override
        public void modelReinitialized(IStructuredModel structuredModel) {
            ModelQueryAdapterFactoryForXML.this.updateResolver(structuredModel);
        }
    }
}

