/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.ui.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.IEditorStatusLine;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.actions.ActionMessages;
import org.eclipse.wst.jsdt.internal.ui.actions.ActionUtil;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.IClassFileEditorInput;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.wst.jsdt.internal.ui.search.ExceptionOccurrencesFinder;
import org.eclipse.wst.jsdt.internal.ui.search.FindOccurrencesEngine;
import org.eclipse.wst.jsdt.ui.actions.SelectionDispatchAction;

public class FindExceptionOccurrencesAction
extends SelectionDispatchAction {
    private JavaEditor fEditor;

    public FindExceptionOccurrencesAction(JavaEditor editor) {
        this((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
        this.setEnabled(FindExceptionOccurrencesAction.getEditorInput(editor) != null);
    }

    public FindExceptionOccurrencesAction(IWorkbenchSite site) {
        super(site);
        this.setText(ActionMessages.FindExceptionOccurrences_text);
        this.setToolTipText(ActionMessages.FindExceptionOccurrences_toolTip);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.wst.jsdt.ui.find_exception_occurrences");
    }

    @Override
    public void selectionChanged(ITextSelection selection) {
    }

    @Override
    public void selectionChanged(IStructuredSelection selection) {
        this.setEnabled(this.getMember(selection) != null);
    }

    @Override
    public final void run(ITextSelection ts) {
        IJavaScriptElement input = FindExceptionOccurrencesAction.getEditorInput(this.fEditor);
        if (!ActionUtil.isProcessable(this.getShell(), input)) {
            return;
        }
        FindOccurrencesEngine engine = FindOccurrencesEngine.create(input, new ExceptionOccurrencesFinder());
        try {
            String result = engine.run(ts.getOffset(), ts.getLength());
            if (result != null) {
                FindExceptionOccurrencesAction.showMessage(this.getShell(), this.fEditor, result);
            }
        }
        catch (JavaScriptModelException e) {
            JavaScriptPlugin.log((Throwable)((Object)e));
        }
    }

    private static IJavaScriptElement getEditorInput(JavaEditor editor) {
        IEditorInput input = editor.getEditorInput();
        if (input instanceof IClassFileEditorInput) {
            return ((IClassFileEditorInput)input).getClassFile();
        }
        return JavaScriptPlugin.getDefault().getWorkingCopyManager().getWorkingCopy(input);
    }

    private static void showMessage(Shell shell, JavaEditor editor, String msg) {
        IEditorStatusLine statusLine = (IEditorStatusLine)editor.getAdapter(IEditorStatusLine.class);
        if (statusLine != null) {
            statusLine.setMessage(true, msg, null);
        }
        shell.getDisplay().beep();
    }

    private IMember getMember(IStructuredSelection selection) {
        return null;
    }
}

