/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.jsdt.core.IIncludePathEntry;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJsGlobalScopeContainer;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.CPListElement;

public class CPUserLibraryElement {
    private String fName;
    private List fChildren;

    public CPUserLibraryElement(String name, IJsGlobalScopeContainer container, IJavaScriptProject project) {
        this.fName = name;
        this.fChildren = new ArrayList();
        if (container != null) {
            IIncludePathEntry[] entries = container.getIncludepathEntries();
            CPListElement[] res = new CPListElement[entries.length];
            int i = 0;
            while (i < res.length) {
                IIncludePathEntry curr = entries[i];
                CPListElement elem = CPListElement.createFromExisting(this, curr, project);
                this.fChildren.add(elem);
                ++i;
            }
        }
    }

    public CPUserLibraryElement(String name, CPListElement[] children) {
        this.fName = name;
        this.fChildren = new ArrayList();
        if (children != null) {
            int i = 0;
            while (i < children.length) {
                this.fChildren.add(children[i]);
                ++i;
            }
        }
    }

    public CPListElement[] getChildren() {
        return this.fChildren.toArray(new CPListElement[this.fChildren.size()]);
    }

    public String getName() {
        return this.fName;
    }

    public IPath getPath() {
        return new Path("org.eclipse.wst.jsdt.USER_LIBRARY").append(this.fName);
    }

    public void add(CPListElement element) {
        if (!this.fChildren.contains(element)) {
            this.fChildren.add(element);
        }
    }

    public void remove(CPListElement element) {
        this.fChildren.remove(element);
    }

    public void replace(CPListElement existingElement, CPListElement element) {
        if (this.fChildren.contains(element)) {
            this.fChildren.remove(existingElement);
        } else {
            int index = this.fChildren.indexOf(existingElement);
            if (index != -1) {
                this.fChildren.set(index, element);
            } else {
                this.fChildren.add(element);
            }
            element.setAttributesFromExisting(existingElement);
        }
    }

    public IJsGlobalScopeContainer getUpdatedContainer() {
        return new UpdatedJsGlobalScopeContainer();
    }

    public boolean hasChanges(IJsGlobalScopeContainer oldContainer) {
        if (oldContainer == null) {
            return true;
        }
        IIncludePathEntry[] oldEntries = oldContainer.getIncludepathEntries();
        if (this.fChildren.size() != oldEntries.length) {
            return true;
        }
        int i = 0;
        while (i < oldEntries.length) {
            CPListElement child = (CPListElement)this.fChildren.get(i);
            if (!child.getClasspathEntry().equals(oldEntries[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private class UpdatedJsGlobalScopeContainer
    implements IJsGlobalScopeContainer {
        private UpdatedJsGlobalScopeContainer() {
        }

        public IIncludePathEntry[] getClasspathEntries() {
            return this.getIncludepathEntries();
        }

        @Override
        public IIncludePathEntry[] getIncludepathEntries() {
            CPListElement[] children = CPUserLibraryElement.this.getChildren();
            IIncludePathEntry[] entries = new IIncludePathEntry[children.length];
            int i = 0;
            while (i < entries.length) {
                entries[i] = children[i].getClasspathEntry();
                ++i;
            }
            return entries;
        }

        @Override
        public String getDescription() {
            return CPUserLibraryElement.this.getName();
        }

        @Override
        public int getKind() {
            return 1;
        }

        @Override
        public IPath getPath() {
            return CPUserLibraryElement.this.getPath();
        }

        @Override
        public String[] resolvedLibraryImport(String a) {
            return null;
        }
    }
}

