/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.jsdt.core.IAccessRule;
import org.eclipse.wst.jsdt.core.IIncludePathAttribute;
import org.eclipse.wst.jsdt.core.IIncludePathEntry;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJsGlobalScopeContainer;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.JsGlobalScopeContainerInitializer;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.ArchiveFileFilter;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.BuildPathSupport;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.CPListElementAttribute;

public class CPListElement {
    public static final String EXCLUSION = "exclusion";
    public static final String INCLUSION = "inclusion";
    public static final String ACCESSRULES = "accessrules";
    public static final String COMBINE_ACCESSRULES = "combineaccessrules";
    public static final String JAVADOC = "javadoc_location";
    private IJavaScriptProject fProject;
    private int fEntryKind;
    private IPath fPath;
    private IPath fOrginalPath;
    private IResource fResource;
    private boolean fIsExported;
    private boolean fIsMissing;
    private Object fParentContainer;
    private IIncludePathEntry fCachedEntry;
    private ArrayList fChildren;
    private IPath fLinkTarget;
    private IPath fOrginalLinkTarget;

    private CPListElement() {
    }

    public CPListElement(IJavaScriptProject project, int entryKind, IPath path, IResource res) {
        this(null, project, entryKind, path, res);
    }

    public CPListElement(Object parent, IJavaScriptProject project, int entryKind, IPath path, IResource res) {
        this(parent, project, entryKind, path, res, null);
    }

    public CPListElement(IJavaScriptProject project, int entryKind) {
        this(null, project, entryKind, null, null);
    }

    public CPListElement(Object parent, IJavaScriptProject project, int entryKind, IPath path, IResource res, IPath linkTarget) {
        this.fProject = project;
        this.fEntryKind = entryKind;
        this.fPath = path;
        this.fOrginalPath = path;
        this.fLinkTarget = linkTarget;
        this.fOrginalLinkTarget = linkTarget;
        this.fChildren = new ArrayList();
        this.fResource = res;
        this.fIsExported = false;
        this.fIsMissing = false;
        this.fCachedEntry = null;
        this.fParentContainer = parent;
        JsGlobalScopeContainerInitializer init = this.getContainerInitializer();
        boolean allowJsDoc = true;
        if (init != null) {
            allowJsDoc = init.allowAttachJsDoc();
        }
        switch (entryKind) {
            case 3: {
                this.createAttributeElement(INCLUSION, new Path[0], true);
                this.createAttributeElement(EXCLUSION, new Path[0], true);
                break;
            }
            case 1: 
            case 4: {
                if (allowJsDoc) {
                    this.createAttributeElement(JAVADOC, null, false);
                }
                this.createAttributeElement(ACCESSRULES, new IAccessRule[0], true);
                break;
            }
            case 2: {
                this.createAttributeElement(ACCESSRULES, new IAccessRule[0], true);
                this.createAttributeElement(COMBINE_ACCESSRULES, Boolean.FALSE, true);
                break;
            }
            case 5: {
                this.createAttributeElement(ACCESSRULES, new IAccessRule[0], true);
                try {
                    IJsGlobalScopeContainer container = JavaScriptCore.getJsGlobalScopeContainer(this.fPath, this.fProject);
                    if (container == null) break;
                    IIncludePathEntry[] entries = container.getIncludepathEntries();
                    if (entries != null) {
                        int i = 0;
                        while (i < entries.length) {
                            IIncludePathEntry entry = entries[i];
                            if (entry != null) {
                                String displayText;
                                if (init == null || (displayText = init.getDescription(entry.getPath(), project)) != null) {
                                    CPListElement curr = CPListElement.createFromExisting(this, entry, this.fProject);
                                    this.fChildren.add(curr);
                                }
                            } else {
                                JavaScriptPlugin.logErrorMessage("Null entry in container '" + this.fPath + "'");
                            }
                            ++i;
                        }
                        break;
                    }
                    JavaScriptPlugin.logErrorMessage("container returns null as entries: '" + this.fPath + "'");
                    break;
                }
                catch (JavaScriptModelException javaScriptModelException) {}
            }
        }
    }

    public IIncludePathEntry getClasspathEntry() {
        if (this.fCachedEntry == null) {
            this.fCachedEntry = this.newClasspathEntry();
        }
        return this.fCachedEntry;
    }

    private IIncludePathAttribute[] getClasspathAttributes() {
        ArrayList<IIncludePathAttribute> res = new ArrayList<IIncludePathAttribute>();
        int i = 0;
        while (i < this.fChildren.size()) {
            CPListElementAttribute elem;
            Object curr = this.fChildren.get(i);
            if (curr instanceof CPListElementAttribute && !(elem = (CPListElementAttribute)curr).isBuiltIn() && elem.getValue() != null) {
                res.add(elem.getClasspathAttribute());
            }
            ++i;
        }
        return res.toArray(new IIncludePathAttribute[res.size()]);
    }

    private IIncludePathEntry newClasspathEntry() {
        IIncludePathAttribute[] extraAttributes = this.getClasspathAttributes();
        switch (this.fEntryKind) {
            case 3: {
                IPath[] inclusionPattern = (IPath[])this.getAttribute(INCLUSION);
                IPath[] exclusionPattern = (IPath[])this.getAttribute(EXCLUSION);
                return JavaScriptCore.newSourceEntry(this.fPath, inclusionPattern, exclusionPattern, null, extraAttributes);
            }
            case 1: {
                IAccessRule[] accesRules = (IAccessRule[])this.getAttribute(ACCESSRULES);
                return JavaScriptCore.newLibraryEntry(this.fPath, null, null, accesRules, extraAttributes, this.isExported());
            }
            case 2: {
                IAccessRule[] accesRules = (IAccessRule[])this.getAttribute(ACCESSRULES);
                boolean combineAccessRules = (Boolean)this.getAttribute(COMBINE_ACCESSRULES);
                return JavaScriptCore.newProjectEntry(this.fPath, accesRules, combineAccessRules, extraAttributes, this.isExported());
            }
            case 5: {
                IAccessRule[] accesRules = (IAccessRule[])this.getAttribute(ACCESSRULES);
                return JavaScriptCore.newContainerEntry(this.fPath, accesRules, extraAttributes, this.isExported());
            }
            case 4: {
                IAccessRule[] accesRules = (IAccessRule[])this.getAttribute(ACCESSRULES);
                return JavaScriptCore.newVariableEntry(this.fPath, null, null, accesRules, extraAttributes, this.isExported());
            }
        }
        return null;
    }

    public IPath getPath() {
        return this.fPath;
    }

    public int getEntryKind() {
        return this.fEntryKind;
    }

    public IResource getResource() {
        return this.fResource;
    }

    public CPListElementAttribute setAttribute(String key, Object value) {
        CPListElementAttribute attribute = this.findAttributeElement(key);
        if (attribute == null) {
            return null;
        }
        if (key.equals(EXCLUSION) || key.equals(INCLUSION)) {
            Assert.isTrue((value != null || this.fEntryKind != 3 ? 1 : 0) != 0);
        }
        if (key.equals(ACCESSRULES)) {
            Assert.isTrue((value != null || this.fEntryKind == 3 ? 1 : 0) != 0);
        }
        if (key.equals(COMBINE_ACCESSRULES)) {
            Assert.isTrue((boolean)(value instanceof Boolean));
        }
        attribute.setValue(value);
        return attribute;
    }

    public boolean addToExclusions(IPath path) {
        String key = EXCLUSION;
        return this.addFilter(path, key);
    }

    public boolean addToInclusion(IPath path) {
        String key = INCLUSION;
        return this.addFilter(path, key);
    }

    public boolean removeFromExclusions(IPath path) {
        String key = EXCLUSION;
        return this.removeFilter(path, key);
    }

    public boolean removeFromInclusion(IPath path) {
        String key = INCLUSION;
        return this.removeFilter(path, key);
    }

    private boolean addFilter(IPath path, String key) {
        IPath[] filters = (IPath[])this.getAttribute(key);
        if (filters == null) {
            return false;
        }
        if (!JavaModelUtil.isExcludedPath(path, filters)) {
            IPath toAdd = path.removeFirstSegments(this.getPath().segmentCount()).addTrailingSeparator();
            IPath[] newFilters = new IPath[filters.length + 1];
            System.arraycopy(filters, 0, newFilters, 0, filters.length);
            newFilters[filters.length] = toAdd;
            this.setAttribute(key, newFilters);
            return true;
        }
        return false;
    }

    private boolean removeFilter(IPath path, String key) {
        IPath[] filters = (IPath[])this.getAttribute(key);
        if (filters == null) {
            return false;
        }
        IPath toRemove = path.removeFirstSegments(this.getPath().segmentCount()).addTrailingSeparator();
        if (JavaModelUtil.isExcludedPath(toRemove, filters)) {
            ArrayList<IPath> l = new ArrayList<IPath>(Arrays.asList(filters));
            l.remove(toRemove);
            IPath[] newFilters = l.toArray(new IPath[l.size()]);
            this.setAttribute(key, newFilters);
            return true;
        }
        return false;
    }

    public CPListElementAttribute findAttributeElement(String key) {
        int i = 0;
        while (i < this.fChildren.size()) {
            CPListElementAttribute elem;
            Object curr = this.fChildren.get(i);
            if (curr instanceof CPListElementAttribute && key.equals((elem = (CPListElementAttribute)curr).getKey())) {
                return elem;
            }
            ++i;
        }
        return null;
    }

    public Object getAttribute(String key) {
        CPListElementAttribute attrib = this.findAttributeElement(key);
        if (attrib != null) {
            return attrib.getValue();
        }
        return null;
    }

    public CPListElementAttribute[] getAllAttributes() {
        ArrayList res = new ArrayList();
        int i = 0;
        while (i < this.fChildren.size()) {
            Object curr = this.fChildren.get(i);
            if (curr instanceof CPListElementAttribute) {
                res.add(curr);
            }
            ++i;
        }
        return res.toArray(new CPListElementAttribute[res.size()]);
    }

    private void createAttributeElement(String key, Object value, boolean builtIn) {
        this.fChildren.add(new CPListElementAttribute(this, key, value, builtIn));
    }

    private static boolean isFiltered(Object entry, String[] filteredKeys) {
        if (entry instanceof CPListElementAttribute) {
            CPListElementAttribute curr = (CPListElementAttribute)entry;
            String key = curr.getKey();
            int i = 0;
            while (i < filteredKeys.length) {
                if (key.equals(filteredKeys[i])) {
                    return true;
                }
                ++i;
            }
            if (curr.isNotSupported()) {
                return true;
            }
            if (!curr.isBuiltIn() && !key.equals(JAVADOC)) {
                return !JavaScriptPlugin.getDefault().getClasspathAttributeConfigurationDescriptors().containsKey(key);
            }
        }
        return false;
    }

    private Object[] getFilteredChildren(String[] filteredKeys) {
        int nChildren = this.fChildren.size();
        ArrayList res = new ArrayList(nChildren);
        int i = 0;
        while (i < nChildren) {
            Object curr = this.fChildren.get(i);
            if (!CPListElement.isFiltered(curr, filteredKeys)) {
                res.add(curr);
            }
            ++i;
        }
        return res.toArray();
    }

    public Object[] getChildren() {
        if (this.fEntryKind == 2) {
            return this.getFilteredChildren(new String[]{COMBINE_ACCESSRULES});
        }
        return this.getFilteredChildren(new String[0]);
    }

    public Object getParentContainer() {
        return this.fParentContainer;
    }

    protected void attributeChanged(String key) {
        this.fCachedEntry = null;
    }

    public JsGlobalScopeContainerInitializer getContainerInitializer() {
        if (this.fEntryKind == 5 && this.fProject != null) {
            JsGlobalScopeContainerInitializer initializer = JavaScriptCore.getJsGlobalScopeContainerInitializer(this.fPath.segment(0));
            return initializer;
        }
        if (this.fParentContainer != null && this.fParentContainer instanceof CPListElement) {
            return ((CPListElement)this.fParentContainer).getContainerInitializer();
        }
        return null;
    }

    private IStatus evaluateContainerChildStatus(CPListElementAttribute attrib) {
        if (this.fProject != null) {
            JsGlobalScopeContainerInitializer initializer = JavaScriptCore.getJsGlobalScopeContainerInitializer(this.fPath.segment(0));
            if (initializer != null && initializer.canUpdateJsGlobalScopeContainer(this.fPath, this.fProject)) {
                if (attrib.isBuiltIn()) {
                    if (ACCESSRULES.equals(attrib.getKey())) {
                        return initializer.getAccessRulesStatus(this.fPath, this.fProject);
                    }
                } else {
                    return initializer.getAttributeStatus(this.fPath, this.fProject, attrib.getKey());
                }
            }
            return new Status(4, "org.eclipse.wst.jsdt.ui", 2, "", null);
        }
        return null;
    }

    private boolean canUpdateContainer() {
        if (this.fEntryKind == 5 && this.fProject != null) {
            JsGlobalScopeContainerInitializer initializer = this.getContainerInitializer();
            return initializer != null && initializer.canUpdateJsGlobalScopeContainer(this.fPath, this.fProject);
        }
        return false;
    }

    public boolean isInNonModifiableContainer() {
        if (this.fParentContainer != null && this.fParentContainer instanceof CPListElement) {
            return !((CPListElement)this.fParentContainer).canUpdateContainer();
        }
        return this.fParentContainer == null && !this.canUpdateContainer();
    }

    public IStatus getContainerChildStatus(CPListElementAttribute attrib) {
        if (this.fParentContainer instanceof CPListElement) {
            CPListElement parent = (CPListElement)this.fParentContainer;
            if (parent.getEntryKind() == 5) {
                return parent.evaluateContainerChildStatus(attrib);
            }
            return ((CPListElement)this.fParentContainer).getContainerChildStatus(attrib);
        }
        return null;
    }

    public boolean isJRE() {
        IPath containerPath = this.getPath();
        Path JREPath = new Path("org.eclipse.wst.jsdt.launching.JRE_CONTAINER");
        return containerPath != null && containerPath.equals((Object)JREPath);
    }

    public boolean isInContainer(String containerName) {
        if (this.fParentContainer instanceof CPListElement) {
            CPListElement elem = (CPListElement)this.fParentContainer;
            return new Path(containerName).isPrefixOf(elem.getPath());
        }
        return false;
    }

    public boolean isDeprecated() {
        if (this.fEntryKind != 4) {
            return false;
        }
        if (this.fPath.segmentCount() > 0) {
            return JavaScriptCore.getIncludepathVariableDeprecationMessage(this.fPath.segment(0)) != null;
        }
        return false;
    }

    public String getDeprecationMessage() {
        if (this.fEntryKind != 4) {
            return null;
        }
        if (this.fPath.segmentCount() > 0) {
            String varName = this.fPath.segment(0);
            return BuildPathSupport.getDeprecationMessage(varName);
        }
        return null;
    }

    public boolean equals(Object other) {
        if (other != null && other.getClass().equals(this.getClass())) {
            CPListElement elem = (CPListElement)other;
            return this.getClasspathEntry().equals(elem.getClasspathEntry());
        }
        return false;
    }

    public int hashCode() {
        return this.fPath.hashCode() + this.fEntryKind;
    }

    public String toString() {
        return this.getClasspathEntry().toString();
    }

    public boolean isMissing() {
        return this.fIsMissing;
    }

    public void setIsMissing(boolean isMissing) {
        this.fIsMissing = isMissing;
    }

    public boolean isExported() {
        return this.fIsExported;
    }

    public void setExported(boolean isExported) {
        if (isExported != this.fIsExported) {
            this.fIsExported = isExported;
            this.attributeChanged(null);
        }
    }

    public IJavaScriptProject getJavaProject() {
        return this.fProject;
    }

    public static CPListElement createFromExisting(IIncludePathEntry curr, IJavaScriptProject project) {
        return CPListElement.createFromExisting(null, curr, project);
    }

    public static CPListElement createFromExisting(Object parent, IIncludePathEntry curr, IJavaScriptProject project) {
        IPath path = curr.getPath();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource res = null;
        boolean isMissing = false;
        IPath linkTarget = null;
        switch (curr.getEntryKind()) {
            case 5: {
                try {
                    isMissing = project != null && JavaScriptCore.getJsGlobalScopeContainer(path, project) == null;
                }
                catch (JavaScriptModelException javaScriptModelException) {
                    isMissing = true;
                }
                break;
            }
            case 4: {
                IPath resolvedPath = JavaScriptCore.getResolvedVariablePath(path);
                isMissing = root.findMember(resolvedPath) == null && !resolvedPath.toFile().isFile();
                break;
            }
            case 1: {
                res = root.findMember(path);
                if (res == null) {
                    if (!ArchiveFileFilter.isArchivePath(path) && root.getWorkspace().validatePath(path.toString(), 2).isOK() && root.getProject(path.segment(0)).exists()) {
                        res = root.getFolder(path);
                    }
                    isMissing = !path.toFile().isFile();
                    break;
                }
                if (!res.isLinked()) break;
                linkTarget = res.getLocation();
                break;
            }
            case 3: {
                path = path.removeTrailingSeparator();
                res = root.findMember(path);
                if (res == null) {
                    if (root.getWorkspace().validatePath(path.toString(), 2).isOK()) {
                        res = root.getFolder(path);
                    }
                    isMissing = true;
                    break;
                }
                if (!res.isLinked()) break;
                linkTarget = res.getLocation();
                break;
            }
            case 2: {
                res = root.findMember(path);
                isMissing = res == null;
            }
        }
        CPListElement elem = new CPListElement(parent, project, curr.getEntryKind(), path, res, linkTarget);
        elem.setExported(curr.isExported());
        elem.setAttribute(EXCLUSION, curr.getExclusionPatterns());
        elem.setAttribute(INCLUSION, curr.getInclusionPatterns());
        elem.setAttribute(ACCESSRULES, curr.getAccessRules());
        elem.setAttribute(COMBINE_ACCESSRULES, new Boolean(curr.combineAccessRules()));
        IIncludePathAttribute[] extraAttributes = curr.getExtraAttributes();
        int i = 0;
        while (i < extraAttributes.length) {
            IIncludePathAttribute attrib = extraAttributes[i];
            CPListElementAttribute attribElem = elem.findAttributeElement(attrib.getName());
            if (attribElem == null) {
                elem.createAttributeElement(attrib.getName(), attrib.getValue(), false);
            } else {
                attribElem.setValue(attrib.getValue());
            }
            ++i;
        }
        if (project != null && project.exists()) {
            elem.setIsMissing(isMissing);
        }
        return elem;
    }

    public static StringBuffer appendEncodePath(IPath path, StringBuffer buf) {
        if (path != null) {
            String str = path.toString();
            buf.append('[').append(str.length()).append(']').append(str);
        } else {
            buf.append('[').append(']');
        }
        return buf;
    }

    public static StringBuffer appendEncodedString(String str, StringBuffer buf) {
        if (str != null) {
            buf.append('[').append(str.length()).append(']').append(str);
        } else {
            buf.append('[').append(']');
        }
        return buf;
    }

    public static StringBuffer appendEncodedFilter(IPath[] filters, StringBuffer buf) {
        if (filters != null) {
            buf.append('[').append(filters.length).append(']');
            int i = 0;
            while (i < filters.length) {
                CPListElement.appendEncodePath(filters[i], buf).append(';');
                ++i;
            }
        } else {
            buf.append('[').append(']');
        }
        return buf;
    }

    public static StringBuffer appendEncodedAccessRules(IAccessRule[] rules, StringBuffer buf) {
        if (rules != null) {
            buf.append('[').append(rules.length).append(']');
            int i = 0;
            while (i < rules.length) {
                CPListElement.appendEncodePath(rules[i].getPattern(), buf).append(';');
                buf.append(rules[i].getKind()).append(';');
                ++i;
            }
        } else {
            buf.append('[').append(']');
        }
        return buf;
    }

    public StringBuffer appendEncodedSettings(StringBuffer buf) {
        buf.append(this.fEntryKind).append(';');
        if (this.getLinkTarget() == null) {
            CPListElement.appendEncodePath(this.fPath, buf).append(';');
        } else {
            CPListElement.appendEncodePath(this.fPath, buf).append('-').append('>');
            CPListElement.appendEncodePath(this.getLinkTarget(), buf).append(';');
        }
        buf.append((Object)this.fIsExported).append(';');
        int i = 0;
        while (i < this.fChildren.size()) {
            Object curr = this.fChildren.get(i);
            if (curr instanceof CPListElementAttribute) {
                CPListElementAttribute elem = (CPListElementAttribute)curr;
                if (elem.isBuiltIn()) {
                    String key = elem.getKey();
                    if (EXCLUSION.equals(key) || INCLUSION.equals(key)) {
                        CPListElement.appendEncodedFilter((IPath[])elem.getValue(), buf).append(';');
                    } else if (ACCESSRULES.equals(key)) {
                        CPListElement.appendEncodedAccessRules((IAccessRule[])elem.getValue(), buf).append(';');
                    } else if (COMBINE_ACCESSRULES.equals(key)) {
                        buf.append((Boolean)elem.getValue()).append(';');
                    }
                } else {
                    CPListElement.appendEncodedString((String)elem.getValue(), buf);
                }
            }
            ++i;
        }
        return buf;
    }

    public IPath getLinkTarget() {
        return this.fLinkTarget;
    }

    public void setPath(IPath path) {
        this.fCachedEntry = null;
        this.fPath = path;
    }

    public void setLinkTarget(IPath linkTarget) {
        this.fCachedEntry = null;
        this.fLinkTarget = linkTarget;
    }

    public static void insert(CPListElement element, List cpList) {
        int length = cpList.size();
        CPListElement[] elements = cpList.toArray(new CPListElement[length]);
        int i = 0;
        while (i < length && elements[i].getEntryKind() != element.getEntryKind()) {
            ++i;
        }
        if (i < length) {
            ++i;
            while (i < length && elements[i].getEntryKind() == element.getEntryKind()) {
                ++i;
            }
            cpList.add(i, element);
            return;
        }
        switch (element.getEntryKind()) {
            case 3: {
                cpList.add(0, element);
                break;
            }
            default: {
                cpList.add(element);
            }
        }
    }

    public static IIncludePathEntry[] convertToClasspathEntries(List cpList) {
        IIncludePathEntry[] result = new IIncludePathEntry[cpList.size()];
        int i = 0;
        for (CPListElement cur : cpList) {
            result[i] = cur.getClasspathEntry();
            ++i;
        }
        return result;
    }

    public static CPListElement[] createFromExisting(IJavaScriptProject project) throws JavaScriptModelException {
        IIncludePathEntry[] rawClasspath = project.getRawIncludepath();
        CPListElement[] result = new CPListElement[rawClasspath.length];
        int i = 0;
        while (i < rawClasspath.length) {
            result[i] = CPListElement.createFromExisting(rawClasspath[i], project);
            ++i;
        }
        return result;
    }

    public static boolean isProjectSourceFolder(CPListElement[] existing, IJavaScriptProject project) {
        IPath projPath = project.getProject().getFullPath();
        int i = 0;
        while (i < existing.length) {
            IIncludePathEntry curr = existing[i].getClasspathEntry();
            if (curr.getEntryKind() == 3 && projPath.equals((Object)curr.getPath())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public IPath getOrginalPath() {
        return this.fOrginalPath;
    }

    public IPath getOrginalLinkTarget() {
        return this.fOrginalLinkTarget;
    }

    public CPListElement copy() {
        CPListElement result = new CPListElement();
        result.fProject = this.fProject;
        result.fEntryKind = this.fEntryKind;
        result.fPath = this.fPath;
        result.fOrginalPath = this.fOrginalPath;
        result.fResource = this.fResource;
        result.fIsExported = this.fIsExported;
        result.fIsMissing = this.fIsMissing;
        result.fParentContainer = this.fParentContainer;
        result.fCachedEntry = null;
        result.fChildren = new ArrayList(this.fChildren.size());
        for (Object child : this.fChildren) {
            if (child instanceof CPListElement) {
                result.fChildren.add(((CPListElement)child).copy());
                continue;
            }
            result.fChildren.add(((CPListElementAttribute)child).copy());
        }
        result.fLinkTarget = this.fLinkTarget;
        result.fOrginalLinkTarget = this.fOrginalLinkTarget;
        return result;
    }

    public void setAttributesFromExisting(CPListElement existing) {
        Assert.isTrue((existing.getEntryKind() == this.getEntryKind() ? 1 : 0) != 0);
        CPListElementAttribute[] attributes = existing.getAllAttributes();
        int i = 0;
        while (i < attributes.length) {
            CPListElementAttribute curr = attributes[i];
            CPListElementAttribute elem = this.findAttributeElement(curr.getKey());
            if (elem == null) {
                this.createAttributeElement(curr.getKey(), curr.getValue(), false);
            } else {
                elem.setValue(curr.getValue());
            }
            ++i;
        }
    }
}

