/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.refactoring.contentassist;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.contentassist.IContentAssistSubjectControl;
import org.eclipse.jface.contentassist.ISubjectControlContentAssistProcessor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.internal.ui.JavaPluginImages;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.text.java.JavaCompletionProposal;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.ImageDescriptorRegistry;
import org.eclipse.wst.jsdt.ui.text.java.CompletionProposalComparator;

public class JavaPackageFragmentRootCompletionProcessor
implements IContentAssistProcessor,
ISubjectControlContentAssistProcessor {
    private static final ImageDescriptorRegistry IMAGE_DESC_REGISTRY = JavaScriptPlugin.getImageDescriptorRegistry();
    private IPackageFragmentRoot fPackageFragmentRoot;
    private CompletionProposalComparator fComparator;
    private char[] fProposalAutoActivationSet;

    public JavaPackageFragmentRootCompletionProcessor(IPackageFragmentRoot packageFragmentRoot) {
        this.fPackageFragmentRoot = packageFragmentRoot;
        this.fComparator = new CompletionProposalComparator();
        IPreferenceStore preferenceStore = JavaScriptPlugin.getDefault().getPreferenceStore();
        String triggers = preferenceStore.getString("content_assist_autoactivation_triggers_java");
        this.fProposalAutoActivationSet = triggers.toCharArray();
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int documentOffset) {
        Assert.isTrue((boolean)false, (String)"ITextViewer not supported");
        return null;
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int documentOffset) {
        Assert.isTrue((boolean)false, (String)"ITextViewer not supported");
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return this.fProposalAutoActivationSet;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public String getErrorMessage() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    public IContextInformation[] computeContextInformation(IContentAssistSubjectControl contentAssistSubject, int documentOffset) {
        return null;
    }

    public ICompletionProposal[] computeCompletionProposals(IContentAssistSubjectControl contentAssistSubjectControl, int documentOffset) {
        String input = contentAssistSubjectControl.getDocument().get();
        ICompletionProposal[] proposals = this.createPackagesProposals(documentOffset, input);
        Arrays.sort(proposals, this.fComparator);
        return proposals;
    }

    private ICompletionProposal[] createPackagesProposals(int documentOffset, String input) {
        ArrayList<JavaCompletionProposal> proposals = new ArrayList<JavaCompletionProposal>();
        String prefix = input.substring(0, documentOffset);
        try {
            IJavaScriptElement[] packageFragments = this.fPackageFragmentRoot.getChildren();
            int i = 0;
            while (i < packageFragments.length) {
                IPackageFragment pack = (IPackageFragment)packageFragments[i];
                String packName = pack.getElementName();
                if (packName.length() != 0 && packName.startsWith(prefix)) {
                    Image image = JavaPackageFragmentRootCompletionProcessor.getImage(JavaPluginImages.DESC_OBJS_PACKAGE);
                    JavaCompletionProposal proposal = new JavaCompletionProposal(packName, 0, input.length(), image, packName, 0);
                    proposals.add(proposal);
                }
                ++i;
            }
        }
        catch (JavaScriptModelException e) {
            JavaScriptPlugin.log((Throwable)((Object)e));
        }
        return proposals.toArray(new ICompletionProposal[proposals.size()]);
    }

    private static Image getImage(ImageDescriptor descriptor) {
        return descriptor == null ? null : IMAGE_DESC_REGISTRY.get(descriptor);
    }
}

