/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.javaeditor;

import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.editors.text.TextFileDocumentProvider;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.ILocalVariable;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.ISourceRange;
import org.eclipse.wst.jsdt.core.ISourceReference;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.internal.compiler.util.Util;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.IClassFileEditorInput;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.InternalClassFileEditorInput;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JarEntryEditorInput;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditorMessages;
import org.eclipse.wst.jsdt.ui.JavaScriptUI;

public class EditorUtility {
    public static IEditorPart isOpenInEditor(Object inputElement) {
        IWorkbenchPage p;
        IEditorInput input = null;
        try {
            input = EditorUtility.getEditorInput(inputElement);
        }
        catch (JavaScriptModelException x) {
            JavaScriptPlugin.log(x.getStatus());
        }
        if (input != null && (p = JavaScriptPlugin.getActivePage()) != null) {
            return p.findEditor(input);
        }
        return null;
    }

    public static IEditorPart openInEditor(Object inputElement) throws JavaScriptModelException, PartInitException {
        return EditorUtility.openInEditor(inputElement, true);
    }

    public static IEditorPart openInEditor(Object inputElement, boolean activate) throws JavaScriptModelException, PartInitException {
        IJavaScriptElement editorCU;
        IEditorPart editor;
        IWorkbenchPage page;
        IJavaScriptUnit cu;
        URI hostElementPath;
        if (inputElement instanceof IFile) {
            return EditorUtility.openInEditor((IFile)inputElement, activate);
        }
        if (inputElement instanceof IJavaScriptElement && ((IJavaScriptElement)inputElement).isVirtual() && (hostElementPath = ((IJavaScriptElement)inputElement).getHostPath()) != null) {
            IFile realFile = ((IJavaScriptElement)inputElement).getJavaScriptProject().getProject().getWorkspace().getRoot().getFileForLocation((IPath)new Path(hostElementPath.getPath()));
            if (realFile == null || !realFile.exists()) {
                realFile = ((IJavaScriptElement)inputElement).getJavaScriptProject().getProject().getWorkspace().getRoot().findMember(hostElementPath.getPath());
            }
            if (realFile != null) {
                return EditorUtility.openInEditor(realFile, activate);
            }
            return EditorUtility.openInEditor(hostElementPath, activate);
        }
        if (inputElement instanceof IJavaScriptElement && (cu = (IJavaScriptUnit)((IJavaScriptElement)inputElement).getAncestor(5)) != null && !JavaModelUtil.isPrimary(cu) && (page = JavaScriptPlugin.getActivePage()) != null && (editor = page.getActiveEditor()) != null && cu.equals(editorCU = EditorUtility.getEditorInputJavaElement(editor, false))) {
            if (activate && page.getActivePart() != editor) {
                page.activate((IWorkbenchPart)editor);
            }
            return editor;
        }
        IEditorInput input = EditorUtility.getEditorInput(inputElement);
        if (input == null) {
            EditorUtility.throwPartInitException(JavaEditorMessages.EditorUtility_no_editorInput);
        }
        return EditorUtility.openInEditor(input, EditorUtility.getEditorID(input), activate);
    }

    public static void revealInEditor(IEditorPart part, IJavaScriptElement element) {
        if (element == null) {
            return;
        }
        if (part instanceof JavaEditor) {
            ((JavaEditor)part).setSelection(element);
            return;
        }
        try {
            ISourceRange range = null;
            if (element instanceof IJavaScriptUnit) {
                range = null;
            } else if (element instanceof IClassFile) {
                range = null;
            } else if (element instanceof ILocalVariable) {
                range = ((ILocalVariable)element).getNameRange();
            } else if (element instanceof IMember) {
                range = ((IMember)element).getNameRange();
            } else if (element instanceof ISourceReference) {
                range = ((ISourceReference)((Object)element)).getSourceRange();
            }
            if (range != null) {
                EditorUtility.revealInEditor(part, range.getOffset(), range.getLength());
            }
        }
        catch (JavaScriptModelException javaScriptModelException) {}
    }

    public static void revealInEditor(IEditorPart part, IRegion region) {
        if (part != null && region != null) {
            EditorUtility.revealInEditor(part, region.getOffset(), region.getLength());
        }
    }

    public static void revealInEditor(IEditorPart editor, final int offset, final int length) {
        if (editor instanceof ITextEditor) {
            ((ITextEditor)editor).selectAndReveal(offset, length);
            return;
        }
        if (editor instanceof IGotoMarker) {
            final IEditorInput input = editor.getEditorInput();
            if (input instanceof IFileEditorInput) {
                final IGotoMarker gotoMarkerTarget = (IGotoMarker)editor;
                WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

                    protected void execute(IProgressMonitor monitor) throws CoreException {
                        IMarker marker = null;
                        try {
                            marker = ((IFileEditorInput)input).getFile().createMarker("org.eclipse.core.resources.textmarker");
                            marker.setAttribute("charStart", offset);
                            marker.setAttribute("charEnd", offset + length);
                            gotoMarkerTarget.gotoMarker(marker);
                        }
                        finally {
                            if (marker != null) {
                                marker.delete();
                            }
                        }
                    }
                };
                try {
                    op.run(null);
                }
                catch (InvocationTargetException invocationTargetException) {
                }
                catch (InterruptedException interruptedException) {
                    Assert.isTrue((boolean)false, (String)"this operation can not be canceled");
                }
            }
            return;
        }
        if (editor != null && editor.getEditorSite().getSelectionProvider() != null) {
            IEditorSite site = editor.getEditorSite();
            if (site == null) {
                return;
            }
            ISelectionProvider provider = editor.getEditorSite().getSelectionProvider();
            if (provider == null) {
                return;
            }
            provider.setSelection((ISelection)new TextSelection(offset, length));
        }
    }

    private static IEditorPart openInEditor(IFile file, boolean activate) throws PartInitException {
        IWorkbenchPage p;
        if (file == null) {
            EditorUtility.throwPartInitException(JavaEditorMessages.EditorUtility_file_must_not_be_null);
        }
        if ((p = JavaScriptPlugin.getActivePage()) == null) {
            EditorUtility.throwPartInitException(JavaEditorMessages.EditorUtility_no_active_WorkbenchPage);
        }
        IEditorPart editorPart = IDE.openEditor((IWorkbenchPage)p, (IFile)file, (boolean)activate);
        EditorUtility.initializeHighlightRange(editorPart);
        return editorPart;
    }

    private static IEditorPart openInEditor(URI file, boolean activate) throws PartInitException {
        IEditorDescriptor desc;
        IWorkbenchPage p;
        if (file == null) {
            EditorUtility.throwPartInitException(JavaEditorMessages.EditorUtility_file_must_not_be_null);
        }
        if ((p = JavaScriptPlugin.getActivePage()) == null) {
            EditorUtility.throwPartInitException(JavaEditorMessages.EditorUtility_no_active_WorkbenchPage);
        }
        if ((desc = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(file.getPath())) == null) {
            EditorUtility.throwPartInitException(String.valueOf(JavaEditorMessages.EditorUtility_cantFindEditor) + file.toString());
        }
        IEditorPart editorPart = IDE.openEditor((IWorkbenchPage)p, (URI)file, (String)desc.getId(), (boolean)activate);
        EditorUtility.initializeHighlightRange(editorPart);
        return editorPart;
    }

    private static IEditorPart openInEditor(IEditorInput input, String editorID, boolean activate) throws PartInitException {
        Assert.isNotNull((Object)input);
        Assert.isNotNull((Object)editorID);
        IWorkbenchPage p = JavaScriptPlugin.getActivePage();
        if (p == null) {
            EditorUtility.throwPartInitException(JavaEditorMessages.EditorUtility_no_active_WorkbenchPage);
        }
        IEditorPart editorPart = p.openEditor(input, editorID, activate);
        EditorUtility.initializeHighlightRange(editorPart);
        return editorPart;
    }

    private static void throwPartInitException(String message) throws PartInitException {
        Status status = new Status(4, "org.eclipse.wst.jsdt.ui", 0, message, null);
        throw new PartInitException((IStatus)status);
    }

    private static void initializeHighlightRange(IEditorPart editorPart) {
        if (editorPart instanceof ITextEditor) {
            boolean enable;
            IAction toggleAction = editorPart.getEditorSite().getActionBars().getGlobalActionHandler("org.eclipse.ui.edit.text.toggleShowSelectedElementOnly");
            boolean bl = enable = toggleAction != null;
            if (enable && editorPart instanceof JavaEditor) {
                enable = JavaScriptPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.wst.jsdt.ui.editor.showSegments");
            } else {
                boolean bl2 = enable = enable && toggleAction.isEnabled() && toggleAction.isChecked();
            }
            if (enable) {
                if (toggleAction instanceof TextEditorAction) {
                    ((TextEditorAction)toggleAction).setEditor(null);
                    ((TextEditorAction)toggleAction).setEditor((ITextEditor)editorPart);
                } else {
                    toggleAction.run();
                    toggleAction.run();
                }
            }
        }
    }

    private static String getEditorID(IEditorInput input) throws PartInitException {
        IEditorDescriptor editorDescriptor;
        Assert.isNotNull((Object)input);
        if (input instanceof IFileEditorInput) {
            editorDescriptor = IDE.getEditorDescriptor((IFile)((IFileEditorInput)input).getFile());
        } else {
            if (input instanceof InternalClassFileEditorInput) {
                return "org.eclipse.wst.jsdt.ui.ClassFileEditor";
            }
            String name = input.getName();
            if (name == null) {
                EditorUtility.throwPartInitException(JavaEditorMessages.EditorUtility_could_not_find_editorId);
            }
            editorDescriptor = IDE.getEditorDescriptor((String)name);
        }
        return editorDescriptor.getId();
    }

    public static IJavaScriptElement getEditorInputJavaElement(IEditorPart editor, boolean primaryOnly) {
        Assert.isNotNull((Object)editor);
        IEditorInput editorInput = editor.getEditorInput();
        if (editorInput == null) {
            return null;
        }
        IJavaScriptElement je = JavaScriptUI.getEditorInputJavaElement(editorInput);
        if (je != null || primaryOnly) {
            return je;
        }
        return JavaScriptPlugin.getDefault().getWorkingCopyManager().getWorkingCopy(editorInput, false);
    }

    private static IEditorInput getEditorInput(IJavaScriptElement element) throws JavaScriptModelException {
        while (element != null) {
            IJavaScriptUnit unit;
            IResource resource;
            if (element instanceof IJavaScriptUnit && (resource = (unit = ((IJavaScriptUnit)element).getPrimary()).getResource()) instanceof IFile) {
                return new FileEditorInput((IFile)resource);
            }
            if (element instanceof IClassFile) {
                String elementName = element.getElementName();
                if ((org.eclipse.wst.jsdt.internal.core.util.Util.isMetadataFileName(elementName) || org.eclipse.wst.jsdt.internal.core.util.Util.isJavaLikeFileName(elementName)) && (resource = element.getResource()) instanceof IFile && !Util.isArchiveFileName(resource.getName())) {
                    return new FileEditorInput((IFile)resource);
                }
                return new InternalClassFileEditorInput((IClassFile)element);
            }
            element = element.getParent();
        }
        return null;
    }

    public static IEditorInput getEditorInput(Object input) throws JavaScriptModelException {
        if (input instanceof IJavaScriptElement) {
            return EditorUtility.getEditorInput((IJavaScriptElement)input);
        }
        if (input instanceof IFile) {
            return new FileEditorInput((IFile)input);
        }
        if (JavaModelUtil.isOpenableStorage(input)) {
            return new JarEntryEditorInput((IStorage)input);
        }
        return null;
    }

    public static IJavaScriptElement getActiveEditorJavaInput() {
        IEditorInput editorInput;
        IEditorPart part;
        IWorkbenchPage page = JavaScriptPlugin.getActivePage();
        if (page != null && (part = page.getActiveEditor()) != null && (editorInput = part.getEditorInput()) != null) {
            return JavaScriptUI.getEditorInputJavaElement(editorInput);
        }
        return null;
    }

    public static int findLocalizedModifier(String modifierName) {
        if (modifierName == null) {
            return 0;
        }
        if (modifierName.equalsIgnoreCase(Action.findModifierString((int)262144))) {
            return 262144;
        }
        if (modifierName.equalsIgnoreCase(Action.findModifierString((int)131072))) {
            return 131072;
        }
        if (modifierName.equalsIgnoreCase(Action.findModifierString((int)65536))) {
            return 65536;
        }
        if (modifierName.equalsIgnoreCase(Action.findModifierString((int)0x400000))) {
            return 0x400000;
        }
        return 0;
    }

    public static String getModifierString(int stateMask) {
        String modifierString = "";
        if ((stateMask & 0x40000) == 262144) {
            modifierString = EditorUtility.appendModifierString(modifierString, 262144);
        }
        if ((stateMask & 0x10000) == 65536) {
            modifierString = EditorUtility.appendModifierString(modifierString, 65536);
        }
        if ((stateMask & 0x20000) == 131072) {
            modifierString = EditorUtility.appendModifierString(modifierString, 131072);
        }
        if ((stateMask & 0x400000) == 0x400000) {
            modifierString = EditorUtility.appendModifierString(modifierString, 0x400000);
        }
        return modifierString;
    }

    private static String appendModifierString(String modifierString, int modifier) {
        if (modifierString == null) {
            modifierString = "";
        }
        String newModifierString = Action.findModifierString((int)modifier);
        if (modifierString.length() == 0) {
            return newModifierString;
        }
        return Messages.format(JavaEditorMessages.EditorUtility_concatModifierStrings, new String[]{modifierString, newModifierString});
    }

    public static IJavaScriptProject getJavaProject(IEditorInput input) {
        IJavaScriptProject jProject = null;
        if (input instanceof IFileEditorInput) {
            IProject project = ((IFileEditorInput)input).getFile().getProject();
            if (project != null && !(jProject = JavaScriptCore.create(project)).exists()) {
                jProject = null;
            }
        } else if (input instanceof IClassFileEditorInput) {
            jProject = ((IClassFileEditorInput)input).getClassFile().getJavaScriptProject();
        }
        return jProject;
    }

    public static IEditorPart[] getDirtyEditors() {
        HashSet<IEditorInput> inputs = new HashSet<IEditorInput>();
        ArrayList<IEditorPart> result = new ArrayList<IEditorPart>(0);
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow[] windows = workbench.getWorkbenchWindows();
        int i = 0;
        while (i < windows.length) {
            IWorkbenchPage[] pages = windows[i].getPages();
            int x = 0;
            while (x < pages.length) {
                IEditorPart[] editors = pages[x].getDirtyEditors();
                int z = 0;
                while (z < editors.length) {
                    IEditorPart ep = editors[z];
                    IEditorInput input = ep.getEditorInput();
                    if (inputs.add(input)) {
                        result.add(ep);
                    }
                    ++z;
                }
                ++x;
            }
            ++i;
        }
        return result.toArray(new IEditorPart[result.size()]);
    }

    public static IEditorPart[] getDirtyEditorsToSave(boolean saveUnknownEditors) {
        HashSet<IEditorInput> inputs = new HashSet<IEditorInput>();
        ArrayList<IEditorPart> result = new ArrayList<IEditorPart>(0);
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow[] windows = workbench.getWorkbenchWindows();
        int i = 0;
        while (i < windows.length) {
            IWorkbenchPage[] pages = windows[i].getPages();
            int x = 0;
            while (x < pages.length) {
                IEditorPart[] editors = pages[x].getDirtyEditors();
                int z = 0;
                while (z < editors.length) {
                    IEditorPart ep = editors[z];
                    IEditorInput input = ep.getEditorInput();
                    if (EditorUtility.mustSaveDirtyEditor(ep, input, saveUnknownEditors) && inputs.add(input)) {
                        result.add(ep);
                    }
                    ++z;
                }
                ++x;
            }
            ++i;
        }
        return result.toArray(new IEditorPart[result.size()]);
    }

    private static boolean mustSaveDirtyEditor(IEditorPart ep, IEditorInput input, boolean saveUnknownEditors) {
        IJavaScriptUnit cu;
        IResource resource = (IResource)input.getAdapter(IResource.class);
        if (resource == null) {
            return saveUnknownEditors;
        }
        IJavaScriptElement javaElement = JavaScriptCore.create(resource);
        if (javaElement instanceof IJavaScriptUnit && !(cu = (IJavaScriptUnit)javaElement).isWorkingCopy()) {
            return true;
        }
        if (!(ep instanceof ITextEditor)) {
            return saveUnknownEditors;
        }
        ITextEditor textEditor = (ITextEditor)ep;
        IDocumentProvider documentProvider = textEditor.getDocumentProvider();
        if (!(documentProvider instanceof TextFileDocumentProvider)) {
            return saveUnknownEditors;
        }
        return false;
    }
}

