/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.javaeditor;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ISynchronizable;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.editors.text.FileDocumentProvider;
import org.eclipse.ui.editors.text.StorageDocumentProvider;
import org.eclipse.ui.texteditor.AbstractDocumentProvider;
import org.eclipse.wst.jsdt.core.ElementChangedEvent;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.IElementChangedListener;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptElementDelta;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.internal.ui.IResourceLocator;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.ClassFileMarkerAnnotationModel;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.ExternalClassFileEditorInput;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.IClassFileEditorInput;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.InternalClassFileEditorInput;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditorMessages;
import org.eclipse.wst.jsdt.ui.text.JavaScriptTextTools;

public class ClassFileDocumentProvider
extends FileDocumentProvider {
    private List fInputListeners = new ArrayList();

    protected boolean setDocumentContent(IDocument document, IEditorInput editorInput, String encoding) throws CoreException {
        if (editorInput instanceof IClassFileEditorInput) {
            IClassFile classFile = ((IClassFileEditorInput)editorInput).getClassFile();
            String source = classFile.getSource();
            if (source == null) {
                source = "";
            }
            classFile.makeConsistent(this.getProgressMonitor());
            document.set(source);
            return true;
        }
        return super.setDocumentContent(document, editorInput, encoding);
    }

    protected IAnnotationModel createClassFileAnnotationModel(IClassFileEditorInput classFileEditorInput) throws CoreException {
        IResource resource = null;
        IClassFile classFile = classFileEditorInput.getClassFile();
        IResourceLocator locator = (IResourceLocator)classFile.getAdapter(IResourceLocator.class);
        if (locator != null) {
            resource = locator.getContainingResource(classFile);
        }
        if (resource != null) {
            ClassFileMarkerAnnotationModel model = new ClassFileMarkerAnnotationModel(resource);
            model.setClassFile(classFile);
            return model;
        }
        return null;
    }

    protected IDocument createEmptyDocument() {
        IDocument document = FileBuffers.getTextFileBufferManager().createEmptyDocument(null, LocationKind.IFILE);
        if (document instanceof ISynchronizable) {
            ((ISynchronizable)document).setLockObject(new Object());
        }
        return document;
    }

    protected IDocument createDocument(Object element) throws CoreException {
        IDocument document = super.createDocument(element);
        if (document != null) {
            JavaScriptTextTools tools = JavaScriptPlugin.getDefault().getJavaTextTools();
            tools.setupJavaDocumentPartitioner(document, "___java_partitioning");
        }
        return document;
    }

    public String getEncoding(Object element) {
        InternalClassFileEditorInput input;
        IClassFile file;
        if (element instanceof IStorageEditorInput) {
            StorageDocumentProvider.StorageInfo info = (StorageDocumentProvider.StorageInfo)this.getElementInfo(element);
            if (info != null) {
                return info.fEncoding;
            }
            return this.getPersistedEncoding(element);
        }
        if (element instanceof InternalClassFileEditorInput && (file = (input = (InternalClassFileEditorInput)element).getClassFile()) != null) {
            String fileEncoding = null;
            try {
                IResource resource = file.getResource();
                fileEncoding = resource == null || !(resource instanceof IFile) ? null : ((IFile)resource).getCharset();
            }
            catch (CoreException coreException) {}
            return fileEncoding;
        }
        return null;
    }

    protected AbstractDocumentProvider.ElementInfo createElementInfo(Object element) throws CoreException {
        if (element instanceof IClassFileEditorInput) {
            IClassFileEditorInput input = (IClassFileEditorInput)element;
            ExternalClassFileEditorInput external = null;
            if (input instanceof ExternalClassFileEditorInput) {
                external = (ExternalClassFileEditorInput)input;
            }
            if (external != null) {
                try {
                    this.refreshFile(external.getFile());
                }
                catch (CoreException x) {
                    this.handleCoreException(x, JavaEditorMessages.ClassFileDocumentProvider_error_createElementInfo);
                }
            }
            IDocument d = this.createDocument(input);
            IAnnotationModel m = this.createClassFileAnnotationModel(input);
            if (external != null) {
                ClassFileInfo info = new ClassFileInfo(d, m, null);
                info.fModificationStamp = this.computeModificationStamp((IResource)external.getFile());
                info.fEncoding = this.getPersistedEncoding(element);
                return info;
            }
            if (input instanceof InternalClassFileEditorInput) {
                ClassFileSynchronizer s = new ClassFileSynchronizer(input);
                s.install();
                ClassFileInfo info = new ClassFileInfo(d, m, s);
                info.fEncoding = this.getPersistedEncoding(element);
                return info;
            }
        }
        return null;
    }

    protected void disposeElementInfo(Object element, AbstractDocumentProvider.ElementInfo info) {
        ClassFileInfo classFileInfo = (ClassFileInfo)info;
        if (classFileInfo.fClassFileSynchronizer != null) {
            classFileInfo.fClassFileSynchronizer.uninstall();
            classFileInfo.fClassFileSynchronizer = null;
        }
        super.disposeElementInfo(element, info);
    }

    protected void doSaveDocument(IProgressMonitor monitor, Object element, IDocument document) throws CoreException {
    }

    public boolean isSynchronized(Object element) {
        AbstractDocumentProvider.ElementInfo elementInfo = this.getElementInfo(element);
        if (elementInfo instanceof ClassFileInfo) {
            IResource resource;
            IClassFileEditorInput input = (IClassFileEditorInput)element;
            try {
                resource = input.getClassFile().getUnderlyingResource();
            }
            catch (JavaScriptModelException javaScriptModelException) {
                return true;
            }
            return resource == null || resource.isSynchronized(0);
        }
        return false;
    }

    protected void handleDeleted(IClassFileEditorInput input) {
        this.fireElementDeleted(input);
    }

    protected void fireInputChanged(IClassFileEditorInput input) {
        ArrayList list = new ArrayList(this.fInputListeners);
        Iterator i = list.iterator();
        while (i.hasNext()) {
            ((InputChangeListener)i.next()).inputChanged(input);
        }
    }

    public void addInputChangeListener(InputChangeListener listener) {
        this.fInputListeners.add(listener);
    }

    public void removeInputChangeListener(InputChangeListener listener) {
        this.fInputListeners.remove(listener);
    }

    protected class ClassFileInfo
    extends FileDocumentProvider.FileInfo {
        ClassFileSynchronizer fClassFileSynchronizer;

        ClassFileInfo(IDocument document, IAnnotationModel model, _FileSynchronizer fileSynchronizer) {
            super((FileDocumentProvider)ClassFileDocumentProvider.this, document, model, (FileDocumentProvider.FileSynchronizer)fileSynchronizer);
            this.fClassFileSynchronizer = null;
        }

        ClassFileInfo(IDocument document, IAnnotationModel model, ClassFileSynchronizer classFileSynchronizer) {
            super((FileDocumentProvider)ClassFileDocumentProvider.this, document, model, null);
            this.fClassFileSynchronizer = null;
            this.fClassFileSynchronizer = classFileSynchronizer;
        }
    }

    protected class ClassFileSynchronizer
    implements IElementChangedListener {
        protected IClassFileEditorInput fInput;
        protected IPackageFragmentRoot fPackageFragmentRoot;

        public ClassFileSynchronizer(IClassFileEditorInput input) {
            this.fInput = input;
            IJavaScriptElement parent = this.fInput.getClassFile().getParent();
            while (parent != null && !(parent instanceof IPackageFragmentRoot)) {
                parent = parent.getParent();
            }
            this.fPackageFragmentRoot = (IPackageFragmentRoot)parent;
        }

        public void install() {
            JavaScriptCore.addElementChangedListener(this);
        }

        public void uninstall() {
            JavaScriptCore.removeElementChangedListener(this);
        }

        @Override
        public void elementChanged(ElementChangedEvent e) {
            this.check(this.fPackageFragmentRoot, e.getDelta());
        }

        protected boolean check(IPackageFragmentRoot input, IJavaScriptElementDelta delta) {
            IJavaScriptElement element = delta.getElement();
            if (((delta.getKind() & 2) != 0 || (delta.getFlags() & 0x400) != 0) && (element.equals(input.getJavaScriptProject()) || element.equals(input))) {
                ClassFileDocumentProvider.this.handleDeleted(this.fInput);
                return true;
            }
            if ((delta.getFlags() & 0x8000) != 0 && input.equals(element)) {
                ClassFileDocumentProvider.this.handleDeleted(this.fInput);
                return true;
            }
            if ((delta.getFlags() & 0x80) != 0 && input.equals(element)) {
                ClassFileDocumentProvider.this.handleDeleted(this.fInput);
                return true;
            }
            IJavaScriptElementDelta[] subdeltas = delta.getAffectedChildren();
            int i = 0;
            while (i < subdeltas.length) {
                if (this.check(input, subdeltas[i])) {
                    return true;
                }
                ++i;
            }
            if ((delta.getFlags() & 0x2000) != 0 || (delta.getFlags() & 0x1000) != 0) {
                IClassFile file = this.fInput != null ? this.fInput.getClassFile() : null;
                IJavaScriptProject project = input != null ? input.getJavaScriptProject() : null;
                boolean isOnClasspath = false;
                if (file != null && project != null) {
                    isOnClasspath = project.isOnIncludepath(file);
                }
                if (isOnClasspath) {
                    ClassFileDocumentProvider.this.fireInputChanged(this.fInput);
                    return false;
                }
                ClassFileDocumentProvider.this.handleDeleted(this.fInput);
                return true;
            }
            return false;
        }
    }

    public static interface InputChangeListener {
        public void inputChanged(IClassFileEditorInput var1);
    }

    protected class _FileSynchronizer
    extends FileDocumentProvider.FileSynchronizer {
        public _FileSynchronizer(IFileEditorInput fileEditorInput) {
            super((FileDocumentProvider)ClassFileDocumentProvider.this, fileEditorInput);
        }
    }
}

