/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.callhierarchy;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.core.IFunction;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.callhierarchy.CallHierarchyMessages;
import org.eclipse.wst.jsdt.internal.ui.callhierarchy.CallHierarchyViewPart;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.JavaElementImageProvider;
import org.eclipse.wst.jsdt.ui.JavaScriptElementLabelProvider;

class HistoryAction
extends Action {
    private static JavaScriptElementLabelProvider fLabelProvider = new JavaScriptElementLabelProvider(2051);
    private CallHierarchyViewPart fView;
    private IFunction fMethod;

    public HistoryAction(CallHierarchyViewPart viewPart, IFunction element) {
        super("", 8);
        this.fView = viewPart;
        this.fMethod = element;
        String elementName = this.getElementLabel(element);
        this.setText(elementName);
        this.setImageDescriptor(this.getImageDescriptor(element));
        this.setDescription(Messages.format(CallHierarchyMessages.HistoryAction_description, elementName));
        this.setToolTipText(Messages.format(CallHierarchyMessages.HistoryAction_tooltip, elementName));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.wst.jsdt.ui.call_hierarchy_history_action_context");
    }

    private ImageDescriptor getImageDescriptor(IJavaScriptElement elem) {
        JavaElementImageProvider imageProvider = new JavaElementImageProvider();
        ImageDescriptor desc = imageProvider.getBaseImageDescriptor(elem, 0);
        imageProvider.dispose();
        return desc;
    }

    public void run() {
        this.fView.gotoHistoryEntry(this.fMethod);
    }

    private String getElementLabel(IJavaScriptElement element) {
        Assert.isNotNull((Object)element);
        return fLabelProvider.getText(element);
    }
}

