/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.structure;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.GroupCategory;
import org.eclipse.ltk.core.refactoring.GroupCategorySet;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextEditBasedChange;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.TextEditGroup;
import org.eclipse.wst.jsdt.core.IField;
import org.eclipse.wst.jsdt.core.IFunction;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.ITypeHierarchy;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTRequestor;
import org.eclipse.wst.jsdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.Block;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.FieldDeclaration;
import org.eclipse.wst.jsdt.core.dom.FunctionDeclaration;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.Type;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationFragment;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.core.dom.rewrite.ITrackedNodePosition;
import org.eclipse.wst.jsdt.core.search.SearchEngine;
import org.eclipse.wst.jsdt.core.search.SearchMatch;
import org.eclipse.wst.jsdt.core.search.SearchPattern;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodes;
import org.eclipse.wst.jsdt.internal.corext.dom.ModifierRewrite;
import org.eclipse.wst.jsdt.internal.corext.refactoring.Checks;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JDTRefactoringDescriptor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JDTRefactoringDescriptorComment;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JavaRefactoringArguments;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringAvailabilityTester;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringSearchEngine2;
import org.eclipse.wst.jsdt.internal.corext.refactoring.SearchResultGroup;
import org.eclipse.wst.jsdt.internal.corext.refactoring.base.JavaStatusContext;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.DynamicValidationRefactoringChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.ScriptableRefactoring;
import org.eclipse.wst.jsdt.internal.corext.refactoring.rename.MethodChecks;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.ASTNodeSearchUtil;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.HierarchyProcessor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.IMemberActionInfo;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.ImportRewriteUtil;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.MemberCheckUtil;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.MemberVisibilityAdjustor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.ReferenceFinderUtil;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.TypeVariableMaplet;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.TextEditBasedChangeManager;
import org.eclipse.wst.jsdt.internal.corext.util.JdtFlags;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.corext.util.SearchUtils;
import org.eclipse.wst.jsdt.internal.corext.util.Strings;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.ui.JavaScriptElementLabels;

public final class PushDownRefactoringProcessor
extends HierarchyProcessor {
    private static final String ATTRIBUTE_ABSTRACT = "abstract";
    private static final String ATTRIBUTE_PUSH = "push";
    public static final String IDENTIFIER = "org.eclipse.wst.jsdt.ui.pushDownProcessor";
    private static final GroupCategorySet SET_PUSH_DOWN = new GroupCategorySet(new GroupCategory("org.eclipse.wst.jsdt.internal.corext.pushDown", RefactoringCoreMessages.PushDownRefactoring_category_name, RefactoringCoreMessages.PushDownRefactoring_category_description));
    private ITypeHierarchy fCachedClassHierarchy;
    private MemberActionInfo[] fMemberInfos;

    private static MemberActionInfo[] createInfosForAllPushableFieldsAndMethods(IType type) throws JavaScriptModelException {
        ArrayList<MemberActionInfo> result = new ArrayList<MemberActionInfo>();
        IMember[] pushableMembers = RefactoringAvailabilityTester.getPushDownMembers(type);
        int i = 0;
        while (i < pushableMembers.length) {
            result.add(MemberActionInfo.create(pushableMembers[i], 2));
            ++i;
        }
        return result.toArray(new MemberActionInfo[result.size()]);
    }

    private static IMember[] getAbstractMembers(IMember[] members) throws JavaScriptModelException {
        ArrayList<IMember> result = new ArrayList<IMember>(members.length);
        int i = 0;
        while (i < members.length) {
            IMember member = members[i];
            if (JdtFlags.isAbstract(member)) {
                result.add(member);
            }
            ++i;
        }
        return result.toArray(new IMember[result.size()]);
    }

    private static CompilationUnitRewrite getCompilationUnitRewrite(Map rewrites, IJavaScriptUnit unit) {
        Assert.isNotNull((Object)rewrites);
        Assert.isNotNull((Object)unit);
        CompilationUnitRewrite rewrite = (CompilationUnitRewrite)rewrites.get(unit);
        if (rewrite == null) {
            rewrite = new CompilationUnitRewrite(unit);
            rewrites.put(unit, rewrite);
        }
        return rewrite;
    }

    private static IJavaScriptElement[] getReferencingElementsFromSameClass(IMember member, IProgressMonitor pm, RefactoringStatus status) throws JavaScriptModelException {
        Assert.isNotNull((Object)member);
        RefactoringSearchEngine2 engine = new RefactoringSearchEngine2(SearchPattern.createPattern(member, 2, 24));
        engine.setFiltering(true, true);
        engine.setScope(SearchEngine.createJavaSearchScope(new IJavaScriptElement[]{member.getDeclaringType()}));
        engine.setStatus(status);
        engine.searchPattern((IProgressMonitor)new SubProgressMonitor(pm, 1));
        SearchResultGroup[] groups = (SearchResultGroup[])engine.getResults();
        HashSet<IJavaScriptElement> result = new HashSet<IJavaScriptElement>(3);
        int i = 0;
        while (i < groups.length) {
            SearchResultGroup group = groups[i];
            SearchMatch[] results = group.getSearchResults();
            int j = 0;
            while (j < results.length) {
                SearchMatch searchResult = results[i];
                result.add(SearchUtils.getEnclosingJavaElement(searchResult));
                ++j;
            }
            ++i;
        }
        return result.toArray(new IJavaScriptElement[result.size()]);
    }

    public PushDownRefactoringProcessor(IMember[] members) {
        super(members, null, false);
        if (members != null) {
            IType type = RefactoringAvailabilityTester.getTopLevelType(members);
            try {
                if (type != null && RefactoringAvailabilityTester.getPushDownMembers(type).length != 0) {
                    this.fMembersToMove = new IMember[0];
                    this.fCachedDeclaringType = type;
                }
            }
            catch (JavaScriptModelException exception) {
                JavaScriptPlugin.log((Throwable)((Object)exception));
            }
        }
    }

    private void addAllRequiredPushableMembers(List queue, IMember member, IProgressMonitor monitor) throws JavaScriptModelException {
        monitor.beginTask(RefactoringCoreMessages.PushDownRefactoring_calculating_required, 2);
        SubProgressMonitor sub = new SubProgressMonitor(monitor, 1);
        sub.beginTask(RefactoringCoreMessages.PushDownRefactoring_calculating_required, 2);
        IFunction[] requiredMethods = ReferenceFinderUtil.getMethodsReferencedIn(new IJavaScriptElement[]{member}, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)sub, 1));
        sub = new SubProgressMonitor((IProgressMonitor)sub, 1);
        sub.beginTask(RefactoringCoreMessages.PushDownRefactoring_calculating_required, requiredMethods.length);
        int index = 0;
        while (index < requiredMethods.length) {
            IFunction method = requiredMethods[index];
            if (!MethodChecks.isVirtual(method) && method.getDeclaringType().equals(this.getDeclaringType()) && !queue.contains(method) && RefactoringAvailabilityTester.isPushDownAvailable(method)) {
                queue.add(method);
            }
            ++index;
        }
        sub.done();
        IField[] requiredFields = ReferenceFinderUtil.getFieldsReferencedIn(new IJavaScriptElement[]{member}, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        int index2 = 0;
        while (index2 < requiredFields.length) {
            IField field = requiredFields[index2];
            if (field.getDeclaringType().equals(this.getDeclaringType()) && !queue.contains(field) && RefactoringAvailabilityTester.isPushDownAvailable(field)) {
                queue.add(field);
            }
            ++index2;
        }
        monitor.done();
    }

    private RefactoringStatus checkAbstractMembersInDestinationClasses(IMember[] membersToPushDown, IType[] destinationClassesForAbstract) throws JavaScriptModelException {
        RefactoringStatus result = new RefactoringStatus();
        IMember[] abstractMembersToPushDown = PushDownRefactoringProcessor.getAbstractMembers(membersToPushDown);
        int index = 0;
        while (index < destinationClassesForAbstract.length) {
            result.merge(MemberCheckUtil.checkMembersInDestinationType(abstractMembersToPushDown, destinationClassesForAbstract[index]));
            ++index;
        }
        return result;
    }

    private RefactoringStatus checkAccessedFields(IType[] subclasses, IProgressMonitor pm) throws JavaScriptModelException {
        RefactoringStatus result = new RefactoringStatus();
        IJavaScriptElement[] membersToPushDown = MemberActionInfo.getMembers(this.getInfosForMembersToBeCreatedInSubclassesOfDeclaringClass());
        List<IMember> pushedDownList = Arrays.asList(membersToPushDown);
        IField[] accessedFields = ReferenceFinderUtil.getFieldsReferencedIn(membersToPushDown, pm);
        int i = 0;
        while (i < subclasses.length) {
            IType targetClass = subclasses[i];
            ITypeHierarchy targetSupertypes = targetClass.newSupertypeHierarchy(null);
            int j = 0;
            while (j < accessedFields.length) {
                boolean isAccessible;
                IField field = accessedFields[j];
                boolean bl = isAccessible = pushedDownList.contains(field) || this.canBeAccessedFrom(field, targetClass, targetSupertypes);
                if (!isAccessible) {
                    String message = Messages.format(RefactoringCoreMessages.PushDownRefactoring_field_not_accessible, new String[]{JavaScriptElementLabels.getTextLabel(field, 2235681801344L), JavaScriptElementLabels.getTextLabel(targetClass, 2235681801344L)});
                    result.addError(message, JavaStatusContext.create(field));
                }
                ++j;
            }
            ++i;
        }
        pm.done();
        return result;
    }

    private RefactoringStatus checkAccessedMethods(IType[] subclasses, IProgressMonitor pm) throws JavaScriptModelException {
        RefactoringStatus result = new RefactoringStatus();
        IJavaScriptElement[] membersToPushDown = MemberActionInfo.getMembers(this.getInfosForMembersToBeCreatedInSubclassesOfDeclaringClass());
        List<IMember> pushedDownList = Arrays.asList(membersToPushDown);
        IFunction[] accessedMethods = ReferenceFinderUtil.getMethodsReferencedIn(membersToPushDown, pm);
        int index = 0;
        while (index < subclasses.length) {
            IType targetClass = subclasses[index];
            ITypeHierarchy targetSupertypes = targetClass.newSupertypeHierarchy(null);
            int offset = 0;
            while (offset < accessedMethods.length) {
                boolean isAccessible;
                IFunction method = accessedMethods[offset];
                boolean bl = isAccessible = pushedDownList.contains(method) || this.canBeAccessedFrom(method, targetClass, targetSupertypes);
                if (!isAccessible) {
                    String message = Messages.format(RefactoringCoreMessages.PushDownRefactoring_method_not_accessible, new String[]{JavaScriptElementLabels.getTextLabel(method, 2235681801344L), JavaScriptElementLabels.getTextLabel(targetClass, 2235681801344L)});
                    result.addError(message, JavaStatusContext.create(method));
                }
                ++offset;
            }
            ++index;
        }
        pm.done();
        return result;
    }

    private RefactoringStatus checkAccessedTypes(IType[] subclasses, IProgressMonitor pm) throws JavaScriptModelException {
        RefactoringStatus result = new RefactoringStatus();
        IType[] accessedTypes = this.getTypesReferencedInMovedMembers(pm);
        int index = 0;
        while (index < subclasses.length) {
            IType targetClass = subclasses[index];
            ITypeHierarchy targetSupertypes = targetClass.newSupertypeHierarchy(null);
            int offset = 0;
            while (offset < accessedTypes.length) {
                IType type = accessedTypes[offset];
                if (!this.canBeAccessedFrom(type, targetClass, targetSupertypes)) {
                    String message = Messages.format(RefactoringCoreMessages.PushDownRefactoring_type_not_accessible, new String[]{JavaScriptElementLabels.getTextLabel(type, 2235681801344L), JavaScriptElementLabels.getTextLabel(targetClass, 2235681801344L)});
                    result.addError(message, JavaStatusContext.create(type));
                }
                ++offset;
            }
            ++index;
        }
        pm.done();
        return result;
    }

    private RefactoringStatus checkElementsAccessedByModifiedMembers(IProgressMonitor pm) throws JavaScriptModelException {
        RefactoringStatus result = new RefactoringStatus();
        pm.beginTask(RefactoringCoreMessages.PushDownRefactoring_check_references, 3);
        IType[] subclasses = this.getAbstractDestinations((IProgressMonitor)new SubProgressMonitor(pm, 1));
        result.merge(this.checkAccessedTypes(subclasses, (IProgressMonitor)new SubProgressMonitor(pm, 1)));
        result.merge(this.checkAccessedFields(subclasses, (IProgressMonitor)new SubProgressMonitor(pm, 1)));
        result.merge(this.checkAccessedMethods(subclasses, (IProgressMonitor)new SubProgressMonitor(pm, 1)));
        pm.done();
        return result;
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor monitor, CheckConditionsContext context) throws CoreException, OperationCanceledException {
        try {
            monitor.beginTask(RefactoringCoreMessages.PushDownRefactoring_checking, 5);
            this.clearCaches();
            IJavaScriptUnit unit = this.getDeclaringType().getJavaScriptUnit();
            if (this.fLayer) {
                unit = unit.findWorkingCopy(this.fOwner);
            }
            this.resetWorkingCopies(unit);
            RefactoringStatus result = new RefactoringStatus();
            result.merge(this.checkMembersInDestinationClasses((IProgressMonitor)new SubProgressMonitor(monitor, 1)));
            result.merge(this.checkElementsAccessedByModifiedMembers((IProgressMonitor)new SubProgressMonitor(monitor, 1)));
            result.merge(this.checkReferencesToPushedDownMembers((IProgressMonitor)new SubProgressMonitor(monitor, 1)));
            if (!JdtFlags.isAbstract(this.getDeclaringType()) && this.getAbstractDeclarationInfos().length != 0) {
                result.merge(this.checkConstructorCalls(this.getDeclaringType(), (IProgressMonitor)new SubProgressMonitor(monitor, 1)));
            } else {
                monitor.worked(1);
            }
            if (result.hasFatalError()) {
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            ArrayList<IMember> members = new ArrayList<IMember>(this.fMemberInfos.length);
            int index = 0;
            while (index < this.fMemberInfos.length) {
                if (this.fMemberInfos[index].getAction() != 2) {
                    members.add(this.fMemberInfos[index].getMember());
                }
                ++index;
            }
            this.fMembersToMove = members.toArray(new IMember[members.size()]);
            this.fChangeManager = this.createChangeManager((IProgressMonitor)new SubProgressMonitor(monitor, 1), result);
            if (result.hasFatalError()) {
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            result.merge(Checks.validateModifiesFiles(ResourceUtil.getFiles(this.fChangeManager.getAllCompilationUnits()), this.getRefactoring().getValidationContext()));
            RefactoringStatus refactoringStatus = result;
            return refactoringStatus;
        }
        finally {
            monitor.done();
        }
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        try {
            monitor.beginTask(RefactoringCoreMessages.PushDownRefactoring_checking, 1);
            RefactoringStatus status = new RefactoringStatus();
            status.merge(this.checkPossibleSubclasses((IProgressMonitor)new SubProgressMonitor(monitor, 1)));
            if (status.hasFatalError()) {
                RefactoringStatus refactoringStatus = status;
                return refactoringStatus;
            }
            status.merge(this.checkDeclaringType((IProgressMonitor)new SubProgressMonitor(monitor, 1)));
            if (status.hasFatalError()) {
                RefactoringStatus refactoringStatus = status;
                return refactoringStatus;
            }
            status.merge(this.checkIfMembersExist());
            if (status.hasFatalError()) {
                RefactoringStatus refactoringStatus = status;
                return refactoringStatus;
            }
            this.fMemberInfos = PushDownRefactoringProcessor.createInfosForAllPushableFieldsAndMethods(this.getDeclaringType());
            List<IMember> list = Arrays.asList(this.fMembersToMove);
            int offset = 0;
            while (offset < this.fMemberInfos.length) {
                MemberActionInfo info = this.fMemberInfos[offset];
                if (list.contains(info.getMember())) {
                    info.setAction(0);
                }
                ++offset;
            }
            RefactoringStatus refactoringStatus = status;
            return refactoringStatus;
        }
        finally {
            monitor.done();
        }
    }

    private RefactoringStatus checkMembersInDestinationClasses(IProgressMonitor monitor) throws JavaScriptModelException {
        monitor.beginTask(RefactoringCoreMessages.PushDownRefactoring_checking, 2);
        RefactoringStatus result = new RefactoringStatus();
        IMember[] membersToPushDown = MemberActionInfo.getMembers(this.getInfosForMembersToBeCreatedInSubclassesOfDeclaringClass());
        IType[] destinationClassesForNonAbstract = this.getAbstractDestinations((IProgressMonitor)new SubProgressMonitor(monitor, 1));
        result.merge(this.checkNonAbstractMembersInDestinationClasses(membersToPushDown, destinationClassesForNonAbstract));
        List<IMember> list = Arrays.asList(PushDownRefactoringProcessor.getAbstractMembers(this.getAbstractDestinations((IProgressMonitor)new SubProgressMonitor(monitor, 1))));
        IType[] destinationClassesForAbstract = list.toArray(new IType[list.size()]);
        result.merge(this.checkAbstractMembersInDestinationClasses(membersToPushDown, destinationClassesForAbstract));
        monitor.done();
        return result;
    }

    private RefactoringStatus checkNonAbstractMembersInDestinationClasses(IMember[] membersToPushDown, IType[] destinationClassesForNonAbstract) throws JavaScriptModelException {
        RefactoringStatus result = new RefactoringStatus();
        ArrayList<IMember> list = new ArrayList<IMember>();
        list.addAll(Arrays.asList(membersToPushDown));
        list.removeAll(Arrays.asList(PushDownRefactoringProcessor.getAbstractMembers(membersToPushDown)));
        IMember[] nonAbstractMembersToPushDown = list.toArray(new IMember[list.size()]);
        int i = 0;
        while (i < destinationClassesForNonAbstract.length) {
            result.merge(MemberCheckUtil.checkMembersInDestinationType(nonAbstractMembersToPushDown, destinationClassesForNonAbstract[i]));
            ++i;
        }
        return result;
    }

    private RefactoringStatus checkPossibleSubclasses(IProgressMonitor pm) throws JavaScriptModelException {
        IType[] modifiableSubclasses = this.getAbstractDestinations(pm);
        if (modifiableSubclasses.length == 0) {
            String msg = Messages.format(RefactoringCoreMessages.PushDownRefactoring_no_subclasses, new String[]{JavaScriptElementLabels.getTextLabel(this.getDeclaringType(), 2235681801344L)});
            return RefactoringStatus.createFatalErrorStatus((String)msg);
        }
        return new RefactoringStatus();
    }

    private RefactoringStatus checkReferencesToPushedDownMembers(IProgressMonitor monitor) throws JavaScriptModelException {
        ArrayList<IMember> fields = new ArrayList<IMember>(this.fMemberInfos.length);
        int index = 0;
        while (index < this.fMemberInfos.length) {
            MemberActionInfo info = this.fMemberInfos[index];
            if (info.isToBePushedDown()) {
                fields.add(info.getMember());
            }
            ++index;
        }
        IMember[] membersToPush = fields.toArray(new IMember[fields.size()]);
        RefactoringStatus result = new RefactoringStatus();
        List<IMember> movedMembers = Arrays.asList(MemberActionInfo.getMembers(this.getInfosForMembersToBeCreatedInSubclassesOfDeclaringClass()));
        monitor.beginTask(RefactoringCoreMessages.PushDownRefactoring_check_references, membersToPush.length);
        int index2 = 0;
        while (index2 < membersToPush.length) {
            IMember member = membersToPush[index2];
            String label = PushDownRefactoringProcessor.createLabel(member);
            IJavaScriptElement[] referencing = PushDownRefactoringProcessor.getReferencingElementsFromSameClass(member, (IProgressMonitor)new SubProgressMonitor(monitor, 1), result);
            int offset = 0;
            while (offset < referencing.length) {
                IJavaScriptElement element = referencing[offset];
                if (!movedMembers.contains(element) && element instanceof IMember) {
                    IMember referencingMember = (IMember)element;
                    Object[] keys = new Object[]{label, PushDownRefactoringProcessor.createLabel(referencingMember)};
                    String msg = Messages.format(RefactoringCoreMessages.PushDownRefactoring_referenced, keys);
                    result.addError(msg, JavaStatusContext.create(referencingMember));
                }
                ++offset;
            }
            ++index2;
        }
        monitor.done();
        return result;
    }

    public void computeAdditionalRequiredMembersToPushDown(IProgressMonitor monitor) throws JavaScriptModelException {
        List<IMember> list = Arrays.asList(this.getAdditionalRequiredMembers(monitor));
        int index = 0;
        while (index < this.fMemberInfos.length) {
            MemberActionInfo info = this.fMemberInfos[index];
            if (list.contains(info.getMember())) {
                info.setAction(0);
            }
            ++index;
        }
    }

    private void copyBodyOfPushedDownMethod(ASTRewrite targetRewrite, IFunction method, FunctionDeclaration oldMethod, FunctionDeclaration newMethod, TypeVariableMaplet[] mapping) throws JavaScriptModelException {
        Block body = oldMethod.getBody();
        if (body == null) {
            newMethod.setBody(null);
            return;
        }
        try {
            Document document = new Document(method.getJavaScriptUnit().getBuffer().getContents());
            ASTRewrite rewriter = ASTRewrite.create(body.getAST());
            ITrackedNodePosition position = rewriter.track(body);
            body.accept(new HierarchyProcessor.TypeVariableMapper(rewriter, mapping));
            rewriter.rewriteAST((IDocument)document, this.getDeclaringType().getJavaScriptUnit().getJavaScriptProject().getOptions(true)).apply((IDocument)document, 0);
            String content = document.get(position.getStartPosition(), position.getLength());
            String[] lines = Strings.convertIntoLines(content);
            Strings.trimIndentation(lines, method.getJavaScriptProject(), false);
            content = Strings.concatenate(lines, StubUtility.getLineDelimiterUsed(method));
            newMethod.setBody((Block)targetRewrite.createStringPlaceholder(content, 8));
        }
        catch (MalformedTreeException exception) {
            JavaScriptPlugin.log(exception);
        }
        catch (BadLocationException exception) {
            JavaScriptPlugin.log(exception);
        }
    }

    private void copyMembers(Collection adjustors, Map adjustments, Map rewrites, RefactoringStatus status, MemberActionInfo[] infos, IType[] destinations, CompilationUnitRewrite sourceRewriter, CompilationUnitRewrite unitRewriter, IProgressMonitor monitor) throws JavaScriptModelException {
        try {
            monitor.beginTask(RefactoringCoreMessages.PushDownRefactoring_checking, 1);
            IType type = null;
            TypeVariableMaplet[] mapping = null;
            int index = 0;
            while (index < destinations.length) {
                type = destinations[index];
                if (unitRewriter.getCu().equals(type.getJavaScriptUnit())) {
                    IMember member = null;
                    MemberVisibilityAdjustor adjustor = null;
                    AbstractTypeDeclaration declaration = ASTNodeSearchUtil.getAbstractTypeDeclarationNode(type, unitRewriter.getRoot());
                    int offset = infos.length - 1;
                    while (offset >= 0) {
                        member = infos[offset].getMember();
                        adjustor = new MemberVisibilityAdjustor(type, member);
                        if (infos[offset].isNewMethodToBeDeclaredAbstract()) {
                            adjustor.setIncoming(false);
                        }
                        adjustor.setRewrite(sourceRewriter.getASTRewrite(), sourceRewriter.getRoot());
                        adjustor.setRewrites(rewrites);
                        adjustor.setFailureSeverity(2);
                        adjustor.setStatus(status);
                        adjustor.setAdjustments(adjustments);
                        adjustor.adjustVisibility((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        adjustments.remove(member);
                        adjustors.add(adjustor);
                        status.merge(PushDownRefactoringProcessor.checkProjectCompliance(PushDownRefactoringProcessor.getCompilationUnitRewrite(rewrites, this.getDeclaringType().getJavaScriptUnit()), type, new IMember[]{infos[offset].getMember()}));
                        if (infos[offset].isFieldInfo()) {
                            VariableDeclarationFragment oldField = ASTNodeSearchUtil.getFieldDeclarationFragmentNode((IField)infos[offset].getMember(), sourceRewriter.getRoot());
                            if (oldField != null) {
                                FieldDeclaration newField = this.createNewFieldDeclarationNode(infos[offset], sourceRewriter.getRoot(), mapping, unitRewriter.getASTRewrite(), oldField);
                                unitRewriter.getASTRewrite().getListRewrite(declaration, declaration.getBodyDeclarationsProperty()).insertAt(newField, ASTNodes.getInsertionIndex(newField, declaration.bodyDeclarations()), (TextEditGroup)unitRewriter.createCategorizedGroupDescription(RefactoringCoreMessages.HierarchyRefactoring_add_member, SET_PUSH_DOWN));
                                ImportRewriteUtil.addImports(unitRewriter, oldField.getParent(), new HashMap(), new HashMap(), false);
                            }
                        } else {
                            FunctionDeclaration oldMethod = ASTNodeSearchUtil.getMethodDeclarationNode((IFunction)infos[offset].getMember(), sourceRewriter.getRoot());
                            if (oldMethod != null) {
                                FunctionDeclaration newMethod = this.createNewMethodDeclarationNode(infos[offset], sourceRewriter.getRoot(), mapping, unitRewriter, oldMethod);
                                unitRewriter.getASTRewrite().getListRewrite(declaration, declaration.getBodyDeclarationsProperty()).insertAt(newMethod, ASTNodes.getInsertionIndex(newMethod, declaration.bodyDeclarations()), (TextEditGroup)unitRewriter.createCategorizedGroupDescription(RefactoringCoreMessages.HierarchyRefactoring_add_member, SET_PUSH_DOWN));
                                ImportRewriteUtil.addImports(unitRewriter, oldMethod, new HashMap(), new HashMap(), false);
                            }
                        }
                        --offset;
                    }
                }
                ++index;
            }
        }
        finally {
            monitor.done();
        }
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        try {
            HashMap<String, String> arguments = new HashMap<String, String>();
            String project = null;
            IType declaring = this.getDeclaringType();
            IJavaScriptProject javaProject = declaring.getJavaScriptProject();
            if (javaProject != null) {
                project = javaProject.getElementName();
            }
            int flags = 589830;
            try {
                if (declaring.isLocal() || declaring.isAnonymous()) {
                    flags |= 0x40000;
                }
            }
            catch (JavaScriptModelException exception) {
                JavaScriptPlugin.log((Throwable)((Object)exception));
            }
            String description = this.fMembersToMove.length == 1 ? Messages.format(RefactoringCoreMessages.PushDownRefactoring_descriptor_description_short_multi, this.fMembersToMove[0].getElementName()) : RefactoringCoreMessages.PushDownRefactoring_descriptor_description_short;
            String header = this.fMembersToMove.length == 1 ? Messages.format(RefactoringCoreMessages.PushDownRefactoring_descriptor_description_full, new String[]{JavaScriptElementLabels.getElementLabel(this.fMembersToMove[0], 2235681801344L), JavaScriptElementLabels.getElementLabel(declaring, 2235681801344L)}) : Messages.format(RefactoringCoreMessages.PushDownRefactoring_descriptor_description, new String[]{JavaScriptElementLabels.getElementLabel(declaring, 2235681801344L)});
            JDTRefactoringDescriptorComment comment = new JDTRefactoringDescriptorComment(project, this, header);
            String[] settings = new String[this.fMembersToMove.length];
            int index = 0;
            while (index < settings.length) {
                settings[index] = JavaScriptElementLabels.getElementLabel(this.fMembersToMove[index], 2235681801344L);
                ++index;
            }
            comment.addSetting(JDTRefactoringDescriptorComment.createCompositeSetting(RefactoringCoreMessages.PushDownRefactoring_pushed_members_pattern, settings));
            this.addSuperTypeSettings(comment, true);
            JDTRefactoringDescriptor descriptor = new JDTRefactoringDescriptor("org.eclipse.wst.jsdt.ui.push.down", project, description, comment.asString(), arguments, flags);
            if (this.fCachedDeclaringType != null) {
                arguments.put("input", descriptor.elementToHandle(this.fCachedDeclaringType));
            }
            int index2 = 0;
            while (index2 < this.fMembersToMove.length) {
                arguments.put("element" + (index2 + 1), descriptor.elementToHandle(this.fMembersToMove[index2]));
                int offset = 0;
                while (offset < this.fMemberInfos.length) {
                    if (this.fMemberInfos[offset].getMember().equals(this.fMembersToMove[index2])) {
                        switch (this.fMemberInfos[offset].getAction()) {
                            case 1: {
                                arguments.put(ATTRIBUTE_ABSTRACT + (index2 + 1), Boolean.valueOf(true).toString());
                                break;
                            }
                            case 0: {
                                arguments.put(ATTRIBUTE_PUSH + (index2 + 1), Boolean.valueOf(true).toString());
                            }
                        }
                    }
                    ++offset;
                }
                ++index2;
            }
            DynamicValidationRefactoringChange dynamicValidationRefactoringChange = new DynamicValidationRefactoringChange(descriptor, RefactoringCoreMessages.PushDownRefactoring_change_name, (Change[])this.fChangeManager.getAllChanges());
            return dynamicValidationRefactoringChange;
        }
        finally {
            pm.done();
            this.clearCaches();
        }
    }

    private TextEditBasedChangeManager createChangeManager(IProgressMonitor monitor, RefactoringStatus status) throws CoreException {
        Assert.isNotNull((Object)monitor);
        Assert.isNotNull((Object)status);
        try {
            monitor.beginTask(RefactoringCoreMessages.PushDownRefactoring_checking, 7);
            IJavaScriptUnit source = this.getDeclaringType().getJavaScriptUnit();
            CompilationUnitRewrite sourceRewriter = new CompilationUnitRewrite(source);
            HashMap<IJavaScriptUnit, CompilationUnitRewrite> rewrites = new HashMap<IJavaScriptUnit, CompilationUnitRewrite>(2);
            rewrites.put(source, sourceRewriter);
            IType[] types = this.getHierarchyOfDeclaringClass((IProgressMonitor)new SubProgressMonitor(monitor, 1)).getSubclasses(this.getDeclaringType());
            HashSet<IJavaScriptUnit> result = new HashSet<IJavaScriptUnit>(types.length + 1);
            int index = 0;
            while (index < types.length) {
                result.add(types[index].getJavaScriptUnit());
                ++index;
            }
            result.add(source);
            HashMap adjustments = new HashMap();
            ArrayList adjustors = new ArrayList();
            IJavaScriptUnit[] units = result.toArray(new IJavaScriptUnit[result.size()]);
            IJavaScriptUnit unit2 = null;
            CompilationUnitRewrite rewrite = null;
            SubProgressMonitor sub = new SubProgressMonitor(monitor, 4);
            try {
                sub.beginTask(RefactoringCoreMessages.PushDownRefactoring_checking, units.length * 4);
                int index2 = 0;
                while (index2 < units.length) {
                    int offset;
                    unit2 = units[index2];
                    rewrite = PushDownRefactoringProcessor.getCompilationUnitRewrite(rewrites, unit2);
                    if (unit2.equals(sourceRewriter.getCu())) {
                        AbstractTypeDeclaration declaration = ASTNodeSearchUtil.getAbstractTypeDeclarationNode(this.getDeclaringType(), rewrite.getRoot());
                        if (!JdtFlags.isAbstract(this.getDeclaringType()) && this.getAbstractDeclarationInfos().length != 0) {
                            ModifierRewrite.create(rewrite.getASTRewrite(), declaration).setModifiers(0x400 | declaration.getModifiers(), (TextEditGroup)rewrite.createCategorizedGroupDescription(RefactoringCoreMessages.PushDownRefactoring_make_abstract, SET_PUSH_DOWN));
                        }
                        PushDownRefactoringProcessor.deleteDeclarationNodes(sourceRewriter, false, rewrite, Arrays.asList(this.getDeletableMembers()), SET_PUSH_DOWN);
                        MemberActionInfo[] methods = this.getAbstractDeclarationInfos();
                        offset = 0;
                        while (offset < methods.length) {
                            this.declareMethodAbstract(methods[offset], sourceRewriter, rewrite);
                            ++offset;
                        }
                    }
                    IMember[] members = PushDownRefactoringProcessor.getAbstractMembers(this.getAbstractDestinations((IProgressMonitor)new SubProgressMonitor(monitor, 1)));
                    IType[] classes = new IType[members.length];
                    offset = 0;
                    while (offset < members.length) {
                        classes[offset] = (IType)members[offset];
                        ++offset;
                    }
                    this.copyMembers(adjustors, adjustments, rewrites, status, this.getAbstractMemberInfos(), classes, sourceRewriter, rewrite, (IProgressMonitor)sub);
                    this.copyMembers(adjustors, adjustments, rewrites, status, this.getEffectedMemberInfos(), this.getAbstractDestinations((IProgressMonitor)new SubProgressMonitor(monitor, 1)), sourceRewriter, rewrite, (IProgressMonitor)sub);
                    if (monitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    ++index2;
                }
            }
            finally {
                sub.done();
            }
            if (!adjustors.isEmpty() && !adjustments.isEmpty()) {
                MemberVisibilityAdjustor adjustor = (MemberVisibilityAdjustor)adjustors.get(0);
                adjustor.rewriteVisibility((IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
            TextEditBasedChangeManager manager = new TextEditBasedChangeManager();
            for (IJavaScriptUnit unit2 : rewrites.keySet()) {
                rewrite = (CompilationUnitRewrite)rewrites.get(unit2);
                if (rewrite == null) continue;
                manager.manage(unit2, (TextEditBasedChange)rewrite.createChange());
            }
            TextEditBasedChangeManager textEditBasedChangeManager = manager;
            return textEditBasedChangeManager;
        }
        finally {
            monitor.done();
        }
    }

    private FieldDeclaration createNewFieldDeclarationNode(MemberActionInfo info, JavaScriptUnit declaringCuNode, TypeVariableMaplet[] mapping, ASTRewrite rewrite, VariableDeclarationFragment oldFieldFragment) throws JavaScriptModelException {
        Assert.isTrue((boolean)info.isFieldInfo());
        IField field = (IField)info.getMember();
        AST ast = rewrite.getAST();
        VariableDeclarationFragment newFragment = ast.newVariableDeclarationFragment();
        newFragment.setExtraDimensions(oldFieldFragment.getExtraDimensions());
        Expression initializer = oldFieldFragment.getInitializer();
        if (initializer != null) {
            Expression newInitializer = null;
            newInitializer = mapping.length > 0 ? PushDownRefactoringProcessor.createPlaceholderForExpression(initializer, field.getJavaScriptUnit(), mapping, rewrite) : PushDownRefactoringProcessor.createPlaceholderForExpression(initializer, field.getJavaScriptUnit(), rewrite);
            newFragment.setInitializer(newInitializer);
        }
        newFragment.setName(ast.newSimpleName(oldFieldFragment.getName().getIdentifier()));
        FieldDeclaration newField = ast.newFieldDeclaration(newFragment);
        FieldDeclaration oldField = ASTNodeSearchUtil.getFieldDeclarationNode(field, declaringCuNode);
        if (info.copyJavadocToCopiesInSubclasses()) {
            PushDownRefactoringProcessor.copyJavadocNode(rewrite, field, oldField, newField);
        }
        PushDownRefactoringProcessor.copyAnnotations(oldField, newField);
        newField.modifiers().addAll(ASTNodeFactory.newModifiers(ast, info.getNewModifiersForCopyInSubclass(oldField.getModifiers())));
        Type oldType = oldField.getType();
        IJavaScriptUnit cu = field.getJavaScriptUnit();
        Type newType = null;
        newType = mapping.length > 0 ? PushDownRefactoringProcessor.createPlaceholderForType(oldType, cu, mapping, rewrite) : PushDownRefactoringProcessor.createPlaceholderForType(oldType, cu, rewrite);
        newField.setType(newType);
        return newField;
    }

    private FunctionDeclaration createNewMethodDeclarationNode(MemberActionInfo info, JavaScriptUnit declaringCuNode, TypeVariableMaplet[] mapping, CompilationUnitRewrite rewriter, FunctionDeclaration oldMethod) throws JavaScriptModelException {
        Assert.isTrue((!info.isFieldInfo() ? 1 : 0) != 0);
        IFunction method = (IFunction)info.getMember();
        ASTRewrite rewrite = rewriter.getASTRewrite();
        AST ast = rewrite.getAST();
        FunctionDeclaration newMethod = ast.newFunctionDeclaration();
        this.copyBodyOfPushedDownMethod(rewrite, method, oldMethod, newMethod, mapping);
        newMethod.setConstructor(oldMethod.isConstructor());
        newMethod.setExtraDimensions(oldMethod.getExtraDimensions());
        if (info.copyJavadocToCopiesInSubclasses()) {
            PushDownRefactoringProcessor.copyJavadocNode(rewrite, method, oldMethod, newMethod);
        }
        rewriter.getCu().getJavaScriptProject();
        PushDownRefactoringProcessor.copyAnnotations(oldMethod, newMethod);
        newMethod.modifiers().addAll(ASTNodeFactory.newModifiers(ast, info.getNewModifiersForCopyInSubclass(oldMethod.getModifiers())));
        newMethod.setName(ast.newSimpleName(oldMethod.getName().getIdentifier()));
        this.copyReturnType(rewrite, method.getJavaScriptUnit(), oldMethod, newMethod, mapping);
        this.copyParameters(rewrite, method.getJavaScriptUnit(), oldMethod, newMethod, mapping);
        PushDownRefactoringProcessor.copyThrownExceptions(oldMethod, newMethod);
        return newMethod;
    }

    private void declareMethodAbstract(MemberActionInfo info, CompilationUnitRewrite sourceRewrite, CompilationUnitRewrite unitRewrite) throws JavaScriptModelException {
        Assert.isTrue((!info.isFieldInfo() ? 1 : 0) != 0);
        IFunction method = (IFunction)info.getMember();
        if (JdtFlags.isAbstract(method)) {
            return;
        }
        FunctionDeclaration declaration = ASTNodeSearchUtil.getMethodDeclarationNode(method, sourceRewrite.getRoot());
        unitRewrite.getASTRewrite().remove(declaration.getBody(), null);
        sourceRewrite.getImportRemover().registerRemovedNode(declaration.getBody());
        ModifierRewrite.create(unitRewrite.getASTRewrite(), declaration).setModifiers(info.getNewModifiersForOriginal(declaration.getModifiers()), null);
    }

    private MemberActionInfo[] getAbstractDeclarationInfos() throws JavaScriptModelException {
        ArrayList<MemberActionInfo> result = new ArrayList<MemberActionInfo>(this.fMemberInfos.length);
        int index = 0;
        while (index < this.fMemberInfos.length) {
            MemberActionInfo info = this.fMemberInfos[index];
            if (info.isNewMethodToBeDeclaredAbstract()) {
                result.add(info);
            }
            ++index;
        }
        return result.toArray(new MemberActionInfo[result.size()]);
    }

    private IType[] getAbstractDestinations(IProgressMonitor monitor) throws JavaScriptModelException {
        IType[] allDirectSubclasses = this.getHierarchyOfDeclaringClass(monitor).getSubclasses(this.getDeclaringType());
        ArrayList<IType> result = new ArrayList<IType>(allDirectSubclasses.length);
        int index = 0;
        while (index < allDirectSubclasses.length) {
            IType subclass = allDirectSubclasses[index];
            if (subclass.exists() && !subclass.isBinary() && !subclass.isReadOnly() && subclass.getJavaScriptUnit() != null && subclass.isStructureKnown()) {
                result.add(subclass);
            }
            ++index;
        }
        return result.toArray(new IType[result.size()]);
    }

    private MemberActionInfo[] getAbstractMemberInfos() throws JavaScriptModelException {
        ArrayList<MemberActionInfo> result = new ArrayList<MemberActionInfo>(this.fMemberInfos.length);
        int index = 0;
        while (index < this.fMemberInfos.length) {
            MemberActionInfo info = this.fMemberInfos[index];
            if (info.isToBeCreatedInSubclassesOfDeclaringClass() && JdtFlags.isAbstract(info.getMember())) {
                result.add(info);
            }
            ++index;
        }
        return result.toArray(new MemberActionInfo[result.size()]);
    }

    public IMember[] getAdditionalRequiredMembers(IProgressMonitor monitor) throws JavaScriptModelException {
        IMember current;
        IMember[] members = MemberActionInfo.getMembers(this.getInfosForMembersToBeCreatedInSubclassesOfDeclaringClass());
        monitor.beginTask(RefactoringCoreMessages.PushDownRefactoring_calculating_required, members.length);
        ArrayList<IMember> queue = new ArrayList<IMember>(members.length);
        queue.addAll(Arrays.asList(members));
        if (queue.isEmpty()) {
            return new IMember[0];
        }
        int i = 0;
        do {
            current = (IMember)queue.get(i);
            this.addAllRequiredPushableMembers(queue, current, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            if (queue.size() != ++i) continue;
            current = null;
        } while (current != null);
        queue.removeAll(Arrays.asList(members));
        return queue.toArray(new IMember[queue.size()]);
    }

    private IMember[] getDeletableMembers() {
        ArrayList<IMember> result = new ArrayList<IMember>(this.fMemberInfos.length);
        int i = 0;
        while (i < this.fMemberInfos.length) {
            MemberActionInfo info = this.fMemberInfos[i];
            if (info.isToBeDeletedFromDeclaringClass()) {
                result.add(info.getMember());
            }
            ++i;
        }
        return result.toArray(new IMember[result.size()]);
    }

    private MemberActionInfo[] getEffectedMemberInfos() throws JavaScriptModelException {
        ArrayList<MemberActionInfo> result = new ArrayList<MemberActionInfo>(this.fMemberInfos.length);
        int i = 0;
        while (i < this.fMemberInfos.length) {
            MemberActionInfo info = this.fMemberInfos[i];
            if (info.isToBeCreatedInSubclassesOfDeclaringClass() && !JdtFlags.isAbstract(info.getMember())) {
                result.add(info);
            }
            ++i;
        }
        return result.toArray(new MemberActionInfo[result.size()]);
    }

    public Object[] getElements() {
        return this.fMembersToMove;
    }

    private ITypeHierarchy getHierarchyOfDeclaringClass(IProgressMonitor monitor) throws JavaScriptModelException {
        try {
            if (this.fCachedClassHierarchy != null) {
                ITypeHierarchy iTypeHierarchy = this.fCachedClassHierarchy;
                return iTypeHierarchy;
            }
            ITypeHierarchy iTypeHierarchy = this.fCachedClassHierarchy = this.getDeclaringType().newTypeHierarchy(monitor);
            return iTypeHierarchy;
        }
        finally {
            monitor.done();
        }
    }

    public String getIdentifier() {
        return IDENTIFIER;
    }

    private MemberActionInfo[] getInfosForMembersToBeCreatedInSubclassesOfDeclaringClass() throws JavaScriptModelException {
        MemberActionInfo[] abs = this.getAbstractMemberInfos();
        MemberActionInfo[] nonabs = this.getEffectedMemberInfos();
        ArrayList<MemberActionInfo> result = new ArrayList<MemberActionInfo>(abs.length + nonabs.length);
        result.addAll(Arrays.asList(abs));
        result.addAll(Arrays.asList(nonabs));
        return result.toArray(new MemberActionInfo[result.size()]);
    }

    public MemberActionInfo[] getMemberActionInfos() {
        return this.fMemberInfos;
    }

    public String getProcessorName() {
        return RefactoringCoreMessages.PushDownRefactoring_name;
    }

    @Override
    public RefactoringStatus initialize(RefactoringArguments arguments) {
        if (arguments instanceof JavaRefactoringArguments) {
            JavaRefactoringArguments extended = (JavaRefactoringArguments)arguments;
            String handle = extended.getAttribute("input");
            if (handle != null) {
                IJavaScriptElement element = JDTRefactoringDescriptor.handleToElement(extended.getProject(), handle, false);
                if (element == null || !element.exists() || element.getElementType() != 7) {
                    return ScriptableRefactoring.createInputFatalStatus(element, this.getRefactoring().getName(), "org.eclipse.wst.jsdt.ui.push.down");
                }
                this.fCachedDeclaringType = (IType)element;
            }
            int count = 1;
            ArrayList<IJavaScriptElement> elements = new ArrayList<IJavaScriptElement>();
            ArrayList<MemberActionInfo> infos = new ArrayList<MemberActionInfo>();
            String attribute = "element" + count;
            RefactoringStatus status = new RefactoringStatus();
            while ((handle = extended.getAttribute(attribute)) != null) {
                IJavaScriptElement element = JDTRefactoringDescriptor.handleToElement(extended.getProject(), handle, false);
                if (element == null || !element.exists()) {
                    status.merge(ScriptableRefactoring.createInputWarningStatus(element, this.getRefactoring().getName(), "org.eclipse.wst.jsdt.ui.push.down"));
                } else {
                    elements.add(element);
                }
                if (extended.getAttribute(ATTRIBUTE_ABSTRACT + count) != null) {
                    infos.add(MemberActionInfo.create((IMember)element, 1));
                } else if (extended.getAttribute(ATTRIBUTE_PUSH + count) != null) {
                    infos.add(MemberActionInfo.create((IMember)element, 0));
                } else {
                    infos.add(MemberActionInfo.create((IMember)element, 2));
                }
                attribute = "element" + ++count;
            }
            this.fMembersToMove = elements.toArray(new IMember[elements.size()]);
            this.fMemberInfos = infos.toArray(new MemberActionInfo[infos.size()]);
            if (!status.isOK()) {
                return status;
            }
        } else {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.InitializableRefactoring_inacceptable_arguments);
        }
        return new RefactoringStatus();
    }

    public boolean isApplicable() throws CoreException {
        return RefactoringAvailabilityTester.isPushDownAvailable(this.fMembersToMove);
    }

    @Override
    protected void rewriteTypeOccurrences(TextEditBasedChangeManager manager, ASTRequestor requestor, CompilationUnitRewrite rewrite, IJavaScriptUnit unit, JavaScriptUnit node, Set replacements, IProgressMonitor monitor) throws CoreException {
    }

    public static class MemberActionInfo
    implements IMemberActionInfo {
        public static final int NO_ACTION = 2;
        public static final int PUSH_ABSTRACT_ACTION = 1;
        public static final int PUSH_DOWN_ACTION = 0;
        private int fAction;
        private final IMember fMember;

        private static void assertValidAction(IMember member, int action) {
            if (member instanceof IFunction) {
                Assert.isTrue((action == 1 || action == 2 || action == 0 ? 1 : 0) != 0);
            } else if (member instanceof IField) {
                Assert.isTrue((action == 2 || action == 0 ? 1 : 0) != 0);
            }
        }

        public static MemberActionInfo create(IMember member, int action) {
            return new MemberActionInfo(member, action);
        }

        static IMember[] getMembers(MemberActionInfo[] infos) {
            IMember[] result = new IMember[infos.length];
            int i = 0;
            while (i < result.length) {
                result[i] = infos[i].getMember();
                ++i;
            }
            return result;
        }

        private MemberActionInfo(IMember member, int action) {
            MemberActionInfo.assertValidAction(member, action);
            Assert.isTrue((member instanceof IField || member instanceof IFunction ? 1 : 0) != 0);
            this.fMember = member;
            this.fAction = action;
        }

        boolean copyJavadocToCopiesInSubclasses() {
            return this.isToBeDeletedFromDeclaringClass();
        }

        public int getAction() {
            return this.fAction;
        }

        public int[] getAvailableActions() {
            if (this.isFieldInfo()) {
                int[] nArray = new int[2];
                nArray[1] = 2;
                return nArray;
            }
            int[] nArray = new int[3];
            nArray[1] = 1;
            nArray[2] = 2;
            return nArray;
        }

        public IMember getMember() {
            return this.fMember;
        }

        int getNewModifiersForCopyInSubclass(int oldModifiers) throws JavaScriptModelException {
            if (this.isFieldInfo()) {
                return oldModifiers;
            }
            if (this.isToBeDeletedFromDeclaringClass()) {
                return oldModifiers;
            }
            int modifiers = oldModifiers;
            if (this.isNewMethodToBeDeclaredAbstract() && !JdtFlags.isPublic(this.fMember)) {
                modifiers = 4 | JdtFlags.clearAccessModifiers(modifiers);
            }
            return modifiers;
        }

        int getNewModifiersForOriginal(int oldModifiers) throws JavaScriptModelException {
            if (this.isFieldInfo()) {
                return oldModifiers;
            }
            if (this.isToBeDeletedFromDeclaringClass()) {
                return oldModifiers;
            }
            int modifiers = oldModifiers;
            if (this.isNewMethodToBeDeclaredAbstract()) {
                modifiers = JdtFlags.clearFlag(272, oldModifiers);
                modifiers |= 0x400;
                if (!JdtFlags.isPublic(this.fMember)) {
                    modifiers = 4 | JdtFlags.clearAccessModifiers(modifiers);
                }
            }
            return modifiers;
        }

        @Override
        public boolean isActive() {
            return this.getAction() != 2;
        }

        public boolean isEditable() {
            if (this.isFieldInfo()) {
                return false;
            }
            return this.getAction() != 2;
        }

        boolean isFieldInfo() {
            return this.fMember instanceof IField;
        }

        boolean isNewMethodToBeDeclaredAbstract() throws JavaScriptModelException {
            return !this.isFieldInfo() && !JdtFlags.isAbstract(this.fMember) && this.fAction == 1;
        }

        boolean isToBeCreatedInSubclassesOfDeclaringClass() {
            return this.fAction != 2;
        }

        boolean isToBeDeletedFromDeclaringClass() {
            return this.isToBePushedDown();
        }

        public boolean isToBePushedDown() {
            return this.fAction == 0;
        }

        public void setAction(int action) {
            MemberActionInfo.assertValidAction(this.fMember, action);
            if (this.isFieldInfo()) {
                Assert.isTrue((action != 1 ? 1 : 0) != 0);
            }
            this.fAction = action;
        }
    }
}

