/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.reorg;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.ISourceReference;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;

public class SourceReferenceUtil {
    private SourceReferenceUtil() {
    }

    public static IFile getFile(ISourceReference ref) {
        IJavaScriptUnit unit = SourceReferenceUtil.getCompilationUnit(ref);
        return (IFile)unit.getPrimary().getResource();
    }

    public static IJavaScriptUnit getCompilationUnit(ISourceReference o) {
        Assert.isTrue((!(o instanceof IClassFile) ? 1 : 0) != 0);
        if (o instanceof IJavaScriptUnit) {
            return (IJavaScriptUnit)o;
        }
        if (o instanceof IJavaScriptElement) {
            return (IJavaScriptUnit)((IJavaScriptElement)((Object)o)).getAncestor(5);
        }
        return null;
    }

    private static boolean hasParentInSet(IJavaScriptElement elem, Set set) {
        IJavaScriptElement parent = elem.getParent();
        while (parent != null) {
            if (set.contains(parent)) {
                return true;
            }
            parent = parent.getParent();
        }
        return false;
    }

    public static ISourceReference[] removeAllWithParentsSelected(ISourceReference[] elems) {
        HashSet<ISourceReference> set = new HashSet<ISourceReference>(Arrays.asList(elems));
        ArrayList<ISourceReference> result = new ArrayList<ISourceReference>(elems.length);
        int i = 0;
        while (i < elems.length) {
            ISourceReference elem = elems[i];
            if (!(elem instanceof IJavaScriptElement)) {
                result.add(elem);
            } else if (!SourceReferenceUtil.hasParentInSet((IJavaScriptElement)((Object)elem), set)) {
                result.add(elem);
            }
            ++i;
        }
        return result.toArray(new ISourceReference[result.size()]);
    }

    public static Map groupByFile(ISourceReference[] elems) {
        HashMap map = new HashMap();
        int i = 0;
        while (i < elems.length) {
            ISourceReference elem = elems[i];
            IFile file = SourceReferenceUtil.getFile(elem);
            if (!map.containsKey(file)) {
                map.put(file, new ArrayList());
            }
            ((List)map.get(file)).add(elem);
            ++i;
        }
        return map;
    }

    public static ISourceReference[] sortByOffset(ISourceReference[] methods) {
        Arrays.sort(methods, new Comparator(){

            public int compare(Object o1, Object o2) {
                try {
                    return ((ISourceReference)o2).getSourceRange().getOffset() - ((ISourceReference)o1).getSourceRange().getOffset();
                }
                catch (JavaScriptModelException javaScriptModelException) {
                    return o2.hashCode() - o1.hashCode();
                }
            }
        });
        return methods;
    }
}

