/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.code.flow;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.IRegion;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.BodyDeclaration;
import org.eclipse.wst.jsdt.core.dom.ConditionalExpression;
import org.eclipse.wst.jsdt.core.dom.DoStatement;
import org.eclipse.wst.jsdt.core.dom.EnhancedForStatement;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.ForInStatement;
import org.eclipse.wst.jsdt.core.dom.ForStatement;
import org.eclipse.wst.jsdt.core.dom.IfStatement;
import org.eclipse.wst.jsdt.core.dom.ReturnStatement;
import org.eclipse.wst.jsdt.core.dom.Statement;
import org.eclipse.wst.jsdt.core.dom.SwitchStatement;
import org.eclipse.wst.jsdt.core.dom.WhileStatement;
import org.eclipse.wst.jsdt.internal.corext.dom.Selection;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.flow.DoWhileFlowInfo;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.flow.EnhancedForFlowInfo;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.flow.FlowAnalyzer;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.flow.FlowContext;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.flow.FlowInfo;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.flow.ForFlowInfo;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.flow.GenericConditionalFlowInfo;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.flow.GenericSequentialFlowInfo;

public class InputFlowAnalyzer
extends FlowAnalyzer {
    private Selection fSelection;
    private boolean fDoLoopReentrance;
    private LoopReentranceVisitor fLoopReentranceVisitor;

    public InputFlowAnalyzer(FlowContext context, Selection selection, boolean doLoopReentrance) {
        super(context);
        this.fSelection = selection;
        Assert.isNotNull((Object)this.fSelection);
        this.fDoLoopReentrance = doLoopReentrance;
    }

    public FlowInfo perform(BodyDeclaration node) {
        Assert.isTrue((!(node instanceof AbstractTypeDeclaration) ? 1 : 0) != 0);
        node.accept(this);
        return this.getFlowInfo(node);
    }

    @Override
    protected boolean traverseNode(ASTNode node) {
        return node.getStartPosition() + node.getLength() > this.fSelection.getInclusiveEnd();
    }

    @Override
    protected boolean createReturnFlowInfo(ReturnStatement node) {
        return node.getStartPosition() >= this.fSelection.getInclusiveEnd();
    }

    @Override
    public boolean visit(DoStatement node) {
        this.createLoopReentranceVisitor(node);
        return super.visit(node);
    }

    @Override
    public boolean visit(EnhancedForStatement node) {
        this.createLoopReentranceVisitor(node);
        return super.visit(node);
    }

    @Override
    public boolean visit(ForStatement node) {
        this.createLoopReentranceVisitor(node);
        return super.visit(node);
    }

    @Override
    public boolean visit(ForInStatement node) {
        this.createLoopReentranceVisitor(node);
        return super.visit(node);
    }

    @Override
    public boolean visit(WhileStatement node) {
        this.createLoopReentranceVisitor(node);
        return super.visit(node);
    }

    private void createLoopReentranceVisitor(ASTNode node) {
        if (this.fLoopReentranceVisitor == null && this.fDoLoopReentrance) {
            this.fLoopReentranceVisitor = new LoopReentranceVisitor(this.fFlowContext, this.fSelection, node);
        }
    }

    @Override
    public void endVisit(ConditionalExpression node) {
        if (this.skipNode(node)) {
            return;
        }
        Expression thenPart = node.getThenExpression();
        Expression elsePart = node.getElseExpression();
        if (thenPart != null && this.fSelection.coveredBy(thenPart) || elsePart != null && this.fSelection.coveredBy(elsePart)) {
            GenericSequentialFlowInfo info = this.createSequential();
            this.setFlowInfo(node, info);
            this.endVisitConditional(info, node.getExpression(), new ASTNode[]{thenPart, elsePart});
        } else {
            super.endVisit(node);
        }
    }

    @Override
    public void endVisit(DoStatement node) {
        super.endVisit(node);
        this.handleLoopReentrance(node);
    }

    @Override
    public void endVisit(IfStatement node) {
        if (this.skipNode(node)) {
            return;
        }
        Statement thenPart = node.getThenStatement();
        Statement elsePart = node.getElseStatement();
        if (thenPart != null && this.fSelection.coveredBy(thenPart) || elsePart != null && this.fSelection.coveredBy(elsePart)) {
            GenericSequentialFlowInfo info = this.createSequential();
            this.setFlowInfo(node, info);
            this.endVisitConditional(info, node.getExpression(), new ASTNode[]{thenPart, elsePart});
        } else {
            super.endVisit(node);
        }
    }

    @Override
    public void endVisit(EnhancedForStatement node) {
        super.endVisit(node);
        this.handleLoopReentrance(node);
    }

    @Override
    public void endVisit(ForStatement node) {
        super.endVisit(node);
        this.handleLoopReentrance(node);
    }

    @Override
    public void endVisit(ForInStatement node) {
        super.endVisit(node);
        this.handleLoopReentrance(node);
    }

    @Override
    public void endVisit(SwitchStatement node) {
        if (this.skipNode(node)) {
            return;
        }
        FlowAnalyzer.SwitchData data = this.createSwitchData(node);
        IRegion[] ranges = data.getRanges();
        int i = 0;
        while (i < ranges.length) {
            IRegion range = ranges[i];
            if (this.fSelection.coveredBy(range)) {
                GenericSequentialFlowInfo info = this.createSequential();
                this.setFlowInfo(node, info);
                info.merge(this.getFlowInfo(node.getExpression()), this.fFlowContext);
                info.merge(data.getInfo(i), this.fFlowContext);
                info.removeLabel(null);
                return;
            }
            ++i;
        }
        super.endVisit(node, data);
    }

    @Override
    public void endVisit(WhileStatement node) {
        super.endVisit(node);
        this.handleLoopReentrance(node);
    }

    private void endVisitConditional(GenericSequentialFlowInfo info, ASTNode condition, ASTNode[] branches) {
        info.merge(this.getFlowInfo(condition), this.fFlowContext);
        int i = 0;
        while (i < branches.length) {
            ASTNode branch = branches[i];
            if (branch != null && this.fSelection.coveredBy(branch)) {
                info.merge(this.getFlowInfo(branch), this.fFlowContext);
                break;
            }
            ++i;
        }
    }

    private void handleLoopReentrance(ASTNode node) {
        if (!this.fSelection.coveredBy(node) || this.fLoopReentranceVisitor == null || this.fLoopReentranceVisitor.getLoopNode() != node) {
            return;
        }
        this.fLoopReentranceVisitor.process(node);
        GenericSequentialFlowInfo info = this.createSequential();
        info.merge(this.getFlowInfo(node), this.fFlowContext);
        info.merge(this.fLoopReentranceVisitor.getFlowInfo(node), this.fFlowContext);
        this.setFlowInfo(node, info);
    }

    private static class LoopReentranceVisitor
    extends FlowAnalyzer {
        private Selection fSelection;
        private ASTNode fLoopNode;

        public LoopReentranceVisitor(FlowContext context, Selection selection, ASTNode loopNode) {
            super(context);
            this.fSelection = selection;
            this.fLoopNode = loopNode;
        }

        @Override
        protected boolean traverseNode(ASTNode node) {
            return true;
        }

        @Override
        protected boolean createReturnFlowInfo(ReturnStatement node) {
            return node.getStartPosition() + node.getLength() <= this.fSelection.getExclusiveEnd();
        }

        protected ASTNode getLoopNode() {
            return this.fLoopNode;
        }

        public void process(ASTNode node) {
            try {
                this.fFlowContext.setLoopReentranceMode(true);
                node.accept(this);
            }
            finally {
                this.fFlowContext.setLoopReentranceMode(false);
            }
        }

        @Override
        public void endVisit(DoStatement node) {
            if (this.skipNode(node)) {
                return;
            }
            DoWhileFlowInfo info = this.createDoWhile();
            this.setFlowInfo(node, info);
            info.mergeAction(this.getFlowInfo(node.getBody()), this.fFlowContext);
            info.removeLabel(null);
        }

        @Override
        public void endVisit(ForInStatement node) {
            if (this.skipNode(node)) {
                return;
            }
            FlowInfo paramInfo = this.getFlowInfo(node.getIterationVariable());
            FlowInfo expressionInfo = this.getFlowInfo(node.getCollection());
            FlowInfo actionInfo = this.getFlowInfo(node.getBody());
            EnhancedForFlowInfo forInfo = this.createEnhancedFor();
            this.setFlowInfo(node, forInfo);
            if (node == this.fLoopNode) {
                forInfo.mergeAction(actionInfo, this.fFlowContext);
            } else {
                forInfo.mergeExpression(expressionInfo, this.fFlowContext);
                forInfo.mergeParameter(paramInfo, this.fFlowContext);
                forInfo.mergeAction(actionInfo, this.fFlowContext);
            }
            forInfo.removeLabel(null);
        }

        @Override
        public void endVisit(EnhancedForStatement node) {
            if (this.skipNode(node)) {
                return;
            }
            FlowInfo paramInfo = this.getFlowInfo(node.getParameter());
            FlowInfo expressionInfo = this.getFlowInfo(node.getExpression());
            FlowInfo actionInfo = this.getFlowInfo(node.getBody());
            EnhancedForFlowInfo forInfo = this.createEnhancedFor();
            this.setFlowInfo(node, forInfo);
            if (node == this.fLoopNode) {
                forInfo.mergeAction(actionInfo, this.fFlowContext);
            } else {
                forInfo.mergeExpression(expressionInfo, this.fFlowContext);
                forInfo.mergeParameter(paramInfo, this.fFlowContext);
                forInfo.mergeAction(actionInfo, this.fFlowContext);
            }
            forInfo.removeLabel(null);
        }

        @Override
        public void endVisit(ForStatement node) {
            if (this.skipNode(node)) {
                return;
            }
            GenericSequentialFlowInfo initInfo = this.createSequential(node.initializers());
            FlowInfo conditionInfo = this.getFlowInfo(node.getExpression());
            GenericSequentialFlowInfo incrementInfo = this.createSequential(node.updaters());
            FlowInfo actionInfo = this.getFlowInfo(node.getBody());
            ForFlowInfo forInfo = this.createFor();
            this.setFlowInfo(node, forInfo);
            if (node == this.fLoopNode) {
                forInfo.mergeIncrement(incrementInfo, this.fFlowContext);
                forInfo.mergeCondition(conditionInfo, this.fFlowContext);
                forInfo.mergeAction(actionInfo, this.fFlowContext);
            } else {
                GenericConditionalFlowInfo initIncr = new GenericConditionalFlowInfo();
                initIncr.merge(initInfo, this.fFlowContext);
                initIncr.merge(incrementInfo, this.fFlowContext);
                forInfo.mergeAccessModeSequential(initIncr, this.fFlowContext);
                forInfo.mergeCondition(conditionInfo, this.fFlowContext);
                forInfo.mergeAction(actionInfo, this.fFlowContext);
            }
            forInfo.removeLabel(null);
        }
    }
}

