/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.jsdt.core.IBuffer;
import org.eclipse.wst.jsdt.core.IExportContainer;
import org.eclipse.wst.jsdt.core.IField;
import org.eclipse.wst.jsdt.core.IImportContainer;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.ISourceReference;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTParser;
import org.eclipse.wst.jsdt.core.dom.FieldDeclaration;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationFragment;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.ReorgUtils;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.ASTNodeSearchUtil;
import org.eclipse.wst.jsdt.internal.corext.util.Strings;

public class TypedSource {
    private final String fSource;
    private final int fType;

    private TypedSource(String source, int type) {
        Assert.isNotNull((Object)source);
        Assert.isTrue((boolean)TypedSource.canCreateForType(type));
        this.fSource = source;
        this.fType = type;
    }

    public static TypedSource create(String source, int type) {
        if (source == null || !TypedSource.canCreateForType(type)) {
            return null;
        }
        return new TypedSource(source, type);
    }

    public String getSource() {
        return this.fSource;
    }

    public int getType() {
        return this.fType;
    }

    public boolean equals(Object other) {
        if (!(other instanceof TypedSource)) {
            return false;
        }
        TypedSource ts = (TypedSource)other;
        return ts.getSource().equals(this.getSource()) && ts.getType() == this.getType();
    }

    public int hashCode() {
        return this.getSource().hashCode() ^ 97 * this.getType();
    }

    private static boolean canCreateForType(int type) {
        return type == 8 || type == 7 || type == 12 || type == 13 || type == 15 || type == 16 || type == 10 || type == 9;
    }

    public static void sortByType(TypedSource[] typedSources) {
        Arrays.sort(typedSources, TypedSource.createTypeComparator());
    }

    public static Comparator createTypeComparator() {
        return new Comparator(){

            public int compare(Object arg0, Object arg1) {
                return ((TypedSource)arg0).getType() - ((TypedSource)arg1).getType();
            }
        };
    }

    public static TypedSource[] createTypedSources(IJavaScriptElement[] javaElements) throws CoreException {
        Map grouped = ReorgUtils.groupByCompilationUnit(Arrays.asList(javaElements));
        ArrayList<TypedSource> result = new ArrayList<TypedSource>(javaElements.length);
        for (IJavaScriptUnit cu : grouped.keySet()) {
            Iterator iterator = ((List)grouped.get(cu)).iterator();
            while (iterator.hasNext()) {
                SourceTuple tuple = new SourceTuple(cu);
                TypedSource[] ts = TypedSource.createTypedSources((IJavaScriptElement)iterator.next(), tuple);
                if (ts == null) continue;
                result.addAll(Arrays.asList(ts));
            }
        }
        return result.toArray(new TypedSource[result.size()]);
    }

    private static TypedSource[] createTypedSources(IJavaScriptElement elem, SourceTuple tuple) throws CoreException {
        if (!ReorgUtils.isInsideCompilationUnit(elem)) {
            return null;
        }
        if (elem.getElementType() == 12) {
            return TypedSource.createTypedSourcesForImportContainer(tuple, (IImportContainer)elem);
        }
        if (elem.getElementType() == 15) {
            return TypedSource.createTypedSourcesForExportContainer(tuple, (IExportContainer)elem);
        }
        if (elem.getElementType() == 8) {
            return new TypedSource[]{TypedSource.create(TypedSource.getFieldSource((IField)elem, tuple), elem.getElementType())};
        }
        return new TypedSource[]{TypedSource.create(TypedSource.getSourceOfDeclararationNode(elem, tuple.unit), elem.getElementType())};
    }

    private static TypedSource[] createTypedSourcesForImportContainer(SourceTuple tuple, IImportContainer container) throws JavaScriptModelException, CoreException {
        IJavaScriptElement[] imports = container.getChildren();
        ArrayList<TypedSource> result = new ArrayList<TypedSource>(imports.length);
        int i = 0;
        while (i < imports.length) {
            result.addAll(Arrays.asList(TypedSource.createTypedSources(imports[i], tuple)));
            ++i;
        }
        return result.toArray(new TypedSource[result.size()]);
    }

    private static TypedSource[] createTypedSourcesForExportContainer(SourceTuple tuple, IExportContainer container) throws JavaScriptModelException, CoreException {
        IJavaScriptElement[] exports = container.getChildren();
        ArrayList<TypedSource> result = new ArrayList<TypedSource>(exports.length);
        int i = 0;
        while (i < exports.length) {
            result.addAll(Arrays.asList(TypedSource.createTypedSources(exports[i], tuple)));
            ++i;
        }
        return result.toArray(new TypedSource[result.size()]);
    }

    private static String getFieldSource(IField field, SourceTuple tuple) throws CoreException {
        FieldDeclaration declaration;
        if (tuple.node == null) {
            ASTParser parser = ASTParser.newParser(3);
            parser.setSource(tuple.unit);
            tuple.node = (JavaScriptUnit)parser.createAST(null);
        }
        if ((declaration = ASTNodeSearchUtil.getFieldDeclarationNode(field, tuple.node)).fragments().size() == 1) {
            return TypedSource.getSourceOfDeclararationNode(field, tuple.unit);
        }
        VariableDeclarationFragment declarationFragment = ASTNodeSearchUtil.getFieldDeclarationFragmentNode(field, tuple.node);
        IBuffer buffer = tuple.unit.getBuffer();
        StringBuffer buff = new StringBuffer();
        buff.append(buffer.getText(declaration.getStartPosition(), ((ASTNode)declaration.fragments().get(0)).getStartPosition() - declaration.getStartPosition()));
        buff.append(buffer.getText(declarationFragment.getStartPosition(), declarationFragment.getLength()));
        buff.append(";");
        return buff.toString();
    }

    private static String getSourceOfDeclararationNode(IJavaScriptElement elem, IJavaScriptUnit cu) throws JavaScriptModelException, CoreException {
        ISourceReference reference;
        String source;
        Assert.isTrue((elem.getElementType() != 12 ? 1 : 0) != 0);
        Assert.isTrue((elem.getElementType() != 15 ? 1 : 0) != 0);
        if (elem instanceof ISourceReference && (source = (reference = (ISourceReference)((Object)elem)).getSource()) != null) {
            return Strings.trimIndentation(source, cu.getJavaScriptProject(), false);
        }
        return "";
    }

    private static class SourceTuple {
        private IJavaScriptUnit unit;
        private JavaScriptUnit node;

        private SourceTuple(IJavaScriptUnit unit) {
            this.unit = unit;
        }
    }
}

