/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.wst.jsdt.core.IFunction;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.ILocalVariable;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaScriptConventions;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.Signature;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.IFunctionBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.IVariableBinding;
import org.eclipse.wst.jsdt.core.dom.Name;
import org.eclipse.wst.jsdt.core.dom.VariableDeclaration;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodes;
import org.eclipse.wst.jsdt.internal.corext.dom.Bindings;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.wst.jsdt.internal.corext.refactoring.SearchResultGroup;
import org.eclipse.wst.jsdt.internal.corext.refactoring.base.JavaStatusContext;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.RenameResourceChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.JavaElementUtil;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.corext.util.Resources;

public class Checks {
    public static final int IS_RVALUE = 0;
    public static final int NOT_RVALUE_MISC = 1;
    public static final int NOT_RVALUE_VOID = 2;

    private Checks() {
    }

    public static RefactoringStatus checkIfConstructorName(IFunction method, String newMethodName, String newTypeName) {
        if (!newMethodName.equals(newTypeName)) {
            return null;
        }
        return RefactoringStatus.createWarningStatus((String)Messages.format(RefactoringCoreMessages.Checks_constructor_name, new Object[]{JavaElementUtil.createMethodSignature(method), JavaModelUtil.getFullyQualifiedName(method.getDeclaringType())}));
    }

    public static RefactoringStatus checkFieldName(String name) {
        return Checks.checkName(name, JavaScriptConventions.validateFieldName(name));
    }

    public static RefactoringStatus checkTypeParameterName(String name) {
        return Checks.checkName(name, JavaScriptConventions.validateTypeVariableName(name));
    }

    public static RefactoringStatus checkIdentifier(String name) {
        return Checks.checkName(name, JavaScriptConventions.validateIdentifier(name));
    }

    public static RefactoringStatus checkMethodName(String name) {
        RefactoringStatus status = Checks.checkName(name, JavaScriptConventions.validateFunctionName(name));
        if (status.isOK() && Checks.startsWithUpperCase(name)) {
            return RefactoringStatus.createWarningStatus((String)RefactoringCoreMessages.Checks_method_names_lowercase);
        }
        return status;
    }

    public static RefactoringStatus checkTypeName(String name) {
        return Checks.checkName(name, JavaScriptConventions.validateJavaScriptTypeName(name));
    }

    public static RefactoringStatus checkPackageName(String name) {
        return Checks.checkName(name, JavaScriptConventions.validatePackageName(name));
    }

    public static RefactoringStatus checkCompilationUnitName(String name) {
        return Checks.checkName(name, JavaScriptConventions.validateCompilationUnitName(name));
    }

    public static RefactoringStatus checkCompilationUnitNewName(IJavaScriptUnit cu, String newName) {
        String newCUName = JavaModelUtil.getRenamedCUName(cu, newName);
        if (Checks.resourceExists(RenameResourceChange.renamedResourcePath(cu.getResource().getFullPath(), newCUName))) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.Checks_cu_name_used, newName));
        }
        return new RefactoringStatus();
    }

    public static boolean startsWithUpperCase(String s) {
        if (s == null) {
            return false;
        }
        if ("".equals(s)) {
            return false;
        }
        return s.charAt(0) == Character.toUpperCase(s.charAt(0));
    }

    public static boolean startsWithLowerCase(String s) {
        if (s == null) {
            return false;
        }
        if ("".equals(s)) {
            return false;
        }
        return s.charAt(0) == Character.toLowerCase(s.charAt(0));
    }

    public static boolean resourceExists(IPath resourcePath) {
        return ResourcesPlugin.getWorkspace().getRoot().findMember(resourcePath) != null;
    }

    public static boolean isTopLevel(IType type) {
        return type.getDeclaringType() == null;
    }

    public static boolean isAnonymous(IType type) throws JavaScriptModelException {
        return type.isAnonymous();
    }

    public static boolean isTopLevelType(IMember member) {
        return member.getElementType() == 7 && Checks.isTopLevel((IType)member);
    }

    public static boolean isInsideLocalType(IType type) throws JavaScriptModelException {
        while (type != null) {
            if (type.isLocal()) {
                return true;
            }
            type = type.getDeclaringType();
        }
        return false;
    }

    public static boolean isAlreadyNamed(IJavaScriptElement element, String name) {
        return name.equals(element.getElementName());
    }

    public static RefactoringStatus checkMethodInType(ITypeBinding type, String methodName, ITypeBinding[] parameters) {
        IFunctionBinding method;
        RefactoringStatus result = new RefactoringStatus();
        if (methodName.equals(type.getName())) {
            result.addWarning(RefactoringCoreMessages.Checks_methodName_constructor);
        }
        if ((method = Bindings.findMethodInType(type, methodName, parameters)) != null) {
            result.addError(Messages.format(RefactoringCoreMessages.Checks_methodName_exists, new Object[]{methodName, type.getName()}), JavaStatusContext.create(method));
        }
        return result;
    }

    public static RefactoringStatus checkMethodInHierarchy(ITypeBinding type, String methodName, ITypeBinding returnType, ITypeBinding[] parameters) {
        RefactoringStatus result = new RefactoringStatus();
        IFunctionBinding method = Bindings.findMethodInHierarchy(type, methodName, parameters);
        if (method != null) {
            boolean returnTypeClash = false;
            ITypeBinding methodReturnType = method.getReturnType();
            if (returnType != null && methodReturnType != null) {
                String returnTypeKey = returnType.getKey();
                String methodReturnTypeKey = methodReturnType.getKey();
                if (returnTypeKey == null && methodReturnTypeKey == null) {
                    returnTypeClash = returnType != methodReturnType;
                } else if (returnTypeKey != null && methodReturnTypeKey != null) {
                    returnTypeClash = !returnTypeKey.equals(methodReturnTypeKey);
                }
            }
            ITypeBinding dc = method.getDeclaringClass();
            if (returnTypeClash) {
                result.addError(Messages.format(RefactoringCoreMessages.Checks_methodName_returnTypeClash, new Object[]{methodName, dc.getName()}), JavaStatusContext.create(method));
            } else {
                result.addError(Messages.format(RefactoringCoreMessages.Checks_methodName_overrides, new Object[]{methodName, dc.getName()}), JavaStatusContext.create(method));
            }
        }
        return result;
    }

    public static boolean isExtractableExpression(ASTNode[] selectedNodes, ASTNode coveringNode) {
        ASTNode node = coveringNode;
        if (selectedNodes != null && selectedNodes.length == 1) {
            node = selectedNodes[0];
        }
        return Checks.isExtractableExpression(node);
    }

    public static boolean isExtractableExpression(ASTNode node) {
        if (!(node instanceof Expression)) {
            return false;
        }
        if (node instanceof Name) {
            IBinding binding = ((Name)node).resolveBinding();
            return !(binding instanceof ITypeBinding);
        }
        return true;
    }

    public static boolean isInsideJavadoc(ASTNode node) {
        do {
            if (node.getNodeType() != 29) continue;
            return true;
        } while ((node = node.getParent()) != null);
        return false;
    }

    public static RefactoringStatus checkName(String name, IStatus status) {
        RefactoringStatus result = new RefactoringStatus();
        if ("".equals(name)) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.Checks_Choose_name);
        }
        if (status.isOK()) {
            return result;
        }
        switch (status.getSeverity()) {
            case 4: {
                return RefactoringStatus.createFatalErrorStatus((String)status.getMessage());
            }
            case 2: {
                return RefactoringStatus.createWarningStatus((String)status.getMessage());
            }
            case 1: {
                return RefactoringStatus.createInfoStatus((String)status.getMessage());
            }
        }
        return new RefactoringStatus();
    }

    public static IFunction findMethod(String name, int parameterCount, boolean isConstructor, IType type) throws JavaScriptModelException {
        return Checks.findMethod(name, parameterCount, isConstructor, type.getFunctions());
    }

    public static IFunction findMethod(IFunction method, IType type) throws JavaScriptModelException {
        return Checks.findMethod(method.getElementName(), method.getParameterTypes().length, method.isConstructor(), type.getFunctions());
    }

    public static IFunction findMethod(IFunction method, IFunction[] methods) throws JavaScriptModelException {
        return Checks.findMethod(method.getElementName(), method.getParameterTypes().length, method.isConstructor(), methods);
    }

    public static IFunction findMethod(String name, int parameters, boolean isConstructor, IFunction[] methods) throws JavaScriptModelException {
        int i = methods.length - 1;
        while (i >= 0) {
            IFunction curr = methods[i];
            if (name.equals(curr.getElementName()) && isConstructor == curr.isConstructor() && parameters == curr.getParameterTypes().length) {
                return curr;
            }
            --i;
        }
        return null;
    }

    public static IFunction findSimilarMethod(IFunction method, IType type) throws JavaScriptModelException {
        return Checks.findSimilarMethod(method, type.getFunctions());
    }

    public static IFunction findSimilarMethod(IFunction method, IFunction[] methods) throws JavaScriptModelException {
        boolean isConstructor = method.isConstructor();
        int i = 0;
        while (i < methods.length) {
            IFunction otherMethod = methods[i];
            if (otherMethod.isConstructor() == isConstructor && method.isSimilar(otherMethod)) {
                return otherMethod;
            }
            ++i;
        }
        return null;
    }

    public static boolean compareParamTypes(String[] paramTypes1, String[] paramTypes2) {
        if (paramTypes1.length == paramTypes2.length) {
            int i = 0;
            while (i < paramTypes1.length) {
                String t2;
                String t1 = Signature.getSimpleName(Signature.toString(paramTypes1[i]));
                if (!t1.equals(t2 = Signature.getSimpleName(Signature.toString(paramTypes2[i])))) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public static RefactoringStatus checkIfCuBroken(IMember member) throws JavaScriptModelException {
        IJavaScriptUnit cu = (IJavaScriptUnit)JavaScriptCore.create(member.getJavaScriptUnit().getResource());
        if (cu == null) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.Checks_cu_not_created);
        }
        if (!cu.isStructureKnown()) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.Checks_cu_not_parsed);
        }
        return new RefactoringStatus();
    }

    public static SearchResultGroup[] excludeCompilationUnits(SearchResultGroup[] grouped, RefactoringStatus status) throws JavaScriptModelException {
        ArrayList<SearchResultGroup> result = new ArrayList<SearchResultGroup>();
        boolean wasEmpty = grouped.length == 0;
        int i = 0;
        while (i < grouped.length) {
            IResource resource = grouped[i].getResource();
            IJavaScriptElement element = JavaScriptCore.create(resource);
            if (element instanceof IJavaScriptUnit) {
                IJavaScriptUnit cu = (IJavaScriptUnit)JavaScriptCore.create(resource);
                if (!cu.isStructureKnown()) {
                    String path = Checks.getFullPath(cu);
                    status.addError(Messages.format(RefactoringCoreMessages.Checks_cannot_be_parsed, path));
                } else {
                    result.add(grouped[i]);
                }
            }
            ++i;
        }
        if (!wasEmpty && result.isEmpty()) {
            status.addFatalError(RefactoringCoreMessages.Checks_all_excluded);
        }
        return result.toArray(new SearchResultGroup[result.size()]);
    }

    private static final String getFullPath(IJavaScriptUnit cu) {
        Assert.isTrue((boolean)cu.exists());
        return cu.getResource().getFullPath().toString();
    }

    public static RefactoringStatus checkCompileErrorsInAffectedFiles(SearchResultGroup[] grouped) throws JavaScriptModelException {
        RefactoringStatus result = new RefactoringStatus();
        int i = 0;
        while (i < grouped.length) {
            Checks.checkCompileErrorsInAffectedFile(result, grouped[i].getResource());
            ++i;
        }
        return result;
    }

    public static void checkCompileErrorsInAffectedFile(RefactoringStatus result, IResource resource) throws JavaScriptModelException {
        if (Checks.hasCompileErrors(resource)) {
            result.addWarning(Messages.format(RefactoringCoreMessages.Checks_cu_has_compile_errors, resource.getFullPath().makeRelative()));
        }
    }

    public static RefactoringStatus checkCompileErrorsInAffectedFiles(SearchResultGroup[] references, IResource declaring) throws JavaScriptModelException {
        RefactoringStatus result = new RefactoringStatus();
        int i = 0;
        while (i < references.length) {
            IResource resource = references[i].getResource();
            if (resource.equals((Object)declaring)) {
                declaring = null;
            }
            Checks.checkCompileErrorsInAffectedFile(result, resource);
            ++i;
        }
        if (declaring != null) {
            Checks.checkCompileErrorsInAffectedFile(result, declaring);
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean hasCompileErrors(IResource resource) throws JavaScriptModelException {
        try {
            IMarker[] problemMarkers = resource.findMarkers("org.eclipse.wst.jsdt.core.problem", true, 2);
            int i = 0;
            while (true) {
                if (i >= problemMarkers.length) {
                    return false;
                }
                if (problemMarkers[i].getAttribute("severity", -1) == 2) {
                    return true;
                }
                ++i;
            }
        }
        catch (JavaScriptModelException e) {
            throw e;
        }
        catch (CoreException e) {
            throw new JavaScriptModelException(e);
        }
    }

    public static boolean isReadOnly(Object element) throws JavaScriptModelException {
        if (element instanceof IResource) {
            return Checks.isReadOnly((IResource)element);
        }
        if (element instanceof IJavaScriptElement) {
            if (element instanceof IPackageFragmentRoot && Checks.isClasspathDelete((IPackageFragmentRoot)element)) {
                return false;
            }
            return Checks.isReadOnly(((IJavaScriptElement)element).getResource());
        }
        Assert.isTrue((boolean)false, (String)"not expected to get here");
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isReadOnly(IResource res) throws JavaScriptModelException {
        ResourceAttributes attributes = res.getResourceAttributes();
        if (attributes != null && attributes.isReadOnly()) {
            return true;
        }
        if (!(res instanceof IContainer)) {
            return false;
        }
        IContainer container = (IContainer)res;
        try {
            IResource[] children = container.members();
            int i = 0;
            while (true) {
                if (i >= children.length) {
                    return false;
                }
                if (Checks.isReadOnly(children[i])) {
                    return true;
                }
                ++i;
            }
        }
        catch (JavaScriptModelException e) {
            throw e;
        }
        catch (CoreException e) {
            throw new JavaScriptModelException(e);
        }
    }

    public static boolean isClasspathDelete(IPackageFragmentRoot pkgRoot) {
        IResource res = pkgRoot.getResource();
        if (res == null) {
            return true;
        }
        IProject definingProject = res.getProject();
        if (res.getParent() != null && pkgRoot.isArchive() && !res.getParent().equals((Object)definingProject)) {
            return true;
        }
        IProject occurringProject = pkgRoot.getJavaScriptProject().getProject();
        return !definingProject.equals((Object)occurringProject);
    }

    public static RefactoringStatus validateModifiesFiles(IFile[] filesToModify, Object context) {
        RefactoringStatus result = new RefactoringStatus();
        IStatus status = Resources.checkInSync((IResource[])filesToModify);
        if (!status.isOK()) {
            result.merge(RefactoringStatus.create((IStatus)status));
        }
        if (!(status = Resources.makeCommittable((IResource[])filesToModify, context)).isOK()) {
            result.merge(RefactoringStatus.create((IStatus)status));
            if (!result.hasFatalError()) {
                result.addFatalError(RefactoringCoreMessages.Checks_validateEdit);
            }
        }
        return result;
    }

    public static RefactoringStatus validateEdit(IJavaScriptUnit unit, Object context) {
        IResource resource = unit.getPrimary().getResource();
        RefactoringStatus result = new RefactoringStatus();
        if (resource == null) {
            return result;
        }
        IStatus status = Resources.checkInSync(resource);
        if (!status.isOK()) {
            result.merge(RefactoringStatus.create((IStatus)status));
        }
        if (!(status = Resources.makeCommittable(resource, context)).isOK()) {
            result.merge(RefactoringStatus.create((IStatus)status));
            if (!result.hasFatalError()) {
                result.addFatalError(RefactoringCoreMessages.Checks_validateEdit);
            }
        }
        return result;
    }

    public static RefactoringStatus checkAvailability(IJavaScriptElement javaElement) throws JavaScriptModelException {
        RefactoringStatus result = new RefactoringStatus();
        if (!javaElement.exists()) {
            result.addFatalError(Messages.format(RefactoringCoreMessages.Refactoring_not_in_model, javaElement.getElementName()));
        }
        if (javaElement.isReadOnly()) {
            result.addFatalError(Messages.format(RefactoringCoreMessages.Refactoring_read_only, javaElement.getElementName()));
        }
        if (javaElement.exists() && !javaElement.isStructureKnown()) {
            result.addFatalError(Messages.format(RefactoringCoreMessages.Refactoring_unknown_structure, javaElement.getElementName()));
        }
        if (javaElement instanceof IMember && ((IMember)javaElement).isBinary()) {
            result.addFatalError(Messages.format(RefactoringCoreMessages.Refactoring_binary, javaElement.getElementName()));
        }
        return result;
    }

    public static boolean isAvailable(IJavaScriptElement javaElement) throws JavaScriptModelException {
        if (javaElement == null) {
            return false;
        }
        if (!javaElement.exists()) {
            return false;
        }
        if (javaElement.isReadOnly()) {
            return false;
        }
        if (!(javaElement instanceof IJavaScriptProject || javaElement instanceof ILocalVariable || javaElement.isStructureKnown())) {
            return false;
        }
        return !(javaElement instanceof IMember) || !((IMember)javaElement).isBinary();
    }

    public static IType findTypeInPackage(IPackageFragment pack, String name) throws JavaScriptModelException {
        Assert.isTrue((boolean)pack.exists());
        Assert.isTrue((!pack.isReadOnly() ? 1 : 0) != 0);
        if (name.indexOf(".") != -1) {
            name = name.substring(0, name.indexOf("."));
        }
        IJavaScriptUnit[] cus = pack.getJavaScriptUnits();
        int i = 0;
        while (i < cus.length) {
            if (cus[i].getType(name).exists()) {
                return cus[i].getType(name);
            }
            ++i;
        }
        return null;
    }

    public static RefactoringStatus checkTempName(String newName) {
        RefactoringStatus result = Checks.checkIdentifier(newName);
        if (result.hasFatalError()) {
            return result;
        }
        if (!Checks.startsWithLowerCase(newName)) {
            result.addWarning(RefactoringCoreMessages.ExtractTempRefactoring_convention);
        }
        return result;
    }

    public static RefactoringStatus checkEnumConstantName(String newName) {
        RefactoringStatus result = Checks.checkFieldName(newName);
        if (result.hasFatalError()) {
            return result;
        }
        int i = 0;
        while (i < newName.length()) {
            char c = newName.charAt(i);
            if (Character.isLetter(c) && !Character.isUpperCase(c)) {
                result.addWarning(RefactoringCoreMessages.RenameEnumConstRefactoring_convention);
                break;
            }
            ++i;
        }
        return result;
    }

    public static RefactoringStatus checkConstantName(String newName) {
        RefactoringStatus result = Checks.checkFieldName(newName);
        if (result.hasFatalError()) {
            return result;
        }
        int i = 0;
        while (i < newName.length()) {
            char c = newName.charAt(i);
            if (Character.isLetter(c) && !Character.isUpperCase(c)) {
                result.addWarning(RefactoringCoreMessages.ExtractConstantRefactoring_convention);
                break;
            }
            ++i;
        }
        return result;
    }

    public static boolean isException(IType iType, IProgressMonitor pm) throws JavaScriptModelException {
        try {
            if (!iType.isClass()) {
                return false;
            }
            IType[] superTypes = iType.newSupertypeHierarchy(pm).getAllSuperclasses(iType);
            int i = 0;
            while (i < superTypes.length) {
                if ("java.lang.Throwable".equals(superTypes[i].getFullyQualifiedName())) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        finally {
            pm.done();
        }
    }

    public static int checkExpressionIsRValue(Expression e) {
        if (e instanceof Name && !(((Name)e).resolveBinding() instanceof IVariableBinding)) {
            return 1;
        }
        ITypeBinding tb = e.resolveTypeBinding();
        if (tb == null) {
            return 1;
        }
        if (tb.getName().equals("void")) {
            return 2;
        }
        return 0;
    }

    public static boolean isDeclaredIn(VariableDeclaration tempDeclaration, Class astNodeClass) {
        ASTNode initializer = ASTNodes.getParent((ASTNode)tempDeclaration, astNodeClass);
        if (initializer == null) {
            return false;
        }
        ASTNode anonymous = ASTNodes.getParent((ASTNode)tempDeclaration, AnonymousClassDeclaration.class);
        if (anonymous == null) {
            return true;
        }
        return !ASTNodes.isParent(anonymous, initializer);
    }
}

