/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.codemanipulation;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.wst.jsdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.FunctionDeclaration;
import org.eclipse.wst.jsdt.core.dom.IFunctionBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.wst.jsdt.core.dom.rewrite.ListRewrite;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.CodeGenerationMessages;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.ContextSensitiveImportRewriteContext;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.StubUtility2;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.ui.preferences.JavaPreferencesSettings;

public final class AddUnimplementedMethodsOperation
implements IWorkspaceRunnable {
    private final boolean fApply;
    private String[] fCreatedImports;
    private final List fCreatedMethods = new ArrayList();
    private final boolean fImports;
    private final int fInsertPos;
    private final IFunctionBinding[] fMethodsToImplement;
    private final boolean fSave;
    private boolean fDoCreateComments;
    private final ITypeBinding fType;
    private final JavaScriptUnit fASTRoot;

    public AddUnimplementedMethodsOperation(JavaScriptUnit astRoot, ITypeBinding type, IFunctionBinding[] methodsToImplement, int insertPos, boolean imports, boolean apply, boolean save) {
        if (astRoot == null || !(astRoot.getJavaElement() instanceof IJavaScriptUnit)) {
            throw new IllegalArgumentException("AST must not be null and has to be created from a IJavaScriptUnit");
        }
        if (type == null) {
            throw new IllegalArgumentException("The type must not be null");
        }
        ASTNode node = astRoot.findDeclaringNode(type);
        if (!(node instanceof AnonymousClassDeclaration) && !(node instanceof AbstractTypeDeclaration)) {
            throw new IllegalArgumentException("type has to map to a type declaration in the AST");
        }
        this.fType = type;
        this.fInsertPos = insertPos;
        this.fASTRoot = astRoot;
        this.fMethodsToImplement = methodsToImplement;
        this.fSave = save;
        this.fApply = apply;
        this.fImports = imports;
        this.fDoCreateComments = StubUtility.doAddComments(astRoot.getJavaElement().getJavaScriptProject());
    }

    public void setCreateComments(boolean createComments) {
        this.fDoCreateComments = createComments;
    }

    public final String[] getCreatedImports() {
        if (this.fCreatedImports != null) {
            return this.fCreatedImports;
        }
        return new String[0];
    }

    public final String[] getCreatedMethods() {
        String[] keys = new String[this.fCreatedMethods.size()];
        this.fCreatedMethods.toArray(keys);
        return keys;
    }

    public final ISchedulingRule getSchedulingRule() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    public final void run(IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            AbstractTypeDeclaration firstTypeDecl;
            monitor.beginTask("", 2);
            monitor.setTaskName(CodeGenerationMessages.AddUnimplementedMethodsOperation_description);
            this.fCreatedMethods.clear();
            IJavaScriptUnit cu = (IJavaScriptUnit)this.fASTRoot.getJavaElement();
            AST ast = this.fASTRoot.getAST();
            ASTRewrite astRewrite = ASTRewrite.create(ast);
            ImportRewrite importRewrite = StubUtility.createImportRewrite(this.fASTRoot, true);
            ITypeBinding currTypeBinding = this.fType;
            ListRewrite memberRewriter = null;
            ASTNode node = this.fASTRoot.findDeclaringNode(currTypeBinding);
            if (node instanceof AnonymousClassDeclaration) {
                memberRewriter = astRewrite.getListRewrite(node, AnonymousClassDeclaration.BODY_DECLARATIONS_PROPERTY);
            } else if (node instanceof AbstractTypeDeclaration) {
                ChildListPropertyDescriptor property = ((AbstractTypeDeclaration)node).getBodyDeclarationsProperty();
                memberRewriter = astRewrite.getListRewrite(node, property);
            } else {
                throw new IllegalArgumentException();
            }
            CodeGenerationSettings settings = JavaPreferencesSettings.getCodeGenerationSettings(cu.getJavaScriptProject());
            settings.createComments = this.fDoCreateComments;
            ASTNode insertion = this.getNodeToInsertBefore(memberRewriter);
            IFunctionBinding[] methodsToImplement = this.fMethodsToImplement;
            if (methodsToImplement == null) {
                methodsToImplement = StubUtility2.getUnimplementedMethods(currTypeBinding);
            }
            ContextSensitiveImportRewriteContext context = null;
            int insertionPosition = this.fInsertPos;
            if (insertionPosition == -1 && this.fASTRoot.types().size() > 0 && (insertionPosition = (firstTypeDecl = (AbstractTypeDeclaration)this.fASTRoot.types().get(0)).getStartPosition()) != -1) {
                context = new ContextSensitiveImportRewriteContext(this.fASTRoot, insertionPosition, importRewrite);
            }
            int i = 0;
            while (i < methodsToImplement.length) {
                IFunctionBinding curr = methodsToImplement[i];
                FunctionDeclaration stub = StubUtility2.createImplementationStub(cu, astRewrite, importRewrite, ast, curr, currTypeBinding.getName(), settings, false, context);
                if (stub != null) {
                    this.fCreatedMethods.add(curr.getKey());
                    if (insertion != null) {
                        memberRewriter.insertBefore(stub, insertion, null);
                    } else {
                        memberRewriter.insertLast(stub, null);
                    }
                }
                ++i;
            }
            MultiTextEdit edit = new MultiTextEdit();
            TextEdit importEdits = importRewrite.rewriteImports((IProgressMonitor)new SubProgressMonitor(monitor, 1));
            this.fCreatedImports = importRewrite.getCreatedImports();
            if (this.fImports) {
                edit.addChild(importEdits);
            }
            edit.addChild(astRewrite.rewriteAST());
            if (this.fApply) {
                JavaModelUtil.applyEdit(cu, (TextEdit)edit, this.fSave, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
        }
        finally {
            monitor.done();
        }
    }

    private ASTNode getNodeToInsertBefore(ListRewrite rewriter) {
        if (this.fInsertPos != -1) {
            List members = rewriter.getOriginalList();
            int i = 0;
            while (i < members.size()) {
                ASTNode curr = (ASTNode)members.get(i);
                if (curr.getStartPosition() >= this.fInsertPos) {
                    return curr;
                }
                ++i;
            }
        }
        return null;
    }
}

