/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.css.core.internal.document;

import java.util.ArrayList;
import org.eclipse.wst.css.core.internal.contentmodel.PropCMProperty;
import org.eclipse.wst.css.core.internal.document.CSSDeclarationItemParser;
import org.eclipse.wst.css.core.internal.document.CSSNodeImpl;
import org.eclipse.wst.css.core.internal.document.CSSPrimitiveValueImpl;
import org.eclipse.wst.css.core.internal.document.CSSStructuredDocumentRegionContainer;
import org.eclipse.wst.css.core.internal.formatter.CSSSourceFormatterFactory;
import org.eclipse.wst.css.core.internal.formatter.CSSSourceGenerator;
import org.eclipse.wst.css.core.internal.formatter.StyleDeclItemFormatter;
import org.eclipse.wst.css.core.internal.parser.CSSSourceParser;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSNode;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSPrimitiveValue;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSStyleDeclItem;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.text.TextRegionListImpl;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSValue;

class CSSStyleDeclItemImpl
extends CSSStructuredDocumentRegionContainer
implements ICSSStyleDeclItem {
    private String fPropertyName;

    CSSStyleDeclItemImpl(CSSStyleDeclItemImpl that) {
        super(that);
        this.fPropertyName = that.fPropertyName;
    }

    CSSStyleDeclItemImpl(String propertyName) {
        this.fPropertyName = propertyName;
    }

    @Override
    public ICSSPrimitiveValue appendValue(ICSSPrimitiveValue value) throws DOMException {
        return this.insertValueBefore(value, null);
    }

    @Override
    public ICSSNode cloneNode(boolean deep) {
        CSSStyleDeclItemImpl cloned = new CSSStyleDeclItemImpl(this);
        if (deep) {
            this.cloneChildNodes(cloned, deep);
        }
        return cloned;
    }

    String generateValueSource() {
        CSSSourceGenerator formatter = CSSSourceFormatterFactory.getInstance().getSourceFormatter(this);
        if (formatter != null && formatter instanceof StyleDeclItemFormatter) {
            return ((StyleDeclItemFormatter)formatter).formatValue(this).toString();
        }
        return "";
    }

    @Override
    public CSSValue getCSSValue() {
        int nValue = this.getLength();
        if (nValue <= 0) {
            return null;
        }
        if (nValue == 1) {
            return this.item(0);
        }
        return this;
    }

    @Override
    public String getCSSValueText() {
        if (this.getFirstChild() == null) {
            return "";
        }
        ICSSNode child = this.getFirstChild();
        while (child != null) {
            if (((IndexedRegion)((Object)child)).getEndOffset() <= 0) {
                return this.generateValueSource();
            }
            child = child.getNextSibling();
        }
        IStructuredDocumentRegion node = this.getFirstStructuredDocumentRegion();
        int start = ((IndexedRegion)((Object)this.getFirstChild())).getStartOffset() - node.getStartOffset();
        int end = ((IndexedRegion)((Object)this.getLastChild())).getEndOffset() - node.getStartOffset();
        return node.getText().substring(start, end);
    }

    @Override
    public short getCssValueType() {
        return 2;
    }

    @Override
    public int getLength() {
        int i = 0;
        ICSSNode node = this.getFirstChild();
        while (node != null) {
            if (node instanceof CSSPrimitiveValueImpl) {
                ++i;
            }
            node = node.getNextSibling();
        }
        return i;
    }

    @Override
    public short getNodeType() {
        return 9;
    }

    @Override
    public String getPriority() {
        return this.getAttribute("important");
    }

    @Override
    public String getPropertyName() {
        String name = this.fPropertyName.trim();
        return PropCMProperty.getInstanceOf(name) != null ? this.fPropertyName.trim().toLowerCase() : name;
    }

    ICSSPrimitiveValue insertValueBefore(ICSSPrimitiveValue newValue, ICSSPrimitiveValue refValue) {
        CSSNodeImpl node = this.insertBefore((CSSNodeImpl)((Object)newValue), (CSSNodeImpl)((Object)refValue));
        return (ICSSPrimitiveValue)((Object)node);
    }

    @Override
    public CSSValue item(int index) {
        int i = 0;
        ICSSNode node = this.getFirstChild();
        while (node != null) {
            if (node instanceof CSSPrimitiveValueImpl && i++ == index) {
                return (CSSValue)((Object)node);
            }
            node = node.getNextSibling();
        }
        return null;
    }

    @Override
    public ICSSPrimitiveValue removeValue(ICSSPrimitiveValue value) throws DOMException {
        CSSNodeImpl node = this.removeChild((CSSNodeImpl)((Object)value));
        return (ICSSPrimitiveValue)((Object)node);
    }

    @Override
    public ICSSPrimitiveValue replaceValue(ICSSPrimitiveValue newValue, ICSSPrimitiveValue oldValue) throws DOMException {
        if (oldValue == null) {
            return newValue;
        }
        if (newValue != null) {
            this.insertValueBefore(newValue, oldValue);
        }
        return this.removeValue(oldValue);
    }

    public void setCssValueText(String value) throws DOMException {
        ICSSNode child = this.getFirstChild();
        while (child != null) {
            ICSSNode next = child.getNextSibling();
            if (child instanceof ICSSPrimitiveValue) {
                this.removeChild((CSSNodeImpl)child);
            }
            child = next;
        }
        this.setCssValueTextCore(value);
    }

    private void setCssValueTextCore(String value) throws DOMException {
        CSSSourceParser parser = new CSSSourceParser();
        parser.setParserMode(2);
        parser.reset(value);
        IStructuredDocumentRegion node = parser.getDocumentRegions();
        if (node == null) {
            return;
        }
        if (node.getNext() != null) {
            throw new DOMException(13, "");
        }
        CSSDeclarationItemParser itemParser = new CSSDeclarationItemParser(this.getOwnerDocument());
        itemParser.setStructuredDocumentTemporary(true);
        TextRegionListImpl nodeList = new TextRegionListImpl(node.getRegions());
        ArrayList<String> nodeValuesList = new ArrayList<String>();
        int i = 0;
        while (i < nodeList.size()) {
            ITextRegion textRegion = nodeList.get(i);
            nodeValuesList.add(value.substring(textRegion.getStart(), textRegion.getTextEnd()));
            ++i;
        }
        itemParser.setupValues(this, node, nodeList, nodeValuesList);
    }

    @Override
    public void setPriority(String newPriority) throws DOMException {
        this.setAttribute("important", newPriority);
    }
}

