/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.extra.eclipse.wtp.html;

import com.diffplug.spotless.extra.eclipse.wtp.html.StructuredDocumentProcessor;
import java.util.function.BiFunction;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.wst.jsdt.core.formatter.CodeFormatter;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;

public class JsRegionProcessor
extends StructuredDocumentProcessor.RegionProcessor<CodeFormatter> {
    public JsRegionProcessor(IStructuredDocument document, ITypedRegion scriptRegion, String htmlIndent) {
        super(document, scriptRegion, htmlIndent);
    }

    @Override
    protected void applyFirst(CodeFormatter formatter) throws MalformedTreeException, BadLocationException {
        MultiTextEdit modifications = new MultiTextEdit();
        String jsSource = this.document.get(this.region.getOffset(), this.region.getLength());
        TextEdit jsEdit = formatter.format(8, jsSource, 0, jsSource.length(), this.indentationLevel + 1, "\n");
        if (null != jsEdit) {
            jsEdit.moveTree(this.region.getOffset());
            modifications.addChild(jsEdit);
        }
        modifications.apply((IDocument)this.document);
    }

    @Override
    protected void applySecond(CodeFormatter formatter) throws MalformedTreeException, BadLocationException {
        MultiTextEdit modifications = new MultiTextEdit();
        int regionEnd = this.region.getOffset() + this.region.getLength();
        regionEnd += this.fixDelimiter(modifications, this.region.getOffset(), false);
        modifications.apply((IDocument)this.document);
        modifications.removeChildren();
        this.fixTagIndent(modifications, regionEnd += this.fixDelimiter(modifications, this.region.getOffset() + this.region.getLength() - 1, true), formatter.createIndentationString(this.indentationLevel));
        modifications.apply((IDocument)this.document);
    }

    public static BiFunction<IStructuredDocument, ITypedRegion, JsRegionProcessor> createFactory(final String htmlIndent) {
        return new BiFunction<IStructuredDocument, ITypedRegion, JsRegionProcessor>(){

            @Override
            public JsRegionProcessor apply(IStructuredDocument document, ITypedRegion region) {
                return new JsRegionProcessor(document, region, htmlIndent);
            }
        };
    }
}

