/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.extra.eclipse.wtp;

import com.diffplug.spotless.extra.eclipse.base.SpotlessEclipseConfig;
import com.diffplug.spotless.extra.eclipse.base.SpotlessEclipseCoreConfig;
import com.diffplug.spotless.extra.eclipse.base.SpotlessEclipseFramework;
import com.diffplug.spotless.extra.eclipse.base.SpotlessEclipsePluginConfig;
import com.diffplug.spotless.extra.eclipse.base.SpotlessEclipseServiceConfig;
import com.diffplug.spotless.extra.eclipse.wtp.sse.PluginPreferences;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.TypedPosition;
import org.eclipse.jface.text.formatter.IFormattingContext;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.ToolFactory;
import org.eclipse.wst.jsdt.core.formatter.CodeFormatter;
import org.eclipse.wst.jsdt.core.formatter.DefaultCodeFormatterConstants;
import org.eclipse.wst.jsdt.internal.ui.text.FastJavaPartitionScanner;
import org.eclipse.wst.jsdt.internal.ui.text.comment.CommentFormattingContext;
import org.eclipse.wst.jsdt.internal.ui.text.comment.CommentFormattingStrategy;
import org.osgi.framework.BundleActivator;

public class EclipseJsFormatterStepImpl {
    private static final String[] COMMENT_TYPES = new String[]{"__java_javadoc", "__java_multiline_comment", "__java_singleline_comment", "__java_string", "__java_character"};
    private static final Map<String, String> OPTION_2_COMMENT_TYPE = Collections.unmodifiableMap(Stream.of(new AbstractMap.SimpleEntry<String, String>("org.eclipse.wst.jsdt.core.formatter.comment.format_line_comments", "__java_singleline_comment"), new AbstractMap.SimpleEntry<String, String>("org.eclipse.wst.jsdt.core.formatter.comment.format_block_comments", "__java_multiline_comment"), new AbstractMap.SimpleEntry<String, String>("org.eclipse.wst.jsdt.core.formatter.comment.format_javadoc_comments", "__java_javadoc")).collect(Collectors.toMap(e -> (String)e.getKey(), e -> (String)e.getValue())));
    private final CodeFormatter formatter;
    private final Hashtable<?, ?> options;
    private final Set<String> commentTypesToBeFormatted;

    public EclipseJsFormatterStepImpl(Properties properties) throws Exception {
        SpotlessEclipseFramework.setup((SpotlessEclipseConfig)new FrameworkConfig(properties));
        PluginPreferences.assertNoChanges(JavaScriptCore.getPlugin(), properties);
        this.options = JavaScriptCore.getOptions();
        this.commentTypesToBeFormatted = OPTION_2_COMMENT_TYPE.entrySet().stream().filter(x -> "true".equals(this.options.get(x.getKey()))).map(x -> (String)x.getValue()).collect(Collectors.toSet());
        this.formatter = ToolFactory.createCodeFormatter(this.options, 1);
    }

    public String format(String raw) throws Exception {
        raw = this.formatComments(raw);
        Document doc = new Document(raw);
        TextEdit edit = this.formatter.format(8, raw, 0, raw.length(), 0, "\n");
        if (edit == null) {
            throw new IllegalArgumentException("Invalid JavaScript syntax for formatting.");
        }
        edit.apply((IDocument)doc);
        return doc.get();
    }

    private String formatComments(String raw) {
        Document doc = new Document(raw);
        FastPartitioner commentPartitioner = new FastPartitioner((IPartitionTokenScanner)new FastJavaPartitionScanner(), COMMENT_TYPES);
        doc.setDocumentPartitioner("___java_partitioning", (IDocumentPartitioner)commentPartitioner);
        commentPartitioner.connect((IDocument)doc);
        CommentFormattingStrategy commentFormatter = new CommentFormattingStrategy();
        CommentFormattingContext context = new CommentFormattingContext();
        context.setProperty("formatting.context.preferences", this.options);
        context.setProperty("formatting.context.document", Boolean.TRUE);
        context.setProperty("formatting.context.medium", doc);
        try {
            ITypedRegion[] regions = TextUtilities.computePartitioning((IDocument)doc, (String)"___java_partitioning", (int)0, (int)doc.getLength(), (boolean)false);
            MultiTextEdit resultEdit = new MultiTextEdit();
            Arrays.asList(regions).stream().filter(reg -> this.commentTypesToBeFormatted.contains(reg.getType())).forEach(arg_0 -> EclipseJsFormatterStepImpl.lambda$formatComments$5((IFormattingContext)context, commentFormatter, resultEdit, arg_0));
            resultEdit.apply((IDocument)doc);
            return doc.get();
        }
        catch (BadLocationException e) {
            return raw;
        }
    }

    private static /* synthetic */ void lambda$formatComments$5(IFormattingContext context, CommentFormattingStrategy commentFormatter, MultiTextEdit resultEdit, ITypedRegion region) {
        TypedPosition typedPosition = new TypedPosition(region.getOffset(), region.getLength(), region.getType());
        context.setProperty((Object)"formatting.context.partition", (Object)typedPosition);
        commentFormatter.formatterStarts(context);
        TextEdit edit = commentFormatter.calculateTextEdit();
        commentFormatter.formatterStops();
        if (null != edit && edit.hasChildren()) {
            resultEdit.addChild(edit);
        }
    }

    static class FrameworkConfig
    implements SpotlessEclipseConfig {
        private final Properties properties;

        FrameworkConfig(Properties properties) {
            this.properties = properties;
        }

        public void registerServices(SpotlessEclipseServiceConfig config) {
            config.applyDefault();
            config.useSlf4J(this.getClass().getPackage().getName());
        }

        public void registerBundles(SpotlessEclipseCoreConfig config) {
            FrameworkConfig.registerNonHeadlessBundles(config);
        }

        static void registerNonHeadlessBundles(SpotlessEclipseCoreConfig config) {
            config.add((Enum)SpotlessEclipseFramework.DefaultBundles.PLATFORM, 32);
            config.add((Enum[])new SpotlessEclipseFramework.DefaultBundles[]{SpotlessEclipseFramework.DefaultBundles.REGISTRY, SpotlessEclipseFramework.DefaultBundles.PREFERENCES, SpotlessEclipseFramework.DefaultBundles.COMMON});
        }

        public void activatePlugins(SpotlessEclipsePluginConfig config) {
            config.applyDefault();
            FrameworkConfig.activateJsPlugins(config);
        }

        static void activateJsPlugins(SpotlessEclipsePluginConfig config) {
            config.add(EFS.class);
            config.add((BundleActivator)new JavaScriptCore());
        }

        public void customize() {
            PluginPreferences.store(JavaScriptCore.getPlugin(), this.properties);
            Hashtable options = JavaScriptCore.getDefaultOptions();
            options.putAll(DefaultCodeFormatterConstants.getJSLintConventionsSettings());
            options.putAll(new HashMap<Object, Object>(this.properties));
            JavaScriptCore.setOptions(options);
        }
    }
}

