/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.refactoring.formatter;

import groovyjarjarantlr.Token;
import java.util.Arrays;
import java.util.List;
import org.codehaus.groovy.antlr.GroovyTokenTypeBridge;
import org.codehaus.groovy.eclipse.core.GroovyCore;
import org.codehaus.groovy.eclipse.refactoring.formatter.GroovyDocumentScanner;
import org.codehaus.groovy.eclipse.refactoring.formatter.GroovyFormatter;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;

public class SemicolonRemover
extends GroovyFormatter {
    private final GroovyDocumentScanner scanner;
    private final MultiTextEdit edits;

    public SemicolonRemover(ITextSelection sel, IDocument doc) {
        this(sel, doc, new MultiTextEdit());
    }

    public SemicolonRemover(ITextSelection sel, IDocument doc, MultiTextEdit edits) {
        super(sel, doc);
        this.edits = edits;
        this.scanner = new GroovyDocumentScanner(doc);
    }

    @Override
    public TextEdit format() {
        try {
            try {
                List<Token> tokens = this.scanner.getTokens(this.selection);
                for (Token token : tokens) {
                    Token nextToken = this.scanner.getNextToken(token);
                    if (!this.isSemicolon(token) || nextToken != null && !this.isDelimiter(nextToken)) continue;
                    this.addSemicolonRemoval(token);
                }
            }
            catch (BadLocationException e) {
                GroovyCore.logException("Cannot perform semicolon removal.", e);
                this.scanner.dispose();
            }
        }
        finally {
            this.scanner.dispose();
        }
        return this.edits;
    }

    private boolean isSemicolon(Token token) {
        return token != null && token.getType() == GroovyTokenTypeBridge.SEMI;
    }

    private boolean isDelimiter(Token token) {
        List<Integer> delimiterTypes = Arrays.asList(GroovyTokenTypeBridge.RCURLY, GroovyTokenTypeBridge.NLS, GroovyTokenTypeBridge.EOF);
        return token != null && delimiterTypes.contains(token.getType());
    }

    private void addSemicolonRemoval(Token semicolonToken) throws BadLocationException {
        int semicolonOffset = this.scanner.getOffset(semicolonToken);
        DeleteEdit deleteSemicolon = new DeleteEdit(semicolonOffset, 1);
        try {
            this.edits.addChild((TextEdit)deleteSemicolon);
        }
        catch (MalformedTreeException e) {
            GroovyCore.logWarning("Ignoring conflicting edit: " + deleteSemicolon, e);
        }
    }
}

